/*
 * Decompiled with CFR 0.152.
 */
package org.forester.evoinference.distance;

import org.forester.evoinference.matrix.distance.BasicSymmetricalDistanceMatrix;
import org.forester.msa.Msa;

public final class PairwiseDistanceCalculator {
    public static final double DEFAULT_VALUE_FOR_TOO_LARGE_DISTANCE_FOR_KIMURA_FORMULA = 10.0;
    private final Msa _msa;
    private final double _value_for_too_large_distance_for_kimura_formula;

    private PairwiseDistanceCalculator(Msa msa, double value_for_too_large_distance_for_kimura_formula) {
        this._msa = msa;
        this._value_for_too_large_distance_for_kimura_formula = value_for_too_large_distance_for_kimura_formula;
    }

    private double calcFractionalDissimilarity(int row_1, int row_2) {
        int length = this._msa.getLength();
        int nd = 0;
        for (int col = 0; col < length; ++col) {
            if (this._msa.getResidueAt(row_1, col) == this._msa.getResidueAt(row_2, col)) continue;
            ++nd;
        }
        return (double)nd / (double)length;
    }

    private double calcKimuraDistance(int row_1, int row_2) {
        double p = this.calcFractionalDissimilarity(row_1, row_2);
        double dp = 1.0 - p - 0.2 * p * p;
        if (dp <= 0.0) {
            return this._value_for_too_large_distance_for_kimura_formula;
        }
        if (dp == 1.0) {
            return 0.0;
        }
        return -Math.log(dp);
    }

    private double calcPoissonDistance(int row_1, int row_2) {
        double p = this.calcFractionalDissimilarity(row_1, row_2);
        double dp = 1.0 - p;
        if (dp <= 0.0) {
            return this._value_for_too_large_distance_for_kimura_formula;
        }
        if (dp == 1.0) {
            return 0.0;
        }
        return -Math.log(dp);
    }

    private BasicSymmetricalDistanceMatrix calcKimuraDistances() {
        int s = this._msa.getNumberOfSequences();
        BasicSymmetricalDistanceMatrix d = new BasicSymmetricalDistanceMatrix(s);
        this.copyIdentifiers(s, d);
        this.calcKimuraDistances(s, d);
        return d;
    }

    private BasicSymmetricalDistanceMatrix calcPoissonDistances() {
        int s = this._msa.getNumberOfSequences();
        BasicSymmetricalDistanceMatrix d = new BasicSymmetricalDistanceMatrix(s);
        this.copyIdentifiers(s, d);
        this.calcPoissonDistances(s, d);
        return d;
    }

    private BasicSymmetricalDistanceMatrix calcFractionalDissimilarities() {
        int s = this._msa.getNumberOfSequences();
        BasicSymmetricalDistanceMatrix d = new BasicSymmetricalDistanceMatrix(s);
        this.copyIdentifiers(s, d);
        this.calcFractionalDissimilarities(s, d);
        return d;
    }

    private void calcKimuraDistances(int s, BasicSymmetricalDistanceMatrix d) {
        for (int i = 1; i < s; ++i) {
            for (int j = 0; j < i; ++j) {
                d.setValue(i, j, this.calcKimuraDistance(i, j));
            }
        }
    }

    private void calcPoissonDistances(int s, BasicSymmetricalDistanceMatrix d) {
        for (int i = 1; i < s; ++i) {
            for (int j = 0; j < i; ++j) {
                d.setValue(i, j, this.calcPoissonDistance(i, j));
            }
        }
    }

    private void calcFractionalDissimilarities(int s, BasicSymmetricalDistanceMatrix d) {
        for (int i = 1; i < s; ++i) {
            for (int j = 0; j < i; ++j) {
                d.setValue(i, j, this.calcFractionalDissimilarity(i, j));
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    private void copyIdentifiers(int s, BasicSymmetricalDistanceMatrix d) {
        for (int i = 0; i < s; ++i) {
            d.setIdentifier(i, this._msa.getIdentifier(i));
        }
    }

    public static BasicSymmetricalDistanceMatrix calcFractionalDissimilarities(Msa msa) {
        return new PairwiseDistanceCalculator(msa, 10.0).calcFractionalDissimilarities();
    }

    public static BasicSymmetricalDistanceMatrix calcPoissonDistances(Msa msa) {
        return new PairwiseDistanceCalculator(msa, 10.0).calcPoissonDistances();
    }

    public static BasicSymmetricalDistanceMatrix calcKimuraDistances(Msa msa) {
        return new PairwiseDistanceCalculator(msa, 10.0).calcKimuraDistances();
    }

    public static BasicSymmetricalDistanceMatrix calcKimuraDistances(Msa msa, double value_for_too_large_distance_for_kimura_formula) {
        return new PairwiseDistanceCalculator(msa, value_for_too_large_distance_for_kimura_formula).calcKimuraDistances();
    }

    public static enum PWD_DISTANCE_METHOD {
        KIMURA_DISTANCE,
        POISSON_DISTANCE,
        FRACTIONAL_DISSIMILARITY;

    }
}

