/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.parsers;

import java.io.IOException;
import java.util.List;
import org.forester.evoinference.matrix.distance.BasicSymmetricalDistanceMatrix;
import org.forester.evoinference.matrix.distance.DistanceMatrix;
import org.forester.util.BasicTable;
import org.forester.util.BasicTableParser;
import org.forester.util.ForesterUtil;

public class SymmetricalDistanceMatrixParser {
    private static final InputMatrixType INPUT_MATRIX_TYPE_DEFAULT = InputMatrixType.LOWER_TRIANGLE;
    private static final String COMMENT = "#";
    private static final char VALUE_SEPARATOR = ' ';
    private int _matrix_size;
    private InputMatrixType _input_matrix_type;

    private SymmetricalDistanceMatrixParser() {
        this.init();
    }

    private void checkValueIsZero(BasicTable<String> table, int row, int i, int start_row) throws IOException {
        double d = 0.0;
        String table_value = table.getValue(i, row + start_row);
        if (ForesterUtil.isEmpty(table_value)) {
            throw new IOException("value is null or empty at [" + (i - 1) + ", " + row + "]");
        }
        try {
            d = Double.parseDouble(table_value);
        }
        catch (NumberFormatException e) {
            throw new IOException("illegal format for distance [" + table_value + "] at [" + (i - 1) + ", " + row + "]");
        }
        if (!ForesterUtil.isEqual(0.0, d)) {
            throw new IOException("attempt to use non-zero diagonal value [" + table_value + "] at [" + (i - 1) + ", " + row + "]");
        }
    }

    private InputMatrixType getInputMatrixType() {
        return this._input_matrix_type;
    }

    private int getMatrixSize() {
        return this._matrix_size;
    }

    private void init() {
        this.setInputMatrixType(INPUT_MATRIX_TYPE_DEFAULT);
        this.reset();
    }

    public DistanceMatrix[] parse(Object source) throws IOException {
        this.reset();
        List<BasicTable<String>> tables = BasicTableParser.parse(source, ' ', false, false, COMMENT, true);
        DistanceMatrix[] distance_matrices = new DistanceMatrix[tables.size()];
        int i = 0;
        for (BasicTable<String> table : tables) {
            distance_matrices[i++] = this.transform(table);
        }
        return distance_matrices;
    }

    private void reset() {
        this.setMatrixSize(-1);
    }

    public void setInputMatrixType(InputMatrixType input_matrix_type) {
        this._input_matrix_type = input_matrix_type;
    }

    private void setMatrixSize(int matrix_size) {
        this._matrix_size = matrix_size;
    }

    private void transferValue(BasicTable<String> table, DistanceMatrix distance_matrix, int row, int col, int start_row, int col_offset) throws IOException {
        double d = 0.0;
        String table_value = table.getValue(col, row + start_row);
        if (ForesterUtil.isEmpty(table_value)) {
            throw new IOException("value is null or empty at [" + (col - 1) + ", " + row + "]");
        }
        try {
            d = Double.parseDouble(table_value);
        }
        catch (NumberFormatException e) {
            throw new IOException("illegal format for distance [" + table_value + "] at [" + (col - 1) + ", " + row + "]");
        }
        distance_matrix.setValue(col - 1 + col_offset, row, d);
    }

    private DistanceMatrix transform(BasicTable<String> table) throws IllegalArgumentException, IOException {
        boolean first_line_is_size = false;
        if (table.getNumberOfColumns() < 3) {
            throw new IllegalArgumentException("attempt to create distance matrix with with less than 3 columns [columns: " + table.getNumberOfColumns() + ", rows: " + table.getNumberOfRows() + "]");
        }
        if (table.getNumberOfColumns() == table.getNumberOfRows()) {
            first_line_is_size = true;
        } else if (table.getNumberOfColumns() != table.getNumberOfRows() + 1) {
            throw new IllegalArgumentException("attempt to create distance matrix with illegal dimensions [columns: " + table.getNumberOfColumns() + ", rows: " + table.getNumberOfRows() + "]");
        }
        BasicSymmetricalDistanceMatrix distance_matrix = new BasicSymmetricalDistanceMatrix(table.getNumberOfColumns() - 1);
        int start_row = 0;
        if (first_line_is_size) {
            start_row = 1;
        }
        block4: for (int row = 0; row < table.getNumberOfRows() - start_row; ++row) {
            distance_matrix.setIdentifier(row, table.getValue(0, row + start_row));
            switch (this.getInputMatrixType()) {
                case LOWER_TRIANGLE: {
                    int col;
                    for (col = 1; col <= row; ++col) {
                        this.transferValue(table, distance_matrix, row, col, start_row, 0);
                    }
                    this.checkValueIsZero(table, row, row + 1, start_row);
                    continue block4;
                }
                case UPPER_TRIANGLE: {
                    int col;
                    for (col = 1; col < table.getNumberOfColumns() - row; ++col) {
                        this.transferValue(table, distance_matrix, row, col, start_row, row);
                    }
                    continue block4;
                }
                default: {
                    throw new AssertionError((Object)("unkwnown input matrix type [" + (Object)((Object)this.getInputMatrixType()) + "]"));
                }
            }
        }
        if (this.getMatrixSize() < 1) {
            this.setMatrixSize(distance_matrix.getSize());
        } else if (this.getMatrixSize() != distance_matrix.getSize()) {
            throw new IOException("attempt to use matrices of unequal size: [" + this.getMatrixSize() + "] vs [" + distance_matrix.getSize() + "]");
        }
        return distance_matrix;
    }

    public static SymmetricalDistanceMatrixParser createInstance() {
        return new SymmetricalDistanceMatrixParser();
    }

    public static enum InputMatrixType {
        UPPER_TRIANGLE,
        LOWER_TRIANGLE;

    }
}

