/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.parsers.phyloxml.data;

import org.forester.io.parsers.phyloxml.PhyloXmlDataFormatException;
import org.forester.io.parsers.phyloxml.XmlElement;
import org.forester.io.parsers.phyloxml.data.PhylogenyDataPhyloXmlParser;
import org.forester.phylogeny.data.Confidence;
import org.forester.phylogeny.data.PhylogenyData;

public class ConfidenceParser
implements PhylogenyDataPhyloXmlParser {
    private static final PhylogenyDataPhyloXmlParser _instance;

    private ConfidenceParser() {
    }

    @Override
    public PhylogenyData parse(XmlElement element) throws PhyloXmlDataFormatException {
        Confidence confidence = new Confidence();
        confidence.setValue(element.getValueAsDouble());
        if (element.isHasAttribute("type")) {
            confidence.setType(element.getAttribute("type"));
        }
        if (element.isHasAttribute("stddev")) {
            try {
                confidence.setStandardDeviation(Double.parseDouble(element.getAttribute("stddev")));
            }
            catch (NumberFormatException ex) {
                throw new PhyloXmlDataFormatException("attempt to parse [" + element.getAttribute("stddev] into double"));
            }
        }
        return confidence;
    }

    public static PhylogenyDataPhyloXmlParser getInstance() {
        return _instance;
    }

    static {
        try {
            _instance = new ConfidenceParser();
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

