/*
 * Decompiled with CFR 0.152.
 */
package org.forester.msa;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.forester.io.writers.SequenceWriter;
import org.forester.msa.Msa;
import org.forester.sequence.BasicSequence;
import org.forester.sequence.MolecularSequence;
import org.forester.util.ForesterUtil;

public class BasicMsa
implements Msa {
    private final char[][] _data;
    private final String[] _identifiers;
    private final Set<String> _identifiers_set;
    private final MolecularSequence.TYPE _type;

    public BasicMsa(int rows, int columns, MolecularSequence.TYPE type) {
        if (rows < 1 || columns < 1) {
            throw new IllegalArgumentException("basic msa of size zero are illegal");
        }
        this._data = new char[rows][columns];
        this._identifiers = new String[rows];
        this._identifiers_set = new HashSet<String>();
        this._type = type;
    }

    BasicMsa(BasicMsa msa) {
        this._data = msa._data;
        this._identifiers = msa._identifiers;
        this._type = msa._type;
        this._identifiers_set = msa._identifiers_set;
    }

    @Override
    public List<MolecularSequence> asSequenceList() {
        ArrayList<MolecularSequence> seqs = new ArrayList<MolecularSequence>();
        for (int i = 0; i < this.getNumberOfSequences(); ++i) {
            seqs.add(this.getSequence(i));
        }
        return seqs;
    }

    @Override
    public List<Character> getColumnAt(int col) {
        ArrayList<Character> column = new ArrayList<Character>();
        for (int row = 0; row < this.getNumberOfSequences(); ++row) {
            column.add(Character.valueOf(this.getResidueAt(row, col)));
        }
        return column;
    }

    @Override
    public String getIdentifier(int row) {
        return this._identifiers[row];
    }

    @Override
    public int getLength() {
        return this._data[0].length;
    }

    @Override
    public int getNumberOfSequences() {
        return this._identifiers.length;
    }

    @Override
    public char getResidueAt(int row, int col) {
        return this._data[row][col];
    }

    @Override
    public MolecularSequence getSequence(int row) {
        return new BasicSequence(this.getIdentifier(row), this._data[row], this.getType());
    }

    @Override
    public MolecularSequence getSequence(String id) {
        for (int i = 0; i < this.getNumberOfSequences(); ++i) {
            if (!this.getIdentifier(i).equals(id)) continue;
            return this.getSequence(i);
        }
        return null;
    }

    @Override
    public StringBuffer getSequenceAsString(int row) {
        StringBuffer sb = new StringBuffer(this.getLength());
        for (int col = 0; col < this.getLength(); ++col) {
            sb.append(this.getResidueAt(row, col));
        }
        return sb;
    }

    @Override
    public MolecularSequence.TYPE getType() {
        return this._type;
    }

    @Override
    public boolean isGapAt(int row, int col) {
        return this.getResidueAt(row, col) == '-';
    }

    @Override
    public void setIdentifier(int row, String id) {
        if (ForesterUtil.isEmpty(id)) {
            throw new IllegalArgumentException("illegal attempt to create msa with empty identifier");
        }
        if (this._identifiers_set.contains(id)) {
            throw new IllegalArgumentException("illegal attempt to create msa with non-unique identifiers [" + id + "]");
        }
        this._identifiers_set.add(id);
        this._identifiers[row] = id;
    }

    @Override
    public void setResidueAt(int row, int col, char residue) {
        this._data[row][col] = residue;
    }

    public String toString() {
        StringWriter w = new StringWriter();
        try {
            this.write(w, Msa.MSA_FORMAT.PHYLIP);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ((Object)w).toString();
    }

    @Override
    public void write(Writer w, Msa.MSA_FORMAT format) throws IOException {
        switch (format) {
            case PHYLIP: {
                this.writeToPhylip(w);
                break;
            }
            case FASTA: {
                this.writeToFasta(w);
                break;
            }
            case NEXUS: {
                this.writeToNexus(w);
                break;
            }
            default: {
                throw new RuntimeException("unknown format " + (Object)((Object)format));
            }
        }
    }

    private short determineMaxIdLength() {
        short max = 0;
        for (int row = 0; row < this.getNumberOfSequences(); ++row) {
            short l = (short)this.getIdentifier(row).length();
            if (l <= max) continue;
            max = l;
        }
        return max;
    }

    private void writeToFasta(Writer w) throws IOException {
        SequenceWriter.writeSeqs(this.asSequenceList(), w, SequenceWriter.SEQ_FORMAT.FASTA, 100);
    }

    private void writeToNexus(Writer w) throws IOException {
        int max = this.determineMaxIdLength() + 1;
        w.write("Begin Data;");
        w.write(ForesterUtil.LINE_SEPARATOR);
        w.write("   Dimensions NTax=" + this.getNumberOfSequences());
        w.write(" NChar=" + this.getLength());
        w.write(";");
        w.write(ForesterUtil.LINE_SEPARATOR);
        w.write("   Format DataType=Protein Interleave=No gap=-;");
        w.write(ForesterUtil.LINE_SEPARATOR);
        w.write("   Matrix");
        w.write(ForesterUtil.LINE_SEPARATOR);
        for (int row = 0; row < this.getNumberOfSequences(); ++row) {
            MolecularSequence seq = this.getSequence(row);
            String s = seq.getMolecularSequenceAsString();
            w.write("      ");
            w.write(ForesterUtil.pad(this.getIdentifier(row).replace(' ', '_'), max, ' ', false).toString());
            w.write(" ");
            w.write(s);
            w.write(ForesterUtil.LINE_SEPARATOR);
        }
        w.write("   ;");
        w.write(ForesterUtil.LINE_SEPARATOR);
        w.write("End;");
        w.write(ForesterUtil.LINE_SEPARATOR);
    }

    private void writeToPhylip(Writer w) throws IOException {
        int max = this.determineMaxIdLength() + 1;
        w.write(this.getNumberOfSequences() + " " + this.getLength());
        w.write(ForesterUtil.LINE_SEPARATOR);
        for (int row = 0; row < this.getNumberOfSequences(); ++row) {
            w.write(ForesterUtil.pad(this.getIdentifier(row).replace(' ', '_'), max, ' ', false).toString());
            for (int col = 0; col < this.getLength(); ++col) {
                w.write(this.getResidueAt(row, col));
            }
            w.write(ForesterUtil.LINE_SEPARATOR);
        }
    }

    public static Msa createInstance(List<MolecularSequence> seqs) {
        if (seqs.size() < 1) {
            throw new IllegalArgumentException("cannot create msa from less than one sequence");
        }
        int length = seqs.get(0).getLength();
        BasicMsa msa = new BasicMsa(seqs.size(), length, seqs.get(0).getType());
        for (int row = 0; row < seqs.size(); ++row) {
            MolecularSequence seq = seqs.get(row);
            if (seq.getLength() != length) {
                throw new IllegalArgumentException("illegal attempt to build msa from sequences of unequal length [" + seq.getIdentifier() + "]");
            }
            if (seq.getType() != msa.getType()) {
                throw new IllegalArgumentException("illegal attempt to build msa from sequences of different type [" + seq.getIdentifier() + "]");
            }
            msa.setIdentifier(row, seq.getIdentifier());
            for (int col = 0; col < length; ++col) {
                msa._data[row][col] = seq.getResidueAt(col);
            }
        }
        return msa;
    }
}

