/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.data;

import java.io.IOException;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;
import org.forester.phylogeny.data.Confidence;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.Sequence;

public class SequenceRelation
implements PhylogenyData {
    public static final Map<SEQUENCE_RELATION_TYPE, String> typesToNames = new LinkedHashMap<SEQUENCE_RELATION_TYPE, String>();
    public static final String SEQUENCE_RELATION_TYPE_ORTHOLOGY = "orthology";
    public static final String SEQUENCE_RELATION_TYPE_ONE_TO_ONE_ORTHOLOGY = "one_to_one_orthology";
    public static final String SEQUENCE_RELATION_TYPE_SUPER_ORTHOLOGY = "super_orthology";
    public static final String SEQUENCE_RELATION_TYPE_PARALOGY = "paralogy";
    public static final String SEQUENCE_RELATION_TYPE_ULTRA_PARALOGY = "ultra_paralogy";
    public static final String SEQUENCE_RELATION_TYPE_XENOLOGY = "xenology";
    public static final String SEQUENCE_RELATION_TYPE_UNKNOWN = "unknown";
    public static final String SEQUENCE_RELATION_TYPE_OTHER = "other";
    private Sequence ref0;
    private Sequence ref1;
    private SEQUENCE_RELATION_TYPE type;
    private Double distance;
    private Confidence confidence;

    @Override
    public StringBuffer asSimpleText() {
        return null;
    }

    @Override
    public StringBuffer asText() {
        return null;
    }

    @Override
    public PhylogenyData copy() {
        return null;
    }

    public Confidence getConfidence() {
        return this.confidence;
    }

    public Double getDistance() {
        return this.distance;
    }

    public Sequence getRef0() {
        return this.ref0;
    }

    public Sequence getRef1() {
        return this.ref1;
    }

    public SEQUENCE_RELATION_TYPE getType() {
        return this.type;
    }

    @Override
    public boolean isEqual(PhylogenyData data) {
        return false;
    }

    public void setConfidence(Confidence confidence) {
        this.confidence = confidence;
    }

    public void setDistance(Double distance) {
        this.distance = distance;
    }

    public void setRef0(Sequence ref0) {
        this.ref0 = ref0;
    }

    public void setRef1(Sequence ref1) {
        this.ref1 = ref1;
    }

    public void setType(SEQUENCE_RELATION_TYPE type) {
        this.type = type;
    }

    @Override
    public StringBuffer toNHX() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void toPhyloXML(Writer writer, int level, String indentation) throws IOException {
    }

    public static String getPrintableNameByType(SEQUENCE_RELATION_TYPE type) {
        String s = typesToNames.get((Object)type);
        if (s != null && (s = s.replace('_', ' ')).length() > 15 && s.toLowerCase().endsWith("ology")) {
            s = s.substring(0, s.length() - 5) + ".";
        }
        return s;
    }

    static {
        typesToNames.put(SEQUENCE_RELATION_TYPE.orthology, SEQUENCE_RELATION_TYPE_ORTHOLOGY);
        typesToNames.put(SEQUENCE_RELATION_TYPE.one_to_one_orthology, SEQUENCE_RELATION_TYPE_ONE_TO_ONE_ORTHOLOGY);
        typesToNames.put(SEQUENCE_RELATION_TYPE.super_orthology, SEQUENCE_RELATION_TYPE_SUPER_ORTHOLOGY);
        typesToNames.put(SEQUENCE_RELATION_TYPE.paralogy, SEQUENCE_RELATION_TYPE_PARALOGY);
        typesToNames.put(SEQUENCE_RELATION_TYPE.ultra_paralogy, SEQUENCE_RELATION_TYPE_ULTRA_PARALOGY);
        typesToNames.put(SEQUENCE_RELATION_TYPE.xenology, SEQUENCE_RELATION_TYPE_XENOLOGY);
        typesToNames.put(SEQUENCE_RELATION_TYPE.unknown, SEQUENCE_RELATION_TYPE_UNKNOWN);
        typesToNames.put(SEQUENCE_RELATION_TYPE.other, SEQUENCE_RELATION_TYPE_OTHER);
    }

    public static enum SEQUENCE_RELATION_TYPE {
        orthology,
        one_to_one_orthology,
        super_orthology,
        paralogy,
        ultra_paralogy,
        xenology,
        unknown,
        other;

    }
}

