/*
 * Decompiled with CFR 0.152.
 */
package org.forester.protein;

import java.util.HashMap;
import java.util.Map;
import org.forester.protein.Domain;
import org.forester.util.ForesterUtil;

public class BasicDomain
implements Domain {
    private static short COUNT = 0;
    private static final Map<Short, String> ID_TO_STRING = new HashMap<Short, String>();
    private static final Map<String, Short> STRING_TO_ID = new HashMap<String, Short>();
    private final int _from;
    private final short _id;
    private final short _number;
    private final double _per_domain_evalue;
    private final double _per_domain_score;
    private final int _to;
    private final short _total_count;

    public BasicDomain(String id) {
        if (ForesterUtil.isEmpty(id)) {
            throw new IllegalArgumentException("attempt to create protein domain with null or empty id");
        }
        this._id = BasicDomain.obtainIdAsShort(id);
        this._from = -1;
        this._to = -1;
        this._number = (short)-1;
        this._total_count = (short)-1;
        this._per_domain_evalue = -1.0;
        this._per_domain_score = -1.0;
    }

    public BasicDomain(String id, int from, int to, short number, short total_count, double per_domain_evalue, double per_domain_score) {
        if (from >= to || from < 0) {
            throw new IllegalArgumentException("attempt to create protein domain from " + from + " to " + to);
        }
        if (ForesterUtil.isEmpty(id)) {
            throw new IllegalArgumentException("attempt to create protein domain with null or empty id");
        }
        if (number > total_count || number < 0) {
            throw new IllegalArgumentException("attempt to create protein domain number " + number + " out of " + total_count);
        }
        if (per_domain_evalue < 0.0) {
            throw new IllegalArgumentException("attempt to create protein domain with negative E-value");
        }
        this._id = BasicDomain.obtainIdAsShort(id);
        this._from = from;
        this._to = to;
        this._number = number;
        this._total_count = total_count;
        this._per_domain_evalue = per_domain_evalue;
        this._per_domain_score = per_domain_score;
    }

    @Override
    public int compareTo(Domain domain) {
        if (domain.getClass() != this.getClass()) {
            throw new IllegalArgumentException("attempt to compare [" + domain.getClass() + "] to " + "[" + this.getClass() + "]");
        }
        if (this == domain) {
            return 0;
        }
        return this.getDomainId().compareTo(domain.getDomainId());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            throw new IllegalArgumentException("attempt to check [" + this.getClass() + "] equality to null");
        }
        if (o.getClass() != this.getClass()) {
            throw new IllegalArgumentException("attempt to check [" + this.getClass() + "] equality to " + o + " [" + o.getClass() + "]");
        }
        return this.getDomainId().equals(((Domain)o).getDomainId());
    }

    @Override
    public String getDomainId() {
        return BasicDomain.obtainIdFromShort(this._id);
    }

    @Override
    public int getFrom() {
        return this._from;
    }

    @Override
    public int getLength() {
        return 1 + this.getTo() - this.getFrom();
    }

    @Override
    public short getNumber() {
        return this._number;
    }

    @Override
    public double getPerDomainEvalue() {
        return this._per_domain_evalue;
    }

    @Override
    public double getPerDomainScore() {
        return this._per_domain_score;
    }

    @Override
    public int getTo() {
        return this._to;
    }

    @Override
    public short getTotalCount() {
        return this._total_count;
    }

    public int hashCode() {
        return this.getDomainId().hashCode();
    }

    public String toString() {
        return this.getDomainId();
    }

    public StringBuffer toStringBuffer() {
        return new StringBuffer(this.getDomainId());
    }

    public static final short obtainIdAsShort(String id) {
        if (!STRING_TO_ID.containsKey(id)) {
            if (COUNT >= 32765) {
                throw new RuntimeException("too many domain ids!");
            }
            ID_TO_STRING.put(COUNT, id);
            STRING_TO_ID.put(id, COUNT);
            COUNT = (short)(COUNT + 1);
        }
        return STRING_TO_ID.get(id);
    }

    public static final String obtainIdFromShort(short id) {
        return ID_TO_STRING.get(id);
    }
}

