/*
 * Decompiled with CFR 0.152.
 */
package org.forester.surfacing;

import java.util.HashMap;
import java.util.Map;
import org.forester.protein.BasicDomain;
import org.forester.surfacing.BasicBinaryDomainCombination;

public class AdjactantDirectedBinaryDomainCombination
extends BasicBinaryDomainCombination {
    private static final Map<Integer, AdjactantDirectedBinaryDomainCombination> ADDC_POOL = new HashMap<Integer, AdjactantDirectedBinaryDomainCombination>();

    private AdjactantDirectedBinaryDomainCombination(String n_terminal, String c_terminal) {
        if (n_terminal == null || c_terminal == null) {
            throw new IllegalArgumentException("attempt to create binary domain combination using null");
        }
        this._id0 = BasicDomain.obtainIdAsShort(n_terminal);
        this._id1 = BasicDomain.obtainIdAsShort(c_terminal);
    }

    public static final AdjactantDirectedBinaryDomainCombination obtainInstance(String ids) {
        if (ids.indexOf("=") < 1) {
            throw new IllegalArgumentException("Unexpected format for binary domain combination [" + ids + "]");
        }
        String[] ids_ary = ids.split("=");
        if (ids_ary.length != 2) {
            throw new IllegalArgumentException("Unexpected format for binary domain combination [" + ids + "]");
        }
        return AdjactantDirectedBinaryDomainCombination.obtainInstance(ids_ary[0], ids_ary[1]);
    }

    public static final AdjactantDirectedBinaryDomainCombination obtainInstance(String n_terminal, String c_terminal) {
        int code = AdjactantDirectedBinaryDomainCombination.calcCode(BasicDomain.obtainIdAsShort(n_terminal), BasicDomain.obtainIdAsShort(c_terminal));
        if (ADDC_POOL.containsKey(code)) {
            return ADDC_POOL.get(code);
        }
        AdjactantDirectedBinaryDomainCombination dc = new AdjactantDirectedBinaryDomainCombination(n_terminal, c_terminal);
        ADDC_POOL.put(code, dc);
        return dc;
    }
}

