/*
 * Decompiled with CFR 0.152.
 */
package org.forester.surfacing;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.forester.protein.BinaryDomainCombination;
import org.forester.species.Species;
import org.forester.surfacing.BasicBinaryDomainCombination;
import org.forester.surfacing.CombinableDomains;
import org.forester.util.ForesterUtil;

public class BasicCombinableDomains
implements CombinableDomains {
    private final TreeMap<String, Integer> _combining_domains;
    private final String _key_domain;
    private int _key_domain_count;
    private final Set<String> _proteins_with_key_domain;
    private final Species _species;

    public BasicCombinableDomains(String key_domain, Species species) {
        this._key_domain = key_domain;
        this._species = species;
        this._combining_domains = new TreeMap();
        this._proteins_with_key_domain = new HashSet<String>();
        this._key_domain_count = 0;
    }

    @Override
    public void addCombinableDomain(String protein_domain) {
        if (this.getCombiningDomains().containsKey(protein_domain)) {
            this.getCombiningDomains().put(protein_domain, this.getCombiningDomains().get(protein_domain) + 1);
        } else {
            this.getCombiningDomains().put(protein_domain, 1);
        }
    }

    @Override
    public void addKeyDomainProtein(String protein) {
        if (ForesterUtil.isEmpty(protein)) {
            throw new IllegalArgumentException("attempt to add null or empty protein");
        }
        this.getKeyDomainProteins().add(protein);
    }

    @Override
    public List<String> getAllDomains() {
        List<String> domains = this.getCombinableDomains();
        if (!domains.contains(this.getKeyDomain())) {
            domains.add(this.getKeyDomain());
        }
        return domains;
    }

    @Override
    public List<String> getCombinableDomains() {
        ArrayList<String> domains = new ArrayList<String>(this.getNumberOfCombinableDomains());
        for (String domain : this.getCombiningDomains().keySet()) {
            domains.add(domain);
        }
        return domains;
    }

    @Override
    public SortedMap<String, Integer> getCombinableDomainsIds() {
        TreeMap<String, Integer> ids = new TreeMap<String, Integer>();
        Iterator<String> iterator = this.getCombiningDomains().keySet().iterator();
        while (iterator.hasNext()) {
            String domain;
            String pd = domain = iterator.next();
            ids.put(pd, this.getCombiningDomains().get(pd));
        }
        return ids;
    }

    @Override
    public StringBuilder getCombiningDomainIdsAsStringBuilder() {
        StringBuilder sb = new StringBuilder();
        Iterator<String> iter = this.getCombiningDomains().keySet().iterator();
        while (iter.hasNext()) {
            String key = iter.next();
            sb.append(key.toString());
            sb.append(" [");
            int count = this.getCombiningDomains().get(key);
            sb.append(count);
            sb.append("]");
            if (!iter.hasNext()) continue;
            sb.append(", ");
        }
        return sb;
    }

    @Override
    public String getKeyDomain() {
        return this._key_domain;
    }

    @Override
    public int getKeyDomainCount() {
        return this._key_domain_count;
    }

    @Override
    public Set<String> getKeyDomainProteins() {
        return this._proteins_with_key_domain;
    }

    @Override
    public int getKeyDomainProteinsCount() {
        return this.getKeyDomainProteins().size();
    }

    @Override
    public int getNumberOfCombinableDomains() {
        return this._combining_domains.size();
    }

    @Override
    public int getNumberOfProteinsExhibitingCombination(String protein_domain) {
        if (this.getCombiningDomains().containsKey(protein_domain)) {
            return this.getCombiningDomains().get(protein_domain);
        }
        return 0;
    }

    @Override
    public Species getSpecies() {
        return this._species;
    }

    @Override
    public boolean isCombinable(String protein_domain) {
        return this.getCombiningDomains().containsKey(protein_domain);
    }

    @Override
    public void setKeyDomainCount(int key_domain_count) {
        this._key_domain_count = key_domain_count;
    }

    @Override
    public List<BinaryDomainCombination> toBinaryDomainCombinations() {
        ArrayList<BinaryDomainCombination> binary_combinations = new ArrayList<BinaryDomainCombination>(this.getNumberOfCombinableDomains());
        for (String domain : this.getCombiningDomains().keySet()) {
            binary_combinations.add(BasicBinaryDomainCombination.obtainInstance(this.getKeyDomain(), domain));
        }
        return binary_combinations;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getKeyDomain());
        sb.append(" [");
        sb.append(this.getKeyDomainCount());
        sb.append(", ");
        sb.append(this.getKeyDomainProteinsCount());
        sb.append(", ");
        sb.append(this.getNumberOfCombinableDomains());
        sb.append("]: ");
        sb.append((CharSequence)this.getCombiningDomainIdsAsStringBuilder());
        return sb.toString();
    }

    protected TreeMap<String, Integer> getCombiningDomains() {
        return this._combining_domains;
    }
}

