/*
 * Decompiled with CFR 0.152.
 */
package org.forester.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.forester.util.BasicTable;
import org.forester.util.ForesterUtil;

public class BasicTableParser {
    private static final String START_OF_COMMENT_LINE_DEFAULT = "#";

    private BasicTableParser() {
    }

    public static BasicTable<String> parse(Object source, char column_delimiter) throws IOException {
        return BasicTableParser.parse(source, column_delimiter, false, false, START_OF_COMMENT_LINE_DEFAULT, false).get(0);
    }

    public static BasicTable<String> parse(Object source, char column_delimiter, boolean use_first_separator_only, boolean use_last_separator_only) throws IOException {
        return BasicTableParser.parse(source, column_delimiter, use_first_separator_only, use_last_separator_only, START_OF_COMMENT_LINE_DEFAULT, false).get(0);
    }

    public static List<BasicTable<String>> parse(Object source, char column_delimiter, boolean use_first_separator_only, boolean use_last_separator_only, String start_of_comment_line, boolean tables_separated_by_single_string_line) throws IOException {
        String line;
        boolean use_start_of_comment_line;
        if (use_first_separator_only && use_last_separator_only) {
            throw new IllegalArgumentException();
        }
        BufferedReader reader = ForesterUtil.obtainReader(source);
        ArrayList<BasicTable<String>> tables = new ArrayList<BasicTable<String>>();
        BasicTable<String> table = new BasicTable<String>();
        int row = 0;
        boolean saw_first_table = false;
        boolean bl = use_start_of_comment_line = !ForesterUtil.isEmpty(start_of_comment_line);
        while ((line = reader.readLine()) != null) {
            if (!ForesterUtil.isEmpty(line = line.trim()) && (line.charAt(0) == '\"' && line.charAt(line.length() - 1) == '\"' && ForesterUtil.countChars(line, '\"') == 2 || line.charAt(0) == '\'' && line.charAt(line.length() - 1) == '\'' && ForesterUtil.countChars(line, '\'') == 2)) {
                line = line.substring(1, line.length() - 1).trim();
            }
            if (saw_first_table && (ForesterUtil.isEmpty(line) || tables_separated_by_single_string_line && line.indexOf(column_delimiter) < 0)) {
                if (!table.isEmpty()) {
                    tables.add(table);
                }
                table = new BasicTable();
                row = 0;
                continue;
            }
            if (ForesterUtil.isEmpty(line) || use_start_of_comment_line && line.startsWith(start_of_comment_line)) continue;
            saw_first_table = true;
            if (use_last_separator_only) {
                String[] e = line.split(column_delimiter + "");
                StringBuffer rest = new StringBuffer();
                for (int i = 0; i < e.length - 1; ++i) {
                    rest.append(e[i].trim());
                }
                table.setValue(0, row, rest.toString());
                table.setValue(1, row, e[e.length - 1]);
            } else {
                StringTokenizer st = new StringTokenizer(line, column_delimiter + "");
                int col = 0;
                if (st.hasMoreTokens()) {
                    table.setValue(col++, row, st.nextToken().trim());
                }
                if (use_first_separator_only) {
                    StringBuffer rest = new StringBuffer();
                    while (st.hasMoreTokens()) {
                        rest.append(st.nextToken());
                    }
                    table.setValue(col++, row, rest.toString());
                } else {
                    while (st.hasMoreTokens()) {
                        table.setValue(col++, row, st.nextToken().trim());
                    }
                }
            }
            ++row;
        }
        if (!table.isEmpty()) {
            tables.add(table);
        }
        reader.close();
        return tables;
    }
}

