/*
 * Decompiled with CFR 0.152.
 */
package org.forester.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ExternalProgram {
    private Process _process;
    private final String _path_to_cmd;

    public static boolean isExecuteableFile(File path_to_cmd_f) {
        if (!path_to_cmd_f.exists()) {
            return false;
        }
        if (path_to_cmd_f.isDirectory()) {
            return false;
        }
        return path_to_cmd_f.canExecute();
    }

    public ExternalProgram(String path_to_cmd) {
        File path_to_cmd_f = new File(path_to_cmd);
        this.checkCmdFile(path_to_cmd_f);
        this._path_to_cmd = path_to_cmd_f.getAbsolutePath();
    }

    private void checkCmdFile(File path_to_cmd_f) {
        if (!path_to_cmd_f.exists()) {
            throw new IllegalArgumentException("[" + path_to_cmd_f.getAbsolutePath() + "] does not exist");
        }
        if (path_to_cmd_f.isDirectory()) {
            throw new IllegalArgumentException("[" + path_to_cmd_f.getAbsolutePath() + "] is a directory");
        }
        if (!path_to_cmd_f.canExecute()) {
            throw new IllegalArgumentException("[" + path_to_cmd_f.getAbsolutePath() + "] is not executeable");
        }
    }

    public InputStream getErrorStream() {
        return this.getProcess().getErrorStream();
    }

    public InputStream getInputStream() {
        return this.getProcess().getInputStream();
    }

    public OutputStream getOutputStream() {
        return this.getProcess().getOutputStream();
    }

    private String getPathToCmd() {
        return this._path_to_cmd;
    }

    private Process getProcess() {
        return this._process;
    }

    public Process launch(String[] opts) throws IOException, InterruptedException {
        String[] cmd;
        if (opts == null || opts.length < 1) {
            cmd = new String[1];
        } else {
            cmd = new String[opts.length + 1];
            for (int i = 0; i < opts.length; ++i) {
                cmd[i + 1] = opts[i];
            }
        }
        cmd[0] = this.getPathToCmd();
        System.out.println();
        for (String element : cmd) {
            System.out.print(element + " ");
        }
        System.out.println();
        this.setProcess(Runtime.getRuntime().exec(cmd));
        return this.getProcess();
    }

    private void setProcess(Process process) {
        this._process = process;
    }

    public int waitFor() {
        try {
            return this.getProcess().waitFor();
        }
        catch (InterruptedException e) {
            this.getProcess().destroy();
            e.printStackTrace();
            return -1;
        }
    }
}

