/*
 * Decompiled with CFR 0.152.
 */
package org.forester.util;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.Writer;
import java.math.BigDecimal;
import java.net.URL;
import java.net.URLConnection;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Distribution;
import org.forester.phylogeny.data.Sequence;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.protein.BasicProtein;
import org.forester.protein.Domain;
import org.forester.protein.Protein;
import org.forester.sequence.MolecularSequence;
import org.forester.surfacing.SurfacingUtil;
import org.forester.util.EasyWriter;
import org.forester.util.TaxonomyColors;

public final class ForesterUtil {
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    public static final NumberFormat FORMATTER_06;
    public static final NumberFormat FORMATTER_3;
    public static final NumberFormat FORMATTER_6;
    public static final NumberFormat FORMATTER_9;
    public static final String JAVA_VENDOR;
    public static final String JAVA_VERSION;
    public static final String LINE_SEPARATOR;
    public static final String NCBI_GI = "http://www.ncbi.nlm.nih.gov/protein/gi:";
    public static final String NCBI_NUCCORE = "http://www.ncbi.nlm.nih.gov/nuccore/";
    public static final String NCBI_PROTEIN = "http://www.ncbi.nlm.nih.gov/protein/";
    public static final BigDecimal NULL_BD;
    public static final String OS_ARCH;
    public static final String OS_NAME;
    public static final String OS_VERSION;
    public static final String PDB = "http://www.pdb.org/pdb/explore/explore.do?pdbId=";
    public static final String UNIPROT_KB = "http://www.uniprot.org/uniprot/";
    public static final double ZERO_DIFF = 1.0E-9;
    private static final Pattern PARANTHESESABLE_NH_CHARS_PATTERN;

    public static final void appendSeparatorIfNotEmpty(StringBuffer sb, char separator) {
        if (sb.length() > 0) {
            sb.append(separator);
        }
    }

    public static final Color calcColor(double value, double min, double max, Color minColor, Color maxColor) {
        if (value < min) {
            value = min;
        }
        if (value > max) {
            value = max;
        }
        double x = ForesterUtil.calculateColorFactor(value, max, min);
        int red = ForesterUtil.calculateColorComponent(minColor.getRed(), maxColor.getRed(), x);
        int green = ForesterUtil.calculateColorComponent(minColor.getGreen(), maxColor.getGreen(), x);
        int blue = ForesterUtil.calculateColorComponent(minColor.getBlue(), maxColor.getBlue(), x);
        return new Color(red, green, blue);
    }

    public static final Color calcColor(double value, double min, double max, double mean, Color minColor, Color maxColor, Color meanColor) {
        if (value < min) {
            value = min;
        }
        if (value > max) {
            value = max;
        }
        if (value < mean) {
            double x = ForesterUtil.calculateColorFactor(value, mean, min);
            int red = ForesterUtil.calculateColorComponent(minColor.getRed(), meanColor.getRed(), x);
            int green = ForesterUtil.calculateColorComponent(minColor.getGreen(), meanColor.getGreen(), x);
            int blue = ForesterUtil.calculateColorComponent(minColor.getBlue(), meanColor.getBlue(), x);
            return new Color(red, green, blue);
        }
        if (value > mean) {
            double x = ForesterUtil.calculateColorFactor(value, max, mean);
            int red = ForesterUtil.calculateColorComponent(meanColor.getRed(), maxColor.getRed(), x);
            int green = ForesterUtil.calculateColorComponent(meanColor.getGreen(), maxColor.getGreen(), x);
            int blue = ForesterUtil.calculateColorComponent(meanColor.getBlue(), maxColor.getBlue(), x);
            return new Color(red, green, blue);
        }
        return meanColor;
    }

    private static final int calculateColorComponent(double smallercolor_component_x, double largercolor_component_x, double x) {
        return (int)(smallercolor_component_x + x * (largercolor_component_x - smallercolor_component_x) / 255.0);
    }

    private static final double calculateColorFactor(double value, double larger, double smaller) {
        return 255.0 * (value - smaller) / (larger - smaller);
    }

    public static int calculateOverlap(Domain domain, List<Boolean> covered_positions) {
        int overlap_count = 0;
        for (int i = domain.getFrom(); i <= domain.getTo(); ++i) {
            if (i >= covered_positions.size() || !covered_positions.get(i).booleanValue()) continue;
            ++overlap_count;
        }
        return overlap_count;
    }

    public static final String collapseWhiteSpace(String s) {
        return s.replaceAll("[\\s]+", " ");
    }

    public static final void collection2file(File file, Collection<?> data, String separator) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        ForesterUtil.collection2writer(writer, data, separator);
        ((Writer)writer).close();
    }

    public static final void collection2writer(Writer writer, Collection<?> data, String separator) throws IOException {
        boolean first = true;
        for (Object object : data) {
            if (!first) {
                writer.write(separator);
            } else {
                first = false;
            }
            writer.write(object.toString());
        }
    }

    public static final String colorToHex(Color color) {
        String rgb = Integer.toHexString(color.getRGB());
        return rgb.substring(2, rgb.length());
    }

    public static synchronized void copyFile(File in, File out) throws IOException {
        FileInputStream in_s = new FileInputStream(in);
        FileOutputStream out_s = new FileOutputStream(out);
        try {
            byte[] buf = new byte[1024];
            int i = 0;
            while ((i = in_s.read(buf)) != -1) {
                out_s.write(buf, 0, i);
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (in_s != null) {
                in_s.close();
            }
            if (out_s != null) {
                out_s.close();
            }
        }
    }

    public static final int countChars(String str, char c) {
        int count = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != c) continue;
            ++count;
        }
        return count;
    }

    public static final BufferedWriter createBufferedWriter(File file) throws IOException {
        if (file.exists()) {
            throw new IOException("[" + file + "] already exists");
        }
        return new BufferedWriter(new FileWriter(file));
    }

    public static final BufferedWriter createBufferedWriter(String name) throws IOException {
        return new BufferedWriter(new FileWriter(ForesterUtil.createFileForWriting(name)));
    }

    public static final EasyWriter createEasyWriter(File file) throws IOException {
        return new EasyWriter(ForesterUtil.createBufferedWriter(file));
    }

    public static final BufferedWriter createEasyWriter(String name) throws IOException {
        return ForesterUtil.createEasyWriter(ForesterUtil.createFileForWriting(name));
    }

    public static final File createFileForWriting(String name) throws IOException {
        File file = new File(name);
        if (file.exists()) {
            throw new IOException("[" + name + "] already exists");
        }
        return file;
    }

    public static final void ensurePresenceOfDate(PhylogenyNode node) {
        if (!node.getNodeData().isHasDate()) {
            node.getNodeData().setDate(new org.forester.phylogeny.data.Date());
        }
    }

    public static final void ensurePresenceOfDistribution(PhylogenyNode node) {
        if (!node.getNodeData().isHasDistribution()) {
            node.getNodeData().setDistribution(new Distribution(""));
        }
    }

    public static void ensurePresenceOfSequence(PhylogenyNode node) {
        if (!node.getNodeData().isHasSequence()) {
            node.getNodeData().setSequence(new Sequence());
        }
    }

    public static void ensurePresenceOfTaxonomy(PhylogenyNode node) {
        if (!node.getNodeData().isHasTaxonomy()) {
            node.getNodeData().setTaxonomy(new Taxonomy());
        }
    }

    public static void fatalError(String message) {
        System.err.println();
        System.err.println("error: " + message);
        System.err.println();
        System.exit(-1);
    }

    public static void fatalError(String prg_name, String message) {
        System.err.println();
        System.err.println("[" + prg_name + "] > " + message);
        System.err.println();
        System.exit(-1);
    }

    public static void fatalErrorIfFileNotReadable(File file) {
        String error = ForesterUtil.isReadableFile(file);
        if (!ForesterUtil.isEmpty(error)) {
            System.err.println();
            System.err.println("error: " + error);
            System.err.println();
            System.exit(-1);
        }
    }

    public static void fatalErrorIfFileNotReadable(String prg_name, File file) {
        String error = ForesterUtil.isReadableFile(file);
        if (!ForesterUtil.isEmpty(error)) {
            System.err.println();
            System.err.println("[" + prg_name + "] > " + error);
            System.err.println();
            System.exit(-1);
        }
    }

    public static String[][] file22dArray(File file) throws IOException {
        String str;
        ArrayList<String> list = new ArrayList<String>();
        BufferedReader in = new BufferedReader(new FileReader(file));
        while ((str = in.readLine()) != null) {
            if ((str = str.trim()).length() <= 0 || str.startsWith("#")) continue;
            list.add(str);
        }
        in.close();
        String[][] ary = new String[list.size()][2];
        Pattern pa = Pattern.compile("(\\S+)\\s+(\\S+)");
        int i = 0;
        for (String s : list) {
            Matcher m = pa.matcher(s);
            if (m.matches()) {
                ary[i][0] = m.group(1);
                ary[i][1] = m.group(2);
                ++i;
                continue;
            }
            throw new IOException("unexpcted format: " + s);
        }
        return ary;
    }

    public static String[] file2array(File file) throws IOException {
        List<String> list = ForesterUtil.file2list(file);
        String[] ary = new String[list.size()];
        int i = 0;
        for (String s : list) {
            ary[i++] = s;
        }
        return ary;
    }

    public static final List<String> file2list(File file) throws IOException {
        String str;
        ArrayList<String> list = new ArrayList<String>();
        BufferedReader in = new BufferedReader(new FileReader(file));
        while ((str = in.readLine()) != null) {
            if ((str = str.trim()).length() <= 0 || str.startsWith("#")) continue;
            for (String s : ForesterUtil.splitString(str)) {
                list.add(s);
            }
        }
        in.close();
        return list;
    }

    public static final SortedSet<String> file2set(File file) throws IOException {
        String str;
        TreeSet<String> set = new TreeSet<String>();
        BufferedReader in = new BufferedReader(new FileReader(file));
        while ((str = in.readLine()) != null) {
            if ((str = str.trim()).length() <= 0 || str.startsWith("#")) continue;
            for (String s : ForesterUtil.splitString(str)) {
                set.add(s);
            }
        }
        in.close();
        return set;
    }

    public static final String getCurrentDateTime() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        return format.format(new Date());
    }

    public static final String getFileSeparator() {
        return FILE_SEPARATOR;
    }

    public static final String getFirstLine(Object source) throws FileNotFoundException, IOException {
        String line;
        BufferedReader reader = null;
        if (source instanceof File) {
            File f = (File)source;
            if (!f.exists()) {
                throw new IOException("[" + f.getAbsolutePath() + "] does not exist");
            }
            if (!f.isFile()) {
                throw new IOException("[" + f.getAbsolutePath() + "] is not a file");
            }
            if (!f.canRead()) {
                throw new IOException("[" + f.getAbsolutePath() + "] is not a readable");
            }
            reader = new BufferedReader(new FileReader(f));
        } else if (source instanceof InputStream) {
            reader = new BufferedReader(new InputStreamReader((InputStream)source));
        } else if (source instanceof String) {
            reader = new BufferedReader(new StringReader((String)source));
        } else if (source instanceof StringBuffer) {
            reader = new BufferedReader(new StringReader(source.toString()));
        } else if (source instanceof URL) {
            URLConnection url_connection = ((URL)source).openConnection();
            url_connection.setDefaultUseCaches(false);
            reader = new BufferedReader(new InputStreamReader(url_connection.getInputStream()));
        } else {
            throw new IllegalArgumentException("dont know how to read [" + source.getClass() + "]");
        }
        while ((line = reader.readLine()) != null) {
            if (ForesterUtil.isEmpty(line = line.trim())) continue;
            if (reader != null) {
                reader.close();
            }
            return line;
        }
        if (reader != null) {
            reader.close();
        }
        return line;
    }

    public static final String getForesterLibraryInformation() {
        return "forester 1.039 (150513)";
    }

    public static final String getLineSeparator() {
        return LINE_SEPARATOR;
    }

    public static final MolecularSequence.TYPE guessMolecularSequenceType(String mol_seq) {
        if (mol_seq.contains("L") || mol_seq.contains("I") || mol_seq.contains("E") || mol_seq.contains("H") || mol_seq.contains("D") || mol_seq.contains("Q")) {
            return MolecularSequence.TYPE.AA;
        }
        if (mol_seq.contains("T")) {
            return MolecularSequence.TYPE.DNA;
        }
        if (mol_seq.contains("U")) {
            return MolecularSequence.TYPE.RNA;
        }
        return null;
    }

    public static final void increaseCountingMap(Map<String, Integer> counting_map, String item_name) {
        if (!counting_map.containsKey(item_name)) {
            counting_map.put(item_name, 1);
        } else {
            counting_map.put(item_name, counting_map.get(item_name) + 1);
        }
    }

    public static final boolean isEmpty(List<?> l) {
        if (l == null || l.isEmpty()) {
            return true;
        }
        for (Object o : l) {
            if (o == null) continue;
            return false;
        }
        return true;
    }

    public static final boolean isEmpty(Set<?> s) {
        if (s == null || s.isEmpty()) {
            return true;
        }
        for (Object o : s) {
            if (o == null) continue;
            return false;
        }
        return true;
    }

    public static final boolean isEmpty(String s) {
        return s == null || s.length() < 1;
    }

    public static boolean isEngulfed(Domain domain, List<Boolean> covered_positions) {
        for (int i = domain.getFrom(); i <= domain.getTo(); ++i) {
            if (i < covered_positions.size() && covered_positions.get(i).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static final boolean isEqual(double a, double b) {
        return Math.abs(a - b) < 1.0E-9;
    }

    public static final boolean isEven(int n) {
        return n % 2 == 0;
    }

    public static final boolean isIntersecting(String[] a, String[] b) {
        if (a == null || b == null) {
            return false;
        }
        if (a.length < 1 || b.length < 1) {
            return false;
        }
        for (String ai : a) {
            for (String element : b) {
                if (ai == null || element == null || !ai.equals(element)) continue;
                return true;
            }
        }
        return false;
    }

    public static final double isLargerOrEqualToZero(double d) {
        if (d > 0.0) {
            return d;
        }
        return 0.0;
    }

    public static final boolean isMac() {
        try {
            return OS_NAME.toLowerCase().startsWith("mac");
        }
        catch (Exception e) {
            ForesterUtil.printWarningMessage("Archaeopteryx", "minor error: " + e);
            return false;
        }
    }

    public static final boolean isNull(BigDecimal s) {
        return s == null || s.compareTo(NULL_BD) == 0;
    }

    public static final String isReadableFile(File f) {
        if (!f.exists()) {
            return "file [" + f + "] does not exist";
        }
        if (f.isDirectory()) {
            return "[" + f + "] is a directory";
        }
        if (!f.isFile()) {
            return "[" + f + "] is not a file";
        }
        if (!f.canRead()) {
            return "file [" + f + "] is not readable";
        }
        if (f.length() < 1L) {
            return "file [" + f + "] is empty";
        }
        return null;
    }

    public static final String isReadableFile(String s) {
        return ForesterUtil.isReadableFile(new File(s));
    }

    public static final boolean isWindows() {
        try {
            return OS_NAME.toLowerCase().indexOf("win") > -1;
        }
        catch (Exception e) {
            ForesterUtil.printWarningMessage("Archaeopteryx", "minor error: " + e);
            return false;
        }
    }

    public static final String isWritableFile(File f) {
        if (f.isDirectory()) {
            return "[" + f + "] is a directory";
        }
        if (f.exists()) {
            return "[" + f + "] already exists";
        }
        return null;
    }

    public static final int limitRangeForColor(int i) {
        if (i > 255) {
            i = 255;
        } else if (i < 0) {
            i = 0;
        }
        return i;
    }

    public static final SortedMap<Object, Integer> listToSortedCountsMap(List<?> list) {
        TreeMap<Object, Integer> map = new TreeMap<Object, Integer>();
        for (Object key : list) {
            if (!map.containsKey(key)) {
                map.put(key, 1);
                continue;
            }
            map.put(key, (Integer)map.get(key) + 1);
        }
        return map;
    }

    public static final void map2file(File file, Map<?, ?> data, String entry_separator, String data_separator) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        ForesterUtil.map2writer(writer, data, entry_separator, data_separator);
        ((Writer)writer).close();
    }

    public static final void map2writer(Writer writer, Map<?, ?> data, String entry_separator, String data_separator) throws IOException {
        boolean first = true;
        for (Map.Entry<?, ?> entry : data.entrySet()) {
            if (!first) {
                writer.write(data_separator);
            } else {
                first = false;
            }
            writer.write(entry.getKey().toString());
            writer.write(entry_separator);
            writer.write(entry.getValue().toString());
        }
    }

    public static final StringBuffer mapToStringBuffer(Map<Object, Object> map, String key_value_separator) {
        StringBuffer sb = new StringBuffer();
        for (Object key : map.keySet()) {
            sb.append(key.toString());
            sb.append(key_value_separator);
            sb.append(map.get(key).toString());
            sb.append(ForesterUtil.getLineSeparator());
        }
        return sb;
    }

    public static final String normalizeString(String s, int length, boolean left_pad, char pad_char) {
        if (s.length() > length) {
            return s.substring(0, length);
        }
        StringBuffer pad = new StringBuffer(length - s.length());
        for (int i = 0; i < length - s.length(); ++i) {
            pad.append(pad_char);
        }
        if (left_pad) {
            return pad + s;
        }
        return s + pad;
    }

    public static final Color obtainColorDependingOnTaxonomyGroup(String tax_group) {
        if (!ForesterUtil.isEmpty(tax_group)) {
            if (tax_group.equals("deuterostomia")) {
                return TaxonomyColors.DEUTEROSTOMIA_COLOR;
            }
            if (tax_group.equals("protostomia")) {
                return TaxonomyColors.PROTOSTOMIA_COLOR;
            }
            if (tax_group.equals("cnidaria")) {
                return TaxonomyColors.CNIDARIA_COLOR;
            }
            if (tax_group.equals("placozoa")) {
                return TaxonomyColors.PLACOZOA_COLOR;
            }
            if (tax_group.equals("ctenophora")) {
                return TaxonomyColors.CTENOPHORA_COLOR;
            }
            if (tax_group.equals("porifera")) {
                return TaxonomyColors.PORIFERA_COLOR;
            }
            if (tax_group.equals("choanoflagellida")) {
                return TaxonomyColors.CHOANOFLAGELLIDA;
            }
            if (tax_group.equals("ichthyophonida & filasterea")) {
                return TaxonomyColors.ICHTHYOSPOREA_AND_FILASTEREA;
            }
            if (tax_group.equals("dikarya")) {
                return TaxonomyColors.DIKARYA_COLOR;
            }
            if (tax_group.equalsIgnoreCase("fungi") || tax_group.equalsIgnoreCase("other fungi")) {
                return TaxonomyColors.OTHER_FUNGI_COLOR;
            }
            if (tax_group.equals("nucleariidae and fonticula group")) {
                return TaxonomyColors.NUCLEARIIDAE_AND_FONTICULA_GROUP_COLOR;
            }
            if (tax_group.equals("amoebozoa")) {
                return TaxonomyColors.AMOEBOZOA_COLOR;
            }
            if (tax_group.equals("embryophyta")) {
                return TaxonomyColors.EMBRYOPHYTA_COLOR;
            }
            if (tax_group.equals("chlorophyta")) {
                return TaxonomyColors.CHLOROPHYTA_COLOR;
            }
            if (tax_group.equals("rhodophyta")) {
                return TaxonomyColors.RHODOPHYTA_COLOR;
            }
            if (tax_group.equals("hacrobia")) {
                return TaxonomyColors.HACROBIA_COLOR;
            }
            if (tax_group.equals("glaucocystophyceae")) {
                return TaxonomyColors.GLAUCOPHYTA_COLOR;
            }
            if (tax_group.equals("stramenopiles")) {
                return TaxonomyColors.STRAMENOPILES_COLOR;
            }
            if (tax_group.equals("alveolata")) {
                return TaxonomyColors.ALVEOLATA_COLOR;
            }
            if (tax_group.equals("rhizaria")) {
                return TaxonomyColors.RHIZARIA_COLOR;
            }
            if (tax_group.equals("excavata")) {
                return TaxonomyColors.EXCAVATA_COLOR;
            }
            if (tax_group.equals("apusozoa")) {
                return TaxonomyColors.APUSOZOA_COLOR;
            }
            if (tax_group.equals("archaea")) {
                return TaxonomyColors.ARCHAEA_COLOR;
            }
            if (tax_group.equals("bacteria")) {
                return TaxonomyColors.BACTERIA_COLOR;
            }
        }
        return null;
    }

    public static final String obtainNormalizedTaxonomyGroup(String tax) {
        if (tax.equalsIgnoreCase("deuterostomia")) {
            return "deuterostomia";
        }
        if (tax.equalsIgnoreCase("protostomia")) {
            return "protostomia";
        }
        if (tax.equalsIgnoreCase("cnidaria")) {
            return "cnidaria";
        }
        if (tax.toLowerCase().startsWith("trichoplax") || tax.equalsIgnoreCase("placozoa")) {
            return "placozoa";
        }
        if (tax.toLowerCase().startsWith("mnemiopsis") || tax.equalsIgnoreCase("ctenophora")) {
            return "ctenophora";
        }
        if (tax.toLowerCase().startsWith("amphimedon") || tax.equalsIgnoreCase("porifera")) {
            return "porifera";
        }
        if (tax.equalsIgnoreCase("codonosigidae") || tax.equalsIgnoreCase("choanoflagellida")) {
            return "choanoflagellida";
        }
        if (tax.toLowerCase().startsWith("ichthyophonida & filasterea") || tax.toLowerCase().startsWith("ichthyophonida and filasterea") || tax.toLowerCase().startsWith("ichthyosporea & filasterea") || tax.toLowerCase().startsWith("ichthyosporea and filasterea")) {
            return "ichthyophonida & filasterea";
        }
        if (tax.equalsIgnoreCase("dikarya")) {
            return "dikarya";
        }
        if (tax.equalsIgnoreCase("fungi") || tax.equalsIgnoreCase("other fungi")) {
            return "other fungi";
        }
        if (tax.toLowerCase().startsWith("nucleariidae and fonticula")) {
            return "nucleariidae and fonticula group";
        }
        if (tax.equalsIgnoreCase("amoebozoa")) {
            return "amoebozoa";
        }
        if (tax.equalsIgnoreCase("embryophyta")) {
            return "embryophyta";
        }
        if (tax.equalsIgnoreCase("chlorophyta")) {
            return "chlorophyta";
        }
        if (tax.equalsIgnoreCase("rhodophyta")) {
            return "rhodophyta";
        }
        if (tax.toLowerCase().startsWith("hacrobia")) {
            return "hacrobia";
        }
        if (tax.equalsIgnoreCase("glaucocystophyceae") || tax.equalsIgnoreCase("glaucophyta")) {
            return "glaucocystophyceae";
        }
        if (tax.equalsIgnoreCase("stramenopiles")) {
            return "stramenopiles";
        }
        if (tax.equalsIgnoreCase("alveolata")) {
            return "alveolata";
        }
        if (tax.equalsIgnoreCase("rhizaria")) {
            return "rhizaria";
        }
        if (tax.equalsIgnoreCase("excavata")) {
            return "excavata";
        }
        if (tax.equalsIgnoreCase("apusozoa")) {
            return "apusozoa";
        }
        if (tax.equalsIgnoreCase("archaea")) {
            return "archaea";
        }
        if (tax.equalsIgnoreCase("bacteria")) {
            return "bacteria";
        }
        return null;
    }

    public static final BufferedReader obtainReader(Object source) throws IOException, FileNotFoundException {
        BufferedReader reader = null;
        if (source instanceof File) {
            File f = (File)source;
            if (!f.exists()) {
                throw new IOException("\"" + f.getAbsolutePath() + "\" does not exist");
            }
            if (!f.isFile()) {
                throw new IOException("\"" + f.getAbsolutePath() + "\" is not a file");
            }
            if (!f.canRead()) {
                throw new IOException("\"" + f.getAbsolutePath() + "\" is not a readable");
            }
            reader = new BufferedReader(new FileReader(f));
        } else if (source instanceof InputStream) {
            reader = new BufferedReader(new InputStreamReader((InputStream)source));
        } else if (source instanceof String) {
            reader = new BufferedReader(new StringReader((String)source));
        } else if (source instanceof StringBuffer) {
            reader = new BufferedReader(new StringReader(source.toString()));
        } else {
            throw new IllegalArgumentException("attempt to parse object of type [" + source.getClass() + "] (can only parse objects of type File, InputStream, String, or StringBuffer)");
        }
        return reader;
    }

    public static final void outOfMemoryError(OutOfMemoryError e) {
        System.err.println();
        System.err.println("Java memory allocation might be too small, try \"-Xmx2048m\" java command line option");
        System.err.println();
        e.printStackTrace(System.err);
        System.err.println();
        System.exit(-1);
    }

    public static final StringBuffer pad(double number, int size, char pad, boolean left_pad) {
        return ForesterUtil.pad(new StringBuffer(number + ""), size, pad, left_pad);
    }

    public static final StringBuffer pad(String string, int size, char pad, boolean left_pad) {
        return ForesterUtil.pad(new StringBuffer(string), size, pad, left_pad);
    }

    public static final StringBuffer pad(StringBuffer string, int size, char pad, boolean left_pad) {
        StringBuffer padding = new StringBuffer();
        int s = size - string.length();
        if (s < 1) {
            return new StringBuffer(string.substring(0, size));
        }
        for (int i = 0; i < s; ++i) {
            padding.append(pad);
        }
        if (left_pad) {
            return padding.append(string);
        }
        return string.append(padding);
    }

    public static final double parseDouble(String str) throws ParseException {
        if (ForesterUtil.isEmpty(str)) {
            return 0.0;
        }
        return Double.parseDouble(str);
    }

    public static final int parseInt(String str) throws ParseException {
        if (ForesterUtil.isEmpty(str)) {
            return 0;
        }
        return Integer.parseInt(str);
    }

    public static final void printArray(Object[] a) {
        for (int i = 0; i < a.length; ++i) {
            System.out.println("[" + i + "]=" + a[i]);
        }
    }

    public static final void printCountingMap(Map<String, Integer> counting_map) {
        for (String key : counting_map.keySet()) {
            System.out.println(key + ": " + counting_map.get(key));
        }
    }

    public static final void printErrorMessage(String prg_name, String message) {
        System.err.println("[" + prg_name + "] > error: " + message);
    }

    public static final void printProgramInformation(String prg_name, String prg_version, String date) {
        int l = prg_name.length() + prg_version.length() + date.length() + 4;
        System.out.println();
        System.out.println(prg_name + " " + prg_version + " (" + date + ")");
        for (int i = 0; i < l; ++i) {
            System.out.print("_");
        }
        System.out.println();
    }

    public static final void printProgramInformation(String prg_name, String prg_version, String date, String email, String www) {
        ForesterUtil.printProgramInformation(prg_name, null, prg_version, date, email, www, null);
    }

    public static final void printProgramInformation(String prg_name, String desc, String prg_version, String date, String email, String www, String based_on) {
        String my_prg_name = new String(prg_name);
        if (!ForesterUtil.isEmpty(desc)) {
            my_prg_name = my_prg_name + " - " + desc;
        }
        int l = my_prg_name.length() + prg_version.length() + date.length() + 4;
        System.out.println();
        System.out.println(my_prg_name + " " + prg_version + " (" + date + ")");
        for (int i = 0; i < l; ++i) {
            System.out.print("_");
        }
        System.out.println();
        System.out.println();
        System.out.println("WWW     : " + www);
        System.out.println("Contact : " + email);
        if (!ForesterUtil.isEmpty(based_on)) {
            System.out.println("Based on: " + based_on);
        }
        if (!ForesterUtil.isEmpty(JAVA_VERSION) && !ForesterUtil.isEmpty(JAVA_VENDOR)) {
            System.out.println();
            System.out.println("[running on Java " + JAVA_VERSION + " " + JAVA_VENDOR + "]");
        }
        System.out.println();
    }

    public static final void printWarningMessage(String prg_name, String message) {
        System.out.println("[" + prg_name + "] > warning: " + message);
    }

    public static final void programMessage(String prg_name, String message) {
        System.out.println("[" + prg_name + "] > " + message);
    }

    public static List<String> readUrl(String url_str) throws IOException {
        String line;
        URL url = new URL(url_str);
        URLConnection urlc = url.openConnection();
        BufferedReader in = new BufferedReader(new InputStreamReader(urlc.getInputStream()));
        ArrayList<String> result = new ArrayList<String>();
        while ((line = in.readLine()) != null) {
            result.add(line);
        }
        in.close();
        return result;
    }

    public static Protein removeOverlappingDomains(int max_allowed_overlap, boolean remove_engulfed_domains, Protein protein) {
        BasicProtein pruned_protein = new BasicProtein(protein.getProteinId().getId(), protein.getSpecies().getSpeciesId(), protein.getLength());
        List<Domain> sorted = SurfacingUtil.sortDomainsWithAscendingConfidenceValues(protein);
        ArrayList<Boolean> covered_positions = new ArrayList<Boolean>();
        for (Domain domain : sorted) {
            int covered_positions_size;
            if (max_allowed_overlap >= 0 && ForesterUtil.calculateOverlap(domain, covered_positions) > max_allowed_overlap || remove_engulfed_domains && ForesterUtil.isEngulfed(domain, covered_positions)) continue;
            for (int i = covered_positions_size = covered_positions.size(); i < domain.getFrom(); ++i) {
                covered_positions.add(false);
            }
            int new_covered_positions_size = covered_positions.size();
            for (int i = domain.getFrom(); i <= domain.getTo(); ++i) {
                if (i < new_covered_positions_size) {
                    covered_positions.set(i, true);
                    continue;
                }
                covered_positions.add(true);
            }
            pruned_protein.addProteinDomain(domain);
        }
        return pruned_protein;
    }

    public static final String removeSuffix(String file_name) {
        int i = file_name.lastIndexOf(46);
        if (i > 1) {
            return file_name.substring(0, i);
        }
        return file_name;
    }

    public static final String removeWhiteSpace(String s) {
        for (int i = 0; i <= s.length() - 1; ++i) {
            if (s.charAt(i) != ' ' && s.charAt(i) != '\t' && s.charAt(i) != '\n' && s.charAt(i) != '\r') continue;
            s = s.substring(0, i) + s.substring(i + 1);
            --i;
        }
        return s;
    }

    public static final String replaceIllegalNhxCharacters(String nhx) {
        if (nhx == null) {
            return "";
        }
        return nhx.trim().replaceAll("[\\[\\]']+", "_");
    }

    public static final double round(double value, int decimal_place) {
        BigDecimal bd = new BigDecimal(value);
        bd = bd.setScale(decimal_place, 4);
        return bd.doubleValue();
    }

    public static final int roundToInt(double d) {
        return (int)(d + 0.5);
    }

    public static final int roundToInt(float f) {
        return (int)(f + 0.5f);
    }

    public static final short roundToShort(double d) {
        return (short)(d + 0.5);
    }

    public static final String sanitizeString(String s) {
        if (s == null) {
            return "";
        }
        return s.trim();
    }

    public static final StringBuilder santitizeStringForNH(String data) {
        data = data.replaceAll("\\s+", " ").trim();
        StringBuilder sb = new StringBuilder();
        if (data.length() > 0) {
            boolean double_pars;
            boolean single_pars = data.indexOf(39) > -1;
            boolean bl = double_pars = data.indexOf(34) > -1;
            if (single_pars && double_pars) {
                data = data.replace('\'', '`');
                sb.append('\'');
                sb.append(data);
                sb.append('\'');
            } else if (single_pars) {
                sb.append('\"');
                sb.append(data);
                sb.append('\"');
            } else if (PARANTHESESABLE_NH_CHARS_PATTERN.matcher(data).find()) {
                sb.append('\'');
                sb.append(data);
                sb.append('\'');
            } else {
                sb.append(data);
            }
        }
        return sb;
    }

    public static boolean seqIsLikelyToBeAa(String s) {
        String seq = s.toLowerCase();
        return seq.indexOf(114) > -1 || seq.indexOf(100) > -1 || seq.indexOf(101) > -1 || seq.indexOf(113) > -1 || seq.indexOf(104) > -1 || seq.indexOf(107) > -1 || seq.indexOf(119) > -1 || seq.indexOf(115) > -1 || seq.indexOf(109) > -1 || seq.indexOf(112) > -1 || seq.indexOf(118) > -1;
    }

    private static final String[] splitString(String str) {
        String regex = "[\\s;,]+";
        return str.split("[\\s;,]+");
    }

    public static final String stringArrayToString(String[] a) {
        return ForesterUtil.stringArrayToString(a, ", ");
    }

    public static final String stringArrayToString(String[] a, String separator) {
        StringBuilder sb = new StringBuilder();
        if (a != null && a.length > 0) {
            for (int i = 0; i < a.length - 1; ++i) {
                sb.append(a[i] + separator);
            }
            sb.append(a[a.length - 1]);
        }
        return sb.toString();
    }

    public static final String[] stringListToArray(List<String> list) {
        if (list != null) {
            String[] str = new String[list.size()];
            int i = 0;
            for (String l : list) {
                str[i++] = l;
            }
            return str;
        }
        return null;
    }

    public static final String stringListToString(List<String> l, String separator) {
        StringBuilder sb = new StringBuilder();
        if (l != null && l.size() > 0) {
            for (int i = 0; i < l.size() - 1; ++i) {
                sb.append(l.get(i) + separator);
            }
            sb.append(l.get(l.size() - 1));
        }
        return sb.toString();
    }

    public static final String[] stringSetToArray(Set<String> strings) {
        String[] str_array = new String[strings.size()];
        int i = 0;
        for (String e : strings) {
            str_array[i++] = e;
        }
        return str_array;
    }

    public static final void unexpectedFatalError(Error e) {
        System.err.println();
        System.err.println("unexpected error: should not have occured! Please contact program author(s).");
        e.printStackTrace(System.err);
        System.err.println();
        System.exit(-1);
    }

    public static final void unexpectedFatalError(Exception e) {
        System.err.println();
        System.err.println("unexpected exception: should not have occured! Please contact program author(s).");
        e.printStackTrace(System.err);
        System.err.println();
        System.exit(-1);
    }

    public static final void unexpectedFatalError(String message) {
        System.err.println();
        System.err.println("unexpected error: should not have occured! Please contact program author(s).");
        System.err.println(message);
        System.err.println();
        System.exit(-1);
    }

    public static final void unexpectedFatalError(String prg_name, Exception e) {
        System.err.println();
        System.err.println("[" + prg_name + "] > unexpected error; should not have occured! Please contact program author(s).");
        e.printStackTrace(System.err);
        System.err.println();
        System.exit(-1);
    }

    public static final void unexpectedFatalError(String prg_name, String message) {
        System.err.println();
        System.err.println("[" + prg_name + "] > unexpected error: should not have occured! Please contact program author(s).");
        System.err.println(message);
        System.err.println();
        System.exit(-1);
    }

    public static final void unexpectedFatalError(String prg_name, String message, Exception e) {
        System.err.println();
        System.err.println("[" + prg_name + "] > unexpected error: should not have occured! Please contact program author(s).");
        System.err.println(message);
        e.printStackTrace(System.err);
        System.err.println();
        System.exit(-1);
    }

    public static final void updateProgress(double progress_percentage) {
        int i;
        int width = 50;
        System.out.print("\r[");
        for (i = 0; i <= ForesterUtil.roundToInt(progress_percentage * 50.0); ++i) {
            System.out.print(".");
        }
        while (i < 50) {
            System.out.print(" ");
            ++i;
        }
        System.out.print("]");
    }

    public static final void updateProgress(int i, DecimalFormat f) {
        System.out.print("\r[" + f.format(i) + "]");
    }

    public static final String wordWrap(String str, int width) {
        StringBuilder sb = new StringBuilder(str);
        int start = 0;
        int ls = -1;
        for (int i = 0; i < sb.length(); ++i) {
            if (sb.charAt(i) == ' ') {
                ls = i;
            }
            if (sb.charAt(i) == '\n') {
                ls = -1;
                start = i + 1;
            }
            if (i <= start + width - 1) continue;
            if (ls != -1) {
                sb.setCharAt(ls, '\n');
                start = ls + 1;
                ls = -1;
                continue;
            }
            sb.insert(i, '\n');
            start = i + 1;
        }
        return sb.toString();
    }

    private ForesterUtil() {
    }

    static {
        JAVA_VENDOR = System.getProperty("java.vendor");
        JAVA_VERSION = System.getProperty("java.version");
        LINE_SEPARATOR = System.getProperty("line.separator");
        NULL_BD = new BigDecimal(0);
        OS_ARCH = System.getProperty("os.arch");
        OS_NAME = System.getProperty("os.name");
        OS_VERSION = System.getProperty("os.version");
        PARANTHESESABLE_NH_CHARS_PATTERN = Pattern.compile("[(),;\\s:\\[\\]]");
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        FORMATTER_9 = new DecimalFormat("#.#########", dfs);
        FORMATTER_6 = new DecimalFormat("#.######", dfs);
        FORMATTER_06 = new DecimalFormat("0.######", dfs);
        FORMATTER_3 = new DecimalFormat("#.###", dfs);
    }
}

