/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.msfiles;

import fr.proline.studio.Exceptions;
import fr.proline.studio.dam.taskinfo.TaskError;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;

public class FileDeletionTask
extends AbstractDatabaseTask {
    private final File m_file;

    public FileDeletionTask(AbstractDatabaseCallback callback, File file) {
        super(callback, new TaskInfo("Delete file " + file.getAbsolutePath(), false, "Generic Task", TaskInfo.INFO_IMPORTANCE_LOW));
        this.m_file = file;
    }

    public boolean fetchData() {
        boolean result = false;
        try {
            result = Files.deleteIfExists(this.m_file.toPath());
            if (!result) {
                this.m_taskError = new TaskError("File Deletion Error", "File " + this.m_file.getAbsolutePath() + " could not be deleted.\n");
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return result;
    }

    public boolean needToFetch() {
        return true;
    }
}

