/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.msfiles;

import fr.proline.studio.dpm.AccessJMSManagerThread;
import fr.proline.studio.dpm.task.jms.AbstractJMSCallback;
import fr.proline.studio.dpm.task.jms.AbstractJMSTask;
import fr.proline.studio.dpm.task.jms.FileUploadTask;
import fr.proline.studio.msfiles.MsListener;
import fr.proline.studio.msfiles.MsListenerConverterParameter;
import fr.proline.studio.msfiles.MsListenerDownloadParameter;
import fr.proline.studio.msfiles.MsListenerEntryUpdateParameter;
import fr.proline.studio.msfiles.MsListenerParameter;
import fr.proline.studio.msfiles.MzdbUploadSettings;
import fr.proline.studio.msfiles.MzdbUploader;
import fr.proline.studio.rsmexplorer.MzdbFilesTopPanel;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import javax.swing.tree.TreePath;

public class MzdbUploadBatch
implements Runnable,
MsListener {
    private final ThreadPoolExecutor m_executor;
    private final HashMap<File, MzdbUploadSettings> m_uploads;
    private TreePath m_pathToExpand;

    public MzdbUploadBatch(HashMap<File, MzdbUploadSettings> uploads) {
        this.m_uploads = uploads;
        this.m_executor = (ThreadPoolExecutor)Executors.newFixedThreadPool(5);
    }

    public MzdbUploadBatch(HashMap<File, MzdbUploadSettings> uploads, TreePath pathToExpand) {
        this(uploads);
        this.m_pathToExpand = pathToExpand;
    }

    public void upload(final File f, MzdbUploadSettings uploadSettings) {
        if (f.getAbsolutePath().toLowerCase().endsWith(".mzdb")) {
            MzdbUploader uploader = new MzdbUploader(f, uploadSettings);
            uploader.addMsListener(this);
            this.m_executor.execute(uploader);
        } else {
            String[] result = new String[1];
            AbstractJMSCallback callback = new AbstractJMSCallback(){

                public boolean mustBeCalledInAWT() {
                    return true;
                }

                public void run(boolean success) {
                    if (success) {
                        if (f.exists()) {
                            ArrayList<MsListenerParameter> list = new ArrayList<MsListenerParameter>();
                            list.add(new MsListenerParameter(f, true));
                            MzdbUploadBatch.this.uploadPerformed(list);
                        }
                    } else {
                        ArrayList<MsListenerParameter> list = new ArrayList<MsListenerParameter>();
                        list.add(new MsListenerParameter(f, false));
                        MzdbUploadBatch.this.uploadPerformed(list);
                    }
                }
            };
            FileUploadTask task = new FileUploadTask(callback, f.getAbsolutePath(), result);
            task.initUploadGenericFile(uploadSettings.getMountingPointPath(), uploadSettings.getDestination());
            AccessJMSManagerThread.getAccessJMSManagerThread().addTask((AbstractJMSTask)task);
        }
    }

    @Override
    public void run() {
        if (this.m_pathToExpand == null) {
            HashSet<String> m_directories = new HashSet<String>();
            for (Map.Entry<File, MzdbUploadSettings> pair : this.m_uploads.entrySet()) {
                MzdbUploadSettings settings = pair.getValue();
                if (settings.getDestination().equalsIgnoreCase("")) continue;
                if (settings.getDestination().startsWith(File.separator)) {
                    m_directories.add(settings.getDestination().substring(1));
                    continue;
                }
                m_directories.add(settings.getDestination());
            }
            MzdbFilesTopPanel.getExplorer().getTreeFileChooserPanel().expandMultipleTreePath(m_directories, this.m_uploads.entrySet().iterator().next().getValue().getMountingPointPath());
        } else {
            MzdbFilesTopPanel.getExplorer().getTreeFileChooserPanel().expandTreePath(this.m_pathToExpand);
        }
        for (Map.Entry<File, MzdbUploadSettings> pair : this.m_uploads.entrySet()) {
            this.upload(pair.getKey(), pair.getValue());
        }
    }

    @Override
    public void conversionPerformed(ArrayList<MsListenerConverterParameter> list) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void uploadPerformed(ArrayList<MsListenerParameter> list) {
        if (list != null && !list.isEmpty()) {
            boolean success = false;
            for (int i = 0; i < list.size(); ++i) {
                if (!list.get(i).wasSuccessful()) continue;
                success = true;
                break;
            }
            if (success) {
                MzdbFilesTopPanel.getExplorer().getTreeFileChooserPanel().updateTree();
            }
        }
    }

    @Override
    public void downloadPerformed(ArrayList<MsListenerDownloadParameter> list) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void exportPerformed(ArrayList<MsListenerParameter> list) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void verificationPerformed(ArrayList<MsListenerParameter> list) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void entryStateUpdated(ArrayList<MsListenerEntryUpdateParameter> list) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

