/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.pattern.xic;

import fr.proline.core.orm.lcms.MapAlignment;
import fr.proline.core.orm.lcms.ProcessedMap;
import fr.proline.core.orm.lcms.ProcessedMapMozCalibration;
import fr.proline.core.orm.msi.dto.DMasterQuantPeptideIon;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.dam.tasks.xic.DatabaseLoadLcMSTask;
import fr.proline.studio.dam.tasks.xic.DatabaseLoadXicMasterQuantTask;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.ParameterList;
import fr.proline.studio.pattern.ParameterSubtypeEnum;
import fr.proline.studio.rsmexplorer.gui.dialog.xic.AbstractLabelFreeMSParamsPanel;
import fr.proline.studio.rsmexplorer.gui.xic.MapAlignmentPanel;
import fr.proline.studio.rsmexplorer.gui.xic.MapMozAlignmentPanel;
import fr.proline.studio.rsmexplorer.gui.xic.MapTimeTableModel;
import fr.proline.studio.rsmexplorer.gui.xic.QuantChannelInfo;
import fr.proline.studio.rsmexplorer.gui.xic.alignment.IonsRTTableModel;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataboxMapAlignment
extends AbstractDataBox {
    protected static final Logger logger = LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer.XIC.alignment");
    private double m_logStartTime;
    private double m_logCloudStartTime;
    private DDataset m_dataset;
    private QuantChannelInfo m_quantChannelInfo;
    private List<DMasterQuantPeptideIon> m_masterQuantPeptideIonList;
    private Map<Long, IonsRTTableModel> m_ionsRTBySourceMapId;
    private double m_crossAssignmentTimeTolerance = AbstractLabelFreeMSParamsPanel.DEFAULT_CA_FEATMAP_RTTOL_VALUE;
    private double m_featureAlignmentTimeTolerance = AbstractLabelFreeMSParamsPanel.DEFAULT_ALIGN_FEATMAP_TIMETOL_VALUE;
    private Long m_paramTaskId;
    private boolean m_isCloudLoaded;
    private boolean m_isCloudTaskAsked;
    private boolean m_isMoZAlignment;

    public DataboxMapAlignment() {
        this(false);
    }

    public DataboxMapAlignment(boolean isMoZAlignment) {
        super(AbstractDataBox.DataboxType.DataBoxMapAlignment, AbstractDataBox.DataboxStyle.STYLE_XIC);
        this.m_isMoZAlignment = isMoZAlignment;
        this.m_typeName = this.m_isMoZAlignment ? "Moz Calibration Plot" : "Map Alignment Plot";
        this.m_description = this.m_isMoZAlignment ? "Graphical display of XIC MoZ Calibration." : "Graphical display of XIC Map Alignment.";
        this.m_ionsRTBySourceMapId = new HashMap<Long, IonsRTTableModel>();
        ParameterList inParameter = new ParameterList();
        inParameter.addParameter(DDataset.class);
        this.registerInParameter(inParameter);
        ParameterList outParameter = new ParameterList();
        outParameter.addParameter(ExtendedTableModelInterface.class, ParameterSubtypeEnum.LIST_DATA);
        this.registerOutParameter(outParameter);
        this.m_isCloudLoaded = false;
        this.m_isCloudTaskAsked = false;
    }

    public double getCrossAssignmentTimeTolerance() {
        return this.m_crossAssignmentTimeTolerance;
    }

    public double getFeatureAlignmentTimeTolerance() {
        return this.m_featureAlignmentTimeTolerance;
    }

    @Override
    public Object getDataImpl(Class parameterType, ParameterSubtypeEnum parameterSubtype) {
        if (parameterType != null && parameterSubtype == ParameterSubtypeEnum.LIST_DATA && parameterType.equals(ExtendedTableModelInterface.class)) {
            return this.getCompareDataInterfaceList();
        }
        return super.getDataImpl(parameterType, parameterSubtype);
    }

    private List<ExtendedTableModelInterface> getCompareDataInterfaceList() {
        ArrayList<ExtendedTableModelInterface> listCDI = new ArrayList<ExtendedTableModelInterface>();
        if (this.m_isMoZAlignment) {
            for (ProcessedMap map : this.m_dataset.getMaps()) {
                ArrayList allMozCalib = new ArrayList(map.getProcessedMapMozCalibration());
                String mapTitle = this.m_quantChannelInfo.getMapTitle(map.getId());
                String title = "MoZ calibration for " + mapTitle;
                for (ProcessedMapMozCalibration mapMozAlignment : allMozCalib) {
                    Color color = this.m_quantChannelInfo.getMapColor(map.getId());
                    MapTimeTableModel model = new MapTimeTableModel(mapMozAlignment.getProcessedMapMozList(), color, title, mapTitle);
                    listCDI.add(model);
                }
            }
        } else {
            for (MapAlignment mapAlignment : this.m_dataset.getMapAlignmentsFromMap(this.m_dataset.getAlnReferenceMapId())) {
                String fromMap = this.m_quantChannelInfo.getMapTitle(mapAlignment.getSourceMap().getId());
                String toMap = this.m_quantChannelInfo.getMapTitle(mapAlignment.getDestinationMap().getId());
                String title = "Map Alignment from " + fromMap + " (to " + toMap + ")";
                Color color = this.m_quantChannelInfo.getMapColor(mapAlignment.getDestinationMap().getId());
                MapTimeTableModel model = new MapTimeTableModel(mapAlignment.getMapTimeList(), color, title, fromMap, toMap);
                listCDI.add(model);
            }
        }
        return listCDI;
    }

    @Override
    public void createPanel() {
        if (this.m_isMoZAlignment) {
            MapMozAlignmentPanel p = new MapMozAlignmentPanel(this);
            p.setName(this.m_typeName);
            this.setDataBoxPanelInterface(p);
        } else {
            MapAlignmentPanel p = new MapAlignmentPanel(this);
            p.setName(this.m_typeName);
            this.setDataBoxPanelInterface(p);
        }
    }

    @Override
    public void setEntryData(Object data) {
        this.getDataBoxPanelInterface().addSingleValue(data);
        this.m_dataset = (DDataset)data;
        this.dataChanged();
    }

    @Override
    public void dataChanged() {
        final int loadingId = this.setLoading();
        if (this.m_dataset == null) {
            this.m_dataset = (DDataset)this.getData(DDataset.class);
        }
        AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                DataboxMapAlignment.this.setLoaded(loadingId);
                if (finished) {
                    logger.debug("DataboxMapAlignment task Id =" + taskId + " finished during " + ((double)System.currentTimeMillis() - DataboxMapAlignment.this.m_logStartTime) + " TimeMillis");
                    DataboxMapAlignment.this.unregisterTask(taskId);
                }
                if (taskId != DataboxMapAlignment.this.m_paramTaskId) {
                    DataboxMapAlignment.this.m_quantChannelInfo = new QuantChannelInfo(DataboxMapAlignment.this.m_dataset);
                    if (DataboxMapAlignment.this.m_isMoZAlignment) {
                        ((MapMozAlignmentPanel)DataboxMapAlignment.this.getDataBoxPanelInterface()).setData(DataboxMapAlignment.this.m_quantChannelInfo, DataboxMapAlignment.this.getCompareDataInterfaceList());
                    } else {
                        ((MapAlignmentPanel)DataboxMapAlignment.this.getDataBoxPanelInterface()).setData(DataboxMapAlignment.this.m_quantChannelInfo, DataboxMapAlignment.this.getCompareDataInterfaceList());
                    }
                    if (finished) {
                        DataboxMapAlignment.this.addDataChanged(ExtendedTableModelInterface.class, ParameterSubtypeEnum.LIST_DATA);
                        DataboxMapAlignment.this.propagateDataChanged();
                    }
                }
            }
        };
        DatabaseLoadXicMasterQuantTask taskParameter = new DatabaseLoadXicMasterQuantTask(callback);
        taskParameter.initLoadQuantChannels(this.getProjectId(), this.m_dataset);
        DatabaseLoadLcMSTask taskMapAlignment = new DatabaseLoadLcMSTask(callback);
        taskMapAlignment.initLoadAlignmentForXic(this.getProjectId(), this.m_dataset);
        this.m_paramTaskId = taskParameter.getId();
        this.m_logStartTime = System.currentTimeMillis();
        logger.debug(this.getClass().getName() + " DatabaseLoadXicMasterQuantTask taskParameter Id =" + this.m_paramTaskId + " registered");
        logger.debug(this.getClass().getName() + " DatabaseLoadLcMSTask taskMapAlignment Id =" + taskMapAlignment.getId() + " registered");
        this.registerTask((AbstractDatabaseTask)taskParameter);
        this.registerTask((AbstractDatabaseTask)taskMapAlignment);
    }

    public void loadCloud() {
        if (this.m_isCloudLoaded) {
            if (this.m_isMoZAlignment) {
                ((MapMozAlignmentPanel)this.getDataBoxPanelInterface()).setAlignmentCloud();
            } else {
                ((MapAlignmentPanel)this.getDataBoxPanelInterface()).setAlignmentCloud();
            }
        } else {
            if (this.m_isCloudTaskAsked) {
                return;
            }
            this.m_isCloudTaskAsked = true;
            final int loadingId = this.setLoading();
            if (this.m_dataset == null) {
                this.m_dataset = (DDataset)this.getData(DDataset.class);
            }
            AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

                public boolean mustBeCalledInAWT() {
                    return true;
                }

                public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                    if (taskId != DataboxMapAlignment.this.m_paramTaskId && finished) {
                        DataboxMapAlignment.this.setLoaded(loadingId);
                        DataboxMapAlignment.this.unregisterTask(taskId);
                        logger.debug("DataboxMapAlignment task Id =" + taskId + " finished during " + ((double)System.currentTimeMillis() - DataboxMapAlignment.this.m_logCloudStartTime) + " TimeMillis");
                        if (DataboxMapAlignment.this.isLoaded()) {
                            DataboxMapAlignment.this.m_isCloudLoaded = true;
                            DataboxMapAlignment.this.extractTimeToleranceParameters();
                            if (DataboxMapAlignment.this.m_isMoZAlignment) {
                                ((MapMozAlignmentPanel)DataboxMapAlignment.this.getDataBoxPanelInterface()).setAlignmentCloud();
                            } else {
                                ((MapAlignmentPanel)DataboxMapAlignment.this.getDataBoxPanelInterface()).setAlignmentCloud();
                            }
                        }
                    }
                }
            };
            this.m_masterQuantPeptideIonList = new ArrayList<DMasterQuantPeptideIon>();
            DatabaseLoadXicMasterQuantTask taskPeptideCloud = new DatabaseLoadXicMasterQuantTask(callback);
            taskPeptideCloud.initLoadPeptideIons(this.getProjectId(), this.m_dataset, this.m_masterQuantPeptideIonList);
            this.m_logCloudStartTime = System.currentTimeMillis();
            logger.debug(this.getClass().getName() + " DatabaseLoadLcMSTask taskPeptideCloud Id =" + taskPeptideCloud.getId() + " registered");
            this.registerTask((AbstractDatabaseTask)taskPeptideCloud);
        }
    }

    private void extractTimeToleranceParameters() {
        try {
            Map featureMappingConfig;
            Map alignmentConfig;
            Map crossAssignmentConfig;
            Map ftMappingParams;
            Double time;
            Map quantParams = this.m_dataset.getQuantProcessingConfigAsMap();
            if (quantParams.containsKey("cross_assignment_config") && (time = Double.valueOf((String)(ftMappingParams = (Map)(crossAssignmentConfig = (Map)quantParams.get("cross_assignment_config")).getOrDefault("ft_mapping_params", new HashMap())).get("time_tol"))) != null) {
                this.m_crossAssignmentTimeTolerance = time;
            }
            if (quantParams.containsKey("alignment_config") && (alignmentConfig = (Map)quantParams.get("alignment_config")).containsKey("ft_mapping_method_params") && (time = Double.valueOf((String)(featureMappingConfig = (Map)alignmentConfig.get("ft_mapping_method_params")).get("time_tol"))) != null) {
                this.m_featureAlignmentTimeTolerance = time;
            }
        }
        catch (Exception ex) {
            logger.error("error while get cross assignment or alignment RT tolerance " + ex);
        }
    }

    public IonsRTTableModel getPeptideCloud(long mapIdFrom) {
        IonsRTTableModel listETI = this.m_ionsRTBySourceMapId.get(mapIdFrom);
        if (listETI == null) {
            listETI = this.createIonsRTTableModel(mapIdFrom);
            this.m_ionsRTBySourceMapId.put(mapIdFrom, listETI);
        }
        return listETI;
    }

    private IonsRTTableModel createIonsRTTableModel(long mapIdFrom) {
        HashMap<Long, String> mapTitleByRsmId = new HashMap<Long, String>();
        HashMap<Long, Long> rsmIdByMapId = new HashMap<Long, Long>();
        List processMapList = this.m_quantChannelInfo.getDataset().getMaps();
        long[] rsmIdArray = new long[processMapList.size()];
        int index = 1;
        for (ProcessedMap map : processMapList) {
            Long mapId = map.getId();
            String mapTitle = this.m_quantChannelInfo.getMapTitle(mapId);
            Long rsmId = this.m_quantChannelInfo.getQuantChannelForMap(mapId).getId();
            rsmIdByMapId.put(mapId, rsmId);
            mapTitleByRsmId.put(rsmId, mapTitle);
            if (mapId == mapIdFrom) {
                rsmIdArray[0] = rsmId;
                continue;
            }
            rsmIdArray[index] = rsmId;
            ++index;
        }
        return new IonsRTTableModel(this.m_masterQuantPeptideIonList, rsmIdByMapId, mapTitleByRsmId, rsmIdArray);
    }
}

