/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.pattern.xic;

import fr.proline.core.orm.msi.Peptide;
import fr.proline.core.orm.msi.ResultSummary;
import fr.proline.core.orm.msi.dto.DMasterQuantPeptide;
import fr.proline.core.orm.msi.dto.DMasterQuantProteinSet;
import fr.proline.core.orm.msi.dto.DPeptideInstance;
import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.core.orm.msi.dto.DProteinSet;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.core.orm.util.TransientDataInterface;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.dam.tasks.xic.DatabaseLoadXicMasterQuantTask;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.GlobalTabelModelProviderInterface;
import fr.proline.studio.extendedtablemodel.SecondAxisTableModelInterface;
import fr.proline.studio.graphics.CrossSelectionInterface;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.ParameterList;
import fr.proline.studio.pattern.ParameterSubtypeEnum;
import fr.proline.studio.pattern.extradata.GraphicExtraData;
import fr.proline.studio.rsmexplorer.gui.xic.QuantChannelInfo;
import fr.proline.studio.rsmexplorer.gui.xic.XICComparePeptideTableModel;
import fr.proline.studio.rsmexplorer.gui.xic.XicAbundanceProteinTableModel;
import fr.proline.studio.rsmexplorer.gui.xic.XicPeptidePanel;
import fr.proline.studio.types.XicMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataboxXicPeptideSet
extends AbstractDataBox {
    private static final Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer");
    private DDataset m_dataset;
    private DProteinSet m_proteinSet;
    private DMasterQuantProteinSet m_masterQuantProteinSet;
    private List<DMasterQuantPeptide> m_masterQuantPeptideList;
    private QuantChannelInfo m_quantChannelInfo;
    private boolean m_isXICMode = true;
    private boolean m_displayPeptidesSubList = false;
    private Boolean m_keepZoom = Boolean.TRUE;

    public DataboxXicPeptideSet() {
        this(false);
    }

    public DataboxXicPeptideSet(boolean displayPeptidesSubList) {
        super(displayPeptidesSubList ? AbstractDataBox.DataboxType.DataboxXicPeptideSetShortList : AbstractDataBox.DataboxType.DataboxXicPeptideSet, AbstractDataBox.DataboxStyle.STYLE_XIC);
        this.m_displayPeptidesSubList = displayPeptidesSubList;
        if (!this.m_displayPeptidesSubList) {
            this.m_typeName = "Quanti Peptides";
            this.m_description = "All Quanti. Peptides of a ProteinSet";
        } else {
            this.m_typeName = "Quanti Peptides";
            this.m_description = "Short list of Quanti. Peptides";
        }
        ParameterList inParameter = new ParameterList();
        inParameter.addParameter(DDataset.class);
        inParameter.addParameter(DProteinSet.class);
        inParameter.addParameter(DMasterQuantProteinSet.class);
        inParameter.addParameter(QuantChannelInfo.class);
        inParameter.addParameter(XicMode.class);
        this.registerInParameter(inParameter);
        ParameterList outParameter = new ParameterList();
        outParameter.addParameter(DDataset.class);
        outParameter.addParameter(ResultSummary.class);
        outParameter.addParameter(DMasterQuantPeptide.class);
        outParameter.addParameter(XicMode.class);
        outParameter.addParameter(QuantChannelInfo.class);
        outParameter.addParameter(DPeptideMatch.class);
        outParameter.addParameter(ExtendedTableModelInterface.class);
        outParameter.addParameter(CrossSelectionInterface.class);
        outParameter.addParameter(SecondAxisTableModelInterface.class);
        outParameter.addParameter(ExtendedTableModelInterface.class, ParameterSubtypeEnum.LIST_DATA);
        this.registerOutParameter(outParameter);
    }

    public boolean isXICMode() {
        return this.m_isXICMode;
    }

    public void setXICMode(boolean isXICMode) {
        this.m_isXICMode = isXICMode;
        AbstractDataBox.DataboxStyle databoxStyle = this.m_style = this.m_isXICMode ? AbstractDataBox.DataboxStyle.STYLE_XIC : AbstractDataBox.DataboxStyle.STYLE_SC;
        if (this.getDataBoxPanelInterface() != null) {
            this.getDataBoxPanelInterface().addSingleValue(new XicMode(isXICMode));
        }
    }

    @Override
    public Long getRsetId() {
        if (this.m_dataset == null) {
            return null;
        }
        return this.m_dataset.getResultSetId();
    }

    @Override
    public Long getRsmId() {
        if (this.m_dataset == null) {
            return null;
        }
        return this.m_dataset.getResultSummaryId();
    }

    @Override
    public void createPanel() {
        XicPeptidePanel p = new XicPeptidePanel(false, this.m_isXICMode);
        p.setName(this.m_typeName);
        p.setDataBox(this);
        this.setDataBoxPanelInterface(p);
        this.getDataBoxPanelInterface().addSingleValue(new XicMode(this.m_isXICMode));
    }

    @Override
    public void dataChanged() {
        final boolean allPeptides = this.m_previousDataBox == null;
        List pepInstances = null;
        if (!allPeptides) {
            boolean valueUnchanged;
            DProteinSet newProSet = (DProteinSet)this.m_previousDataBox.getData(DProteinSet.class);
            DMasterQuantProteinSet newMasterProtSet = (DMasterQuantProteinSet)this.m_previousDataBox.getData(DMasterQuantProteinSet.class);
            DDataset newDS = (DDataset)this.m_previousDataBox.getData(DDataset.class);
            boolean bl = valueUnchanged = Objects.equals(newProSet, this.m_proteinSet) && Objects.equals(newMasterProtSet, this.m_masterQuantProteinSet) && Objects.equals(newDS, this.m_dataset);
            if (valueUnchanged && !this.m_displayPeptidesSubList) {
                return;
            }
            this.m_proteinSet = newProSet;
            this.m_masterQuantProteinSet = newMasterProtSet;
            this.m_dataset = newDS;
            if (this.m_proteinSet == null) {
                return;
            }
            this.m_isXICMode = ((XicMode)this.m_previousDataBox.getData(XicMode.class)).isXicMode();
            this.m_quantChannelInfo = (QuantChannelInfo)this.m_previousDataBox.getData(QuantChannelInfo.class);
            if (this.m_quantChannelInfo == null) {
                throw new RuntimeException("Xic PeptideSet : Can't get QuantChannelInfo from previous databox");
            }
            if (this.m_displayPeptidesSubList) {
                pepInstances = (List)this.m_previousDataBox.getData(DPeptideInstance.class, ParameterSubtypeEnum.LIST_DATA);
            }
        }
        if (this.m_dataset != null) {
            this.linkCache((TransientDataInterface)this.m_dataset.getResultSummary());
        }
        final int loadingId = this.setLoading();
        AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                if (subTask == null) {
                    if (!allPeptides && DataboxXicPeptideSet.this.m_quantChannelInfo != null) {
                        ((XicPeptidePanel)DataboxXicPeptideSet.this.getDataBoxPanelInterface()).setData(taskId, DataboxXicPeptideSet.this.m_masterQuantProteinSet, DataboxXicPeptideSet.this.m_quantChannelInfo.getQuantChannels(), DataboxXicPeptideSet.this.m_masterQuantPeptideList, DataboxXicPeptideSet.this.m_isXICMode, finished);
                    } else {
                        DataboxXicPeptideSet.this.m_quantChannelInfo = new QuantChannelInfo(DataboxXicPeptideSet.this.m_dataset);
                        DataboxXicPeptideSet.this.getDataBoxPanelInterface().addSingleValue(DataboxXicPeptideSet.this.m_quantChannelInfo);
                        ((XicPeptidePanel)DataboxXicPeptideSet.this.getDataBoxPanelInterface()).setData(taskId, DataboxXicPeptideSet.this.m_masterQuantProteinSet, DataboxXicPeptideSet.this.m_quantChannelInfo.getQuantChannels(), DataboxXicPeptideSet.this.m_masterQuantPeptideList, DataboxXicPeptideSet.this.m_isXICMode, finished);
                    }
                } else {
                    ((XicPeptidePanel)DataboxXicPeptideSet.this.getDataBoxPanelInterface()).dataUpdated(subTask, finished);
                }
                DataboxXicPeptideSet.this.setLoaded(loadingId);
                if (finished) {
                    DataboxXicPeptideSet.this.unregisterTask(taskId);
                    DataboxXicPeptideSet.this.addDataChanged(ExtendedTableModelInterface.class);
                    DataboxXicPeptideSet.this.addDataChanged(ExtendedTableModelInterface.class, ParameterSubtypeEnum.LIST_DATA);
                    DataboxXicPeptideSet.this.m_keepZoom = Boolean.FALSE;
                    DataboxXicPeptideSet.this.propagateDataChanged();
                    DataboxXicPeptideSet.this.m_keepZoom = Boolean.TRUE;
                }
            }
        };
        this.m_masterQuantPeptideList = new ArrayList<DMasterQuantPeptide>();
        DatabaseLoadXicMasterQuantTask task = new DatabaseLoadXicMasterQuantTask(callback);
        if (allPeptides) {
            task.initLoadPeptides(this.getProjectId(), this.m_dataset, this.m_masterQuantPeptideList, this.isXICMode());
        } else if (pepInstances != null && !pepInstances.isEmpty()) {
            List<Long> parentPepInstanceIdsL = pepInstances.stream().map(pi -> pi.getId()).collect(Collectors.toList());
            task.initLoadPeptides(this.getProjectId(), this.m_dataset, parentPepInstanceIdsL.toArray(new Long[parentPepInstanceIdsL.size()]), this.m_masterQuantPeptideList, this.isXICMode());
        } else {
            task.initLoadPeptides(this.getProjectId(), this.m_dataset, this.m_masterQuantProteinSet, this.m_masterQuantPeptideList, this.isXICMode());
        }
        this.registerTask((AbstractDatabaseTask)task);
    }

    @Override
    public void setEntryData(Object data) {
        this.getDataBoxPanelInterface().addSingleValue(data);
        this.m_dataset = (DDataset)data;
        this.dataChanged();
    }

    @Override
    public Object getDataImpl(Class parameterType, ParameterSubtypeEnum parameterSubtype) {
        if (parameterType != null) {
            if (parameterSubtype == ParameterSubtypeEnum.SINGLE_DATA) {
                if (parameterType.equals(ResultSummary.class)) {
                    return this.m_dataset.getResultSummary();
                }
                if (parameterType.equals(DMasterQuantPeptide.class)) {
                    return ((XicPeptidePanel)this.getDataBoxPanelInterface()).getSelectedMasterQuantPeptide();
                }
                if (parameterType.equals(DPeptideMatch.class)) {
                    DMasterQuantPeptide map = ((XicPeptidePanel)this.getDataBoxPanelInterface()).getSelectedMasterQuantPeptide();
                    if (map == null) {
                        return null;
                    }
                    DPeptideInstance pi = map.getPeptideInstance();
                    if (pi == null) {
                        return null;
                    }
                    return pi.getBestPeptideMatch();
                }
                if (parameterType.equals(DDataset.class)) {
                    return this.m_dataset;
                }
                if (parameterType.equals(QuantChannelInfo.class)) {
                    return this.m_quantChannelInfo;
                }
                if (parameterType.equals(ExtendedTableModelInterface.class)) {
                    return ((GlobalTabelModelProviderInterface)this.getDataBoxPanelInterface()).getGlobalTableModelInterface();
                }
                if (parameterType.equals(CrossSelectionInterface.class)) {
                    return ((GlobalTabelModelProviderInterface)this.getDataBoxPanelInterface()).getCrossSelectionInterface();
                }
                if (parameterType.equals(XicMode.class)) {
                    return new XicMode(this.isXICMode());
                }
                if (parameterType.equals(SecondAxisTableModelInterface.class)) {
                    if (this.m_quantChannelInfo == null || this.m_masterQuantProteinSet == null) {
                        return null;
                    }
                    XicAbundanceProteinTableModel protTableModel = new XicAbundanceProteinTableModel();
                    protTableModel.setData(this.m_quantChannelInfo.getQuantChannels(), this.m_masterQuantProteinSet);
                    protTableModel.setName("Protein");
                    return protTableModel;
                }
            }
            if (parameterSubtype == ParameterSubtypeEnum.LIST_DATA && parameterType.equals(ExtendedTableModelInterface.class)) {
                return this.getTableModelInterfaceList();
            }
            if (parameterSubtype == ParameterSubtypeEnum.PEPTIDES_SELECTION_LIST && parameterType.equals(Integer.class)) {
                CrossSelectionInterface crossSelectionInterface = ((XicPeptidePanel)this.m_panel).getCrossSelectionInterface();
                ArrayList<Integer> result = new ArrayList<Integer>();
                if (crossSelectionInterface != null) {
                    ArrayList selection = null;
                    try {
                        selection = crossSelectionInterface.getSelection();
                    }
                    catch (Exception e) {
                        m_logger.error("wart : selection not ready ", (Throwable)e);
                    }
                    if (selection != null) {
                        for (Long l : selection) {
                            result.add(l.intValue());
                        }
                    }
                }
                return result;
            }
        }
        return super.getDataImpl(parameterType, parameterSubtype);
    }

    @Override
    public Object getExtraData(Class parameterType) {
        if (parameterType.equals(ExtendedTableModelInterface.class)) {
            return new GraphicExtraData(this.m_keepZoom, new Double(0.0));
        }
        return super.getExtraData(parameterType);
    }

    @Override
    public String getFullName() {
        if (this.m_dataset == null) {
            return super.getFullName();
        }
        return this.m_dataset.getName() + " " + this.getTypeName();
    }

    private List<ExtendedTableModelInterface> getTableModelInterfaceList() {
        if (this.m_quantChannelInfo == null && this.m_previousDataBox != null) {
            this.m_quantChannelInfo = (QuantChannelInfo)this.getData(QuantChannelInfo.class);
            if (this.m_quantChannelInfo == null) {
                return null;
            }
        }
        ArrayList<ExtendedTableModelInterface> list = new ArrayList<ExtendedTableModelInterface>();
        if (this.m_masterQuantPeptideList != null) {
            for (int i = 0; i < this.m_masterQuantPeptideList.size(); ++i) {
                DMasterQuantPeptide quantPeptide = this.m_masterQuantPeptideList.get(i);
                XICComparePeptideTableModel peptideData = new XICComparePeptideTableModel();
                peptideData.setData(this.m_quantChannelInfo.getQuantChannels(), quantPeptide, this.m_isXICMode);
                list.add(peptideData);
            }
        }
        return list;
    }

    @Override
    public Class[] getDataboxNavigationOutParameterClasses() {
        return new Class[]{DMasterQuantPeptide.class, DPeptideMatch.class};
    }

    @Override
    public String getDataboxNavigationDisplayValue() {
        Peptide peptide;
        DPeptideInstance peptideInstance;
        DMasterQuantPeptide mqp = (DMasterQuantPeptide)this.getData(DMasterQuantPeptide.class);
        if (mqp != null && (peptideInstance = mqp.getPeptideInstance()) != null && (peptide = peptideInstance.getPeptide()) != null) {
            return peptide.getSequence();
        }
        return null;
    }
}

