/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.actions.identification;

import fr.proline.core.orm.uds.Project;
import fr.proline.core.orm.uds.QuantitationMethod;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.core.orm.uds.dto.DDatasetType;
import fr.proline.core.orm.uds.dto.DMasterQuantitationChannel;
import fr.proline.studio.WindowManager;
import fr.proline.studio.dam.AccessDatabaseThread;
import fr.proline.studio.dam.DatabaseDataManager;
import fr.proline.studio.dam.data.AbstractData;
import fr.proline.studio.dam.data.DataSetData;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.dam.tasks.xic.DatabaseLoadXicMasterQuantTask;
import fr.proline.studio.dpm.AccessJMSManagerThread;
import fr.proline.studio.dpm.task.jms.AbstractJMSCallback;
import fr.proline.studio.dpm.task.jms.AbstractJMSTask;
import fr.proline.studio.dpm.task.jms.RunQuantitationTask;
import fr.proline.studio.rsmexplorer.actions.identification.AbstractRSMAction;
import fr.proline.studio.rsmexplorer.gui.ProjectExplorerPanel;
import fr.proline.studio.rsmexplorer.gui.dialog.xic.CreateQuantitationDialog;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.AbstractTree;
import fr.proline.studio.rsmexplorer.tree.ChildFactory;
import fr.proline.studio.rsmexplorer.tree.DataSetNode;
import fr.proline.studio.rsmexplorer.tree.identification.IdentificationTree;
import fr.proline.studio.rsmexplorer.tree.quantitation.QuantitationTree;
import java.awt.Component;
import java.awt.Window;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultTreeModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateQuantitationAction
extends AbstractRSMAction {
    protected static final Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer");
    private QuantitationMethod.Type m_quantitationType;
    private boolean m_isFromExistingQuantitation = false;
    private boolean m_referenceDataSetDefined = false;

    static String getMessage(boolean fromExistingXIC, QuantitationMethod.Type type) {
        switch (type) {
            case LABEL_FREE: {
                if (fromExistingXIC) {
                    return "Clone & Extract Abundances...";
                }
                return "Label Free...";
            }
            case RESIDUE_LABELING: {
                return "Residue Labeling...";
            }
            case ISOBARIC_TAGGING: {
                return "Isobaric Labeling...";
            }
        }
        return "unknown";
    }

    public CreateQuantitationAction(AbstractTree tree, boolean fromExistingXIC) {
        super(CreateQuantitationAction.getMessage(fromExistingXIC, QuantitationMethod.Type.LABEL_FREE), tree);
        this.m_quantitationType = QuantitationMethod.Type.LABEL_FREE;
        this.m_isFromExistingQuantitation = fromExistingXIC;
    }

    public CreateQuantitationAction(AbstractTree tree, QuantitationMethod.Type type) {
        super(CreateQuantitationAction.getMessage(false, type), tree);
        this.m_quantitationType = type;
        this.m_isFromExistingQuantitation = false;
    }

    @Override
    public void actionPerformed(AbstractNode[] selectedNodes, int x, int y) {
        if (ProjectExplorerPanel.getProjectExplorerPanel().getSelectedProject() == null) {
            JOptionPane.showMessageDialog((Component)WindowManager.getDefault().getMainWindow(), "A project should be selected !", "Warning", 0);
            return;
        }
        if (this.m_isFromExistingQuantitation) {
            final DDataset currentDataset = ((DataSetData)((DataSetNode)selectedNodes[0]).getData()).getDataset();
            final int posx = x;
            final int posy = y;
            AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

                public boolean mustBeCalledInAWT() {
                    return true;
                }

                public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                    CreateQuantitationAction.this.createQuantitationDialog(currentDataset, posx, posy);
                }
            };
            DatabaseLoadXicMasterQuantTask task = new DatabaseLoadXicMasterQuantTask(callback);
            task.initLoadQuantChannels(ProjectExplorerPanel.getProjectExplorerPanel().getSelectedProject().getId(), currentDataset);
            AccessDatabaseThread.getAccessDatabaseThread().addTask((AbstractDatabaseTask)task);
        } else {
            AbstractNode n = selectedNodes[0];
            DDataset refDataset = null;
            if (!n.isRoot() && DataSetNode.class.isInstance(n)) {
                DataSetNode node = (DataSetNode)n;
                DataSetData dataset = (DataSetData)node.getData();
                DDatasetType dsType = dataset.getDatasetType();
                if (node.hasResultSummary() && (dsType.isAggregation() || dsType.isIdentification())) {
                    this.m_referenceDataSetDefined = true;
                    refDataset = dataset.getDataset();
                } else {
                    this.m_referenceDataSetDefined = false;
                }
            }
            this.createQuantitationDialog(refDataset, x, y);
        }
    }

    private void createQuantitationDialog(DDataset dataset, int x, int y) {
        DDataset existingDataset;
        Long pID = ProjectExplorerPanel.getProjectExplorerPanel().getSelectedProject().getId();
        CreateQuantitationDialog dialog = CreateQuantitationDialog.getDialog((Window)WindowManager.getDefault().getMainWindow());
        IdentificationTree childTree = null;
        DDataset refDataset = null;
        Object object = existingDataset = this.m_isFromExistingQuantitation ? dataset : null;
        if (this.m_referenceDataSetDefined) {
            childTree = IdentificationTree.getCurrentTree().copyDataSetRootSubTree(dataset, dataset.getProject().getId());
            refDataset = dataset;
        } else if (existingDataset != null && ((DMasterQuantitationChannel)existingDataset.getMasterQuantitationChannels().get(0)).getIdentDataset() != null) {
            refDataset = ((DMasterQuantitationChannel)dataset.getMasterQuantitationChannels().get(0)).getIdentDataset();
            childTree = IdentificationTree.getCurrentTree().copyDataSetRootSubTree(refDataset, refDataset.getProject().getId());
            if (childTree == null) {
                m_logger.debug("Reference dataset not already loaded: creates a new node to display in a new IdentificationTree");
                childTree = new IdentificationTree(ChildFactory.createNode((AbstractData)new DataSetData(refDataset)));
            }
        }
        dialog.initializeExperimentalDesignTree(existingDataset, refDataset, childTree, this.m_quantitationType);
        dialog.setLocation(x, y);
        dialog.setVisible(true);
        final Long[] _xicQuantiDataSetId = new Long[1];
        if (dialog.getButtonClicked() == 0) {
            DataSetData _quantiDS = null;
            Map<String, Object> expParams = null;
            StringBuffer errorMsg = new StringBuffer("");
            Map<String, Object> quantParams = dialog.getQuantiParameters();
            if (quantParams == null) {
                errorMsg.append("Null Quantitation parameters !  ");
            }
            if (dialog.getQuantitationDataset() == null) {
                errorMsg.append("No experimental design defined  ");
            } else {
                String registerErrMsg = dialog.registerRawFiles();
                if (registerErrMsg != null && !registerErrMsg.isEmpty()) {
                    errorMsg.append(registerErrMsg);
                }
                _quantiDS = dialog.getQuantitationDataset();
                try {
                    expParams = dialog.getExperimentalDesignParameters();
                }
                catch (IllegalAccessException iae) {
                    errorMsg.append(iae.getMessage());
                }
            }
            if (!errorMsg.toString().isEmpty()) {
                JOptionPane.showMessageDialog((Component)((Object)dialog), errorMsg, "Warning", 0);
                return;
            }
            m_logger.debug(" Will Compute Quantitation on " + ((List)expParams.get("biological_samples")).size() + "samples.");
            QuantitationTree tree = QuantitationTree.getCurrentTree();
            final DefaultTreeModel treeModel = (DefaultTreeModel)tree.getModel();
            final DataSetNode[] _quantitationNode = new DataSetNode[]{QuantitationTree.getCurrentTree().createQuantitationNode(_quantiDS.getName())};
            AbstractJMSCallback quantCallback = new AbstractJMSCallback(){

                public boolean mustBeCalledInAWT() {
                    return true;
                }

                public void run(boolean success) {
                    if (success) {
                        m_logger.debug(" Quantitation SUCCESS : " + _xicQuantiDataSetId[0]);
                        QuantitationTree.getCurrentTree().loadDataSet(_xicQuantiDataSetId[0], _quantitationNode[0]);
                    } else {
                        m_logger.debug(" Quantitation ERROR ");
                        treeModel.removeNodeFromParent(_quantitationNode[0]);
                    }
                }
            };
            RunQuantitationTask task = new RunQuantitationTask(quantCallback, pID, _quantiDS.getName(), quantParams, expParams, dialog.getQuantMethodId(), _xicQuantiDataSetId);
            AccessJMSManagerThread.getAccessJMSManagerThread().addTask((AbstractJMSTask)task);
        }
    }

    @Override
    public void updateEnabled(AbstractNode[] selectedNodes) {
        Project selectedProject = ProjectExplorerPanel.getProjectExplorerPanel().getSelectedProject();
        if (!DatabaseDataManager.getDatabaseDataManager().ownProject(selectedProject)) {
            this.setEnabled(false);
            return;
        }
        if (this.m_isFromExistingQuantitation) {
            if (selectedNodes.length != 1) {
                this.setEnabled(false);
                return;
            }
            AbstractNode node = selectedNodes[0];
            if (node.isChanging()) {
                this.setEnabled(false);
                return;
            }
            if (node.getType() != AbstractNode.NodeTypes.DATA_SET) {
                this.setEnabled(false);
                return;
            }
            DataSetNode datasetNode = (DataSetNode)node;
            if (!datasetNode.isQuantXIC()) {
                this.setEnabled(false);
                return;
            }
        } else {
            AbstractNode node = selectedNodes[0];
            if (node.getType() != AbstractNode.NodeTypes.DATA_SET && node.getType() != AbstractNode.NodeTypes.PROJECT_QUANTITATION) {
                this.setEnabled(false);
                return;
            }
            if (node.getType() == AbstractNode.NodeTypes.DATA_SET && ((DataSetNode)node).isFolder()) {
                this.setEnabled(false);
                return;
            }
        }
        this.setEnabled(true);
    }
}

