/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.actions.xic;

import fr.proline.core.orm.uds.Project;
import fr.proline.studio.dam.DatabaseDataManager;
import fr.proline.studio.rsmexplorer.actions.identification.AbstractRSMAction;
import fr.proline.studio.rsmexplorer.gui.ProjectExplorerPanel;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.AbstractTree;
import java.util.ArrayList;

public class DeleteAction
extends AbstractRSMAction {
    public DeleteAction(AbstractTree tree) {
        super("Delete", tree);
    }

    @Override
    public void actionPerformed(AbstractNode[] selectedNodes, int x, int y) {
        int nbSelectedNode = selectedNodes.length;
        if (nbSelectedNode == 0) {
            return;
        }
        AbstractTree.RSMTreeModel model = (AbstractTree.RSMTreeModel)this.getTree().getModel();
        ArrayList<AbstractNode> keptNodes = new ArrayList<AbstractNode>(nbSelectedNode);
        keptNodes.add(selectedNodes[0]);
        block0: for (int i = 1; i < nbSelectedNode; ++i) {
            AbstractNode curKeptNode;
            int j;
            AbstractNode curNode = selectedNodes[i];
            int nbKeptNodes = keptNodes.size();
            for (j = 0; j < nbKeptNodes; ++j) {
                curKeptNode = (AbstractNode)keptNodes.get(j);
                if (curNode.isNodeAncestor(curKeptNode)) continue block0;
            }
            for (j = nbKeptNodes - 1; j >= 0; --j) {
                curKeptNode = (AbstractNode)keptNodes.get(j);
                if (!curKeptNode.isNodeAncestor(curNode)) continue;
                keptNodes.remove(j);
            }
            keptNodes.add(curNode);
        }
        int nbKeptNodes = keptNodes.size();
        for (int i = 0; i < nbKeptNodes; ++i) {
            AbstractNode nodeCur = (AbstractNode)keptNodes.get(i);
            model.removeNodeFromParent(nodeCur);
        }
    }

    @Override
    public void updateEnabled(AbstractNode[] selectedNodes) {
        Project selectedProject = ProjectExplorerPanel.getProjectExplorerPanel().getSelectedProject();
        if (!DatabaseDataManager.getDatabaseDataManager().ownProject(selectedProject)) {
            this.setEnabled(false);
            return;
        }
        for (AbstractNode node : selectedNodes) {
            AbstractNode.NodeTypes type = node.getType();
            if (type == AbstractNode.NodeTypes.BIOLOGICAL_GROUP || type == AbstractNode.NodeTypes.BIOLOGICAL_SAMPLE_ANALYSIS || type == AbstractNode.NodeTypes.BIOLOGICAL_SAMPLE) continue;
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }
}

