/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.adjacencymatrix.visualize;

import fr.proline.studio.dam.tasks.data.LightPeptideMatch;
import fr.proline.studio.dam.tasks.data.LightProteinMatch;
import fr.proline.studio.dam.tasks.data.WeakPeptideReference;
import fr.proline.studio.rsmexplorer.adjacencymatrix.visualize.DrawVisualization;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

public class Component {
    private ArrayList<LightProteinMatch> m_proteinMatchArray = new ArrayList();
    private ArrayList<LightProteinMatch> m_proteinMatchWithEquivalentArray = null;
    private ArrayList<LightPeptideMatch> m_peptideArray = new ArrayList();
    public HashMap<LightProteinMatch, ArrayList<LightProteinMatch>> m_equivalentProteins = null;
    private HashMap<Integer, WeakPeptideReference> m_weakPeptidesMap = null;

    public ArrayList<LightProteinMatch> getProteinArray(boolean withEquivalents) {
        if (!withEquivalents) {
            return this.m_proteinMatchArray;
        }
        if (this.m_proteinMatchWithEquivalentArray == null) {
            this.prepareProteinMatchEquivalentArray();
        }
        return this.m_proteinMatchWithEquivalentArray;
    }

    public void setProteinArray(ArrayList<LightProteinMatch> proteinArray) {
        this.m_proteinMatchArray = proteinArray;
    }

    public ArrayList<LightPeptideMatch> getPeptideArray() {
        return this.m_peptideArray;
    }

    public void setPeptideArray(ArrayList<LightPeptideMatch> peptideArray) {
        this.m_peptideArray = peptideArray;
    }

    public int getPeptideSize() {
        return this.m_peptideArray.size();
    }

    public int getProteinSize(boolean withEquivalents) {
        if (!withEquivalents) {
            return this.m_proteinMatchArray.size();
        }
        if (this.m_proteinMatchWithEquivalentArray == null) {
            this.prepareProteinMatchEquivalentArray();
        }
        return this.m_proteinMatchWithEquivalentArray.size();
    }

    private void prepareProteinMatchEquivalentArray() {
        this.m_proteinMatchWithEquivalentArray = new ArrayList();
        int size = this.m_proteinMatchArray.size();
        for (int i = 0; i < size; ++i) {
            LightProteinMatch proteinCur = this.m_proteinMatchArray.get(i);
            ArrayList<LightProteinMatch> equivalentProteinsArray = this.m_equivalentProteins.get(proteinCur);
            this.m_proteinMatchWithEquivalentArray.add(proteinCur);
            if (equivalentProteinsArray == null) continue;
            int sizeEq = equivalentProteinsArray.size();
            for (int j = 0; j < sizeEq; ++j) {
                this.m_proteinMatchWithEquivalentArray.add(equivalentProteinsArray.get(j));
            }
        }
    }

    public int[][] getPeptProtMatrix(HashMap<LightPeptideMatch, ArrayList<LightProteinMatch>> peptideToProteinMap) {
        int peptideSize = this.m_peptideArray.size();
        int proteinSize = this.m_proteinMatchArray.size();
        HashMap<LightProteinMatch, Integer> proteinIndexMap = new HashMap<LightProteinMatch, Integer>(proteinSize);
        int index = 0;
        for (LightProteinMatch tempProt : this.m_proteinMatchArray) {
            proteinIndexMap.put(tempProt, index);
            ++index;
        }
        int[][] tempMatch = new int[peptideSize][proteinSize];
        int i = 0;
        for (LightPeptideMatch tempPept : this.m_peptideArray) {
            ArrayList<LightProteinMatch> proteinList = peptideToProteinMap.get(tempPept);
            boolean j = false;
            for (LightProteinMatch tempProt : proteinList) {
                tempMatch[i][((Integer)proteinIndexMap.get((Object)tempProt)).intValue()] = 1;
            }
            ++i;
        }
        return tempMatch;
    }

    public boolean isWeakPeptide(int peptideIndex, long proteinSetId) {
        WeakPeptideReference weakPeptideReference = this.m_weakPeptidesMap.get(peptideIndex);
        if (weakPeptideReference == null) {
            return false;
        }
        return weakPeptideReference.correspondToProteinSet(proteinSetId);
    }

    public void searchWeakPeptides(DrawVisualization drawVisualization, double weakPeptideScoreThreshold) {
        if (this.m_weakPeptidesMap != null) {
            this.m_weakPeptidesMap.clear();
        }
        this.m_weakPeptidesMap = new HashMap();
        HashMap<LightPeptideMatch, ArrayList<LightProteinMatch>> peptideToProteinMap = drawVisualization.getPeptideToProteinMap();
        HashMap<LightProteinMatch, ArrayList<LightPeptideMatch>> proteinToPeptideMap = drawVisualization.getProteinToPeptideMap();
        int[][] pepProtMatrix = this.getPeptProtMatrix(peptideToProteinMap);
        int nbPeptides = pepProtMatrix.length;
        int nbProteins = pepProtMatrix[0].length;
        HashMap<Long, Integer> mapProtein = new HashMap<Long, Integer>();
        for (int i = 0; i < nbProteins; ++i) {
            int nbPeptidesSelected;
            LightProteinMatch proteinMatch = this.m_proteinMatchArray.get(i);
            Long proteinSetId = proteinMatch.getProteinSetId();
            Integer proteinMatchSelectedIndex = (Integer)mapProtein.get(proteinSetId);
            if (proteinMatchSelectedIndex == null) {
                mapProtein.put(proteinSetId, i);
                continue;
            }
            int nbPeptidesCur = proteinToPeptideMap.get(proteinMatch).size();
            if (nbPeptidesCur <= (nbPeptidesSelected = proteinToPeptideMap.get(this.m_proteinMatchArray.get(proteinMatchSelectedIndex)).size())) continue;
            mapProtein.put(proteinSetId, i);
        }
        Set ids = mapProtein.keySet();
        Long[] proteinSetIds = ids.toArray(new Long[ids.size()]);
        for (int i = 0; i < proteinSetIds.length - 1; ++i) {
            for (int j = i + 1; j < proteinSetIds.length; ++j) {
                LightPeptideMatch peptide;
                Long proteinSetId1 = proteinSetIds[i];
                Long proteinSetId2 = proteinSetIds[j];
                Integer pm1Index = (Integer)mapProtein.get(proteinSetId1);
                Integer pm2Index = (Integer)mapProtein.get(proteinSetId2);
                int nbCommonPeptides = 0;
                int commonPeptideIndex = -1;
                for (int k = 0; k < nbPeptides; ++k) {
                    if (pepProtMatrix[k][pm1Index] <= 0 || pepProtMatrix[k][pm2Index] <= 0) continue;
                    commonPeptideIndex = k;
                    if (++nbCommonPeptides >= 2) break;
                }
                if (nbCommonPeptides != true || !((double)(peptide = this.m_peptideArray.get(commonPeptideIndex)).getScore().floatValue() <= weakPeptideScoreThreshold)) continue;
                WeakPeptideReference weakPeptide = this.m_weakPeptidesMap.get(commonPeptideIndex);
                if (weakPeptide == null) {
                    weakPeptide = new WeakPeptideReference(commonPeptideIndex, proteinSetId1.longValue(), proteinSetId2.longValue());
                    this.m_weakPeptidesMap.put(commonPeptideIndex, weakPeptide);
                    continue;
                }
                weakPeptide.add(proteinSetId1.longValue(), proteinSetId2.longValue());
            }
        }
    }
}

