/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.calc.graph;

import fr.proline.studio.rsmexplorer.gui.calc.GraphPanel;
import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.JPopupMenu;

public abstract class AbstractGraphObject {
    protected static final BasicStroke STROKE_SELECTED = new BasicStroke(4.0f);
    protected static final BasicStroke STROKE_NOT_SELECTED = new BasicStroke(2.0f);
    protected static Font m_font = null;
    protected static Font m_fontBold = null;
    protected static int m_hgtBold;
    protected static int m_hgtPlain;
    protected static int m_ascentBold;
    protected boolean m_selected = false;
    protected boolean m_hightlighted = false;
    protected TypeGraphObject m_type;

    public AbstractGraphObject(TypeGraphObject type) {
        this.m_type = type;
    }

    public TypeGraphObject getType() {
        return this.m_type;
    }

    public abstract void draw(Graphics var1);

    public abstract AbstractGraphObject inside(int var1, int var2);

    public abstract void move(int var1, int var2);

    public int correctMoveX(int dx) {
        return dx;
    }

    public int correctMoveY(int dy) {
        return dy;
    }

    public abstract void delete();

    public void setSelected(boolean s) {
        this.m_selected = s;
    }

    public boolean isSelected() {
        return this.m_selected;
    }

    public boolean setHighlighted(boolean h) {
        if (h ^ this.m_hightlighted) {
            this.m_hightlighted = h;
            return true;
        }
        return false;
    }

    public boolean isHighlighted() {
        return this.m_hightlighted;
    }

    public abstract JPopupMenu createPopup(GraphPanel var1);

    public abstract String getTooltip(int var1, int var2);

    public static enum TypeGraphObject {
        GRAPH_NODE,
        CONNECTOR,
        LINK,
        GRAPH_NODE_ACTION,
        GROUP;

    }
}

