/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.dialog.xic.aggregation;

import fr.proline.core.orm.uds.QuantitationChannel;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.studio.rsmexplorer.gui.dialog.xic.aggregation.DQuantitationChannelMapping;
import fr.proline.studio.rsmexplorer.gui.dialog.xic.aggregation.QCMappingTreeTableModel;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.xic.XICBiologicalSampleAnalysisNode;
import fr.proline.studio.utils.IconManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.treetable.TreeTableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QCMappingTreeTable
extends JXTreeTable {
    private static final Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer.AggregationQuant");
    private static final int UP = -1;
    public static final int DOWN = 1;
    public static final String ERRASE = "Remove";
    public static final String MOVE_UP = "Move Up";
    public static final String MOVE_DOWN = "Move Down";
    public static final String INSERT_UP = "Insert Up";
    public static final String INSERT_DOWN = "Insert Down";
    private QCMappingTreeTableModel m_model;
    DQuantitationChannelMapping m_holdChannelMapping;

    public QCMappingTreeTable(QCMappingTreeTableModel treeModel) {
        super((TreeTableModel)treeModel);
        this.m_model = treeModel;
        this.setCellSelectionEnabled(true);
        this.setAutoResizeMode(4);
        super.setSelectionMode(1);
        this.addMouseListener(new PopupAdapter());
    }

    public String getToolTipText(MouseEvent event) {
        int row;
        int column = this.columnAtPoint(event.getPoint());
        if (column > 0 && column < this.getColumnCount() && (row = this.rowAtPoint(event.getPoint())) < this.getRowCount()) {
            return this.m_model.getToolTipText(this.getNodeForRow(row), column);
        }
        return super.getToolTipText(event);
    }

    public AbstractNode getNodeForRow(int row) {
        TreePath path = this.getPathForRow(row);
        return path != null ? (AbstractNode)path.getLastPathComponent() : null;
    }

    public void removeAssociateChannel() {
        int[] rowList = this.getSelectedRows();
        int[] columnList = this.getSelectedColumns();
        for (int row : rowList) {
            for (int column : columnList) {
                AbstractNode node = this.getNodeForRow(this.convertRowIndexToModel(row));
                DQuantitationChannelMapping mapping = this.m_model.getRowMapping(node);
                if (mapping == null) continue;
                mapping.remove(this.m_model.getDatasetAt(this.convertColumnIndexToModel(column)));
            }
        }
        this.clearSelection();
        this.repaint();
    }

    private boolean isSelectionOk(ArrayList<Integer> selectRows, ArrayList<Integer> selectCols) {
        if (selectRows.isEmpty()) {
            return false;
        }
        int[] columnList = this.getSelectedColumns();
        for (int nb = 0; nb < columnList.length; ++nb) {
            if (columnList[nb] != 0) continue;
            return false;
        }
        for (int row : selectRows) {
            for (int col : selectCols) {
                AbstractNode node = this.getNodeForRow(row);
                if (!this.m_model.isEmptyChannel(node, col)) continue;
                return false;
            }
        }
        return true;
    }

    protected synchronized void moveUpDown(int weight, boolean isInsertMode) {
        AbstractNode targetNode;
        Object coverdMapping;
        int[] columnList;
        int[] rows = this.getSelectedRows();
        ArrayList<Integer> selectedModelRows = new ArrayList<Integer>();
        for (int row : rows) {
            selectedModelRows.add(this.convertRowIndexToModel(row));
        }
        ArrayList<Integer> selectedModelCols = new ArrayList<Integer>();
        for (int col : columnList = this.getSelectedColumns()) {
            selectedModelCols.add(this.convertColumnIndexToModel(col));
        }
        if (!this.isSelectionOk(selectedModelRows, selectedModelCols)) {
            return;
        }
        ArrayList<Integer> newSelectedModelRows = new ArrayList<Integer>();
        if (weight == -1) {
            Collections.sort(selectedModelRows);
        } else {
            Collections.sort(selectedModelRows, Collections.reverseOrder());
        }
        if (this.isEndChannel(selectedModelRows, weight)) {
            return;
        }
        int firstRow = selectedModelRows.get(0);
        int lastRow = selectedModelRows.get(selectedModelRows.size() - 1);
        if (isInsertMode) {
            int nextRow = this.getNextChannelRowIndex(firstRow, weight);
            coverdMapping = this.m_model.getRowMapping(this.getNodeForRow(nextRow));
            this.m_holdChannelMapping = new DQuantitationChannelMapping(-1);
            for (int column : selectedModelCols) {
                if (column == 0) continue;
                DDataset quanti = this.m_model.getDatasetAt(column);
                QuantitationChannel coverdChannel = ((DQuantitationChannelMapping)coverdMapping).getQuantChannel(quanti);
                this.m_holdChannelMapping.put(quanti, coverdChannel);
            }
        }
        coverdMapping = selectedModelRows.iterator();
        while (coverdMapping.hasNext()) {
            int row = coverdMapping.next();
            for (int column : selectedModelCols) {
                int targetRow = this.setNextRow(row, column, weight);
                if (targetRow == -1) continue;
                newSelectedModelRows.add(this.convertRowIndexToView(targetRow));
            }
        }
        if (isInsertMode && (targetNode = this.getNodeForRow(lastRow)) instanceof XICBiologicalSampleAnalysisNode) {
            for (int column : columnList) {
                if (column == 0) continue;
                DQuantitationChannelMapping mapping = this.m_model.getRowMapping(targetNode);
                DDataset quanti = this.m_model.getDatasetAt(column);
                mapping.put(quanti, this.m_holdChannelMapping.getQuantChannel(quanti));
            }
        }
        if (newSelectedModelRows.size() > 0) {
            Collections.sort(newSelectedModelRows);
            for (int i = 0; i < newSelectedModelRows.size(); ++i) {
                int nRow = (Integer)newSelectedModelRows.get(i);
                if (nRow >= this.getRowCount()) continue;
                int index = this.convertRowIndexToView(nRow);
                if (i <= 0) {
                    this.setRowSelectionInterval(index, index);
                    continue;
                }
                this.addRowSelectionInterval(index, index);
            }
            this.repaint();
        }
    }

    private boolean isEndChannel(List<Integer> selectedRowList, int weight) {
        for (int row : selectedRowList) {
            AbstractNode srcNode = this.getNodeForRow(row);
            if (!XICBiologicalSampleAnalysisNode.class.isInstance(srcNode)) continue;
            int nextIndex = row + weight;
            if (nextIndex < 0 || nextIndex >= this.getRowCount()) {
                return true;
            }
            return this.getNextChannelRowIndex(row, weight) == -1;
        }
        return false;
    }

    public int getNextChannelRowIndex(int row, int weight) {
        for (int recoveredRow = row + weight; recoveredRow >= 0 && recoveredRow < this.getRowCount(); recoveredRow += weight) {
            DQuantitationChannelMapping targetMapping = this.m_model.getRowMapping(this.getNodeForRow(recoveredRow));
            if (targetMapping == null) {
                continue;
            }
            return recoveredRow;
        }
        return -1;
    }

    private int setNextRow(int row, int column, int weight) {
        AbstractNode srcNode = this.getNodeForRow(row);
        if (srcNode instanceof XICBiologicalSampleAnalysisNode) {
            DDataset col = this.m_model.getDatasetAt(column);
            DQuantitationChannelMapping srcRowMapping = this.m_model.getRowMapping(srcNode);
            QuantitationChannel srcChannel = srcRowMapping.getQuantChannel(col);
            int targetIndexChannelNode = this.getNextChannelRowIndex(row, weight);
            if (targetIndexChannelNode != -1) {
                DQuantitationChannelMapping targetRowMapping = this.m_model.getRowMapping(this.getNodeForRow(targetIndexChannelNode));
                if (srcChannel != null) {
                    srcRowMapping.remove(col);
                    targetRowMapping.put(col, srcChannel);
                } else {
                    targetRowMapping.put(col, null);
                }
            }
            return targetIndexChannelNode;
        }
        return -1;
    }

    public void moveUp() {
        this.moveUpDown(-1, false);
    }

    public void moveDown() {
        this.moveUpDown(1, false);
    }

    public void moveInsertUp() {
        this.moveUpDown(-1, true);
    }

    public void moveInsertDown() {
        this.moveUpDown(1, true);
    }

    protected void manageSelectionOnRightClick(MouseEvent e) {
        List<Integer> selectedColList;
        List<Integer> selectedRowList;
        int x = e.getX();
        int y = e.getY();
        Point p = new Point(x, y);
        int Coloumn = this.columnAtPoint(p);
        int row = this.rowAtPoint(p);
        int[] selectedRows = this.getSelectedRows();
        int[] selectedCols = this.getSelectedColumns();
        if (selectedRows.length != 0 && (selectedRowList = Arrays.stream(selectedRows).boxed().collect(Collectors.toList())).contains(row) && (selectedColList = Arrays.stream(selectedCols).boxed().collect(Collectors.toList())).contains(Coloumn) && this.isChannel(selectedRowList, selectedColList)) {
            this.triggerPopup(e);
        }
    }

    private boolean isChannel(List<Integer> rowList, List<Integer> columnList) {
        for (int row : rowList) {
            AbstractNode o = this.getNodeForRow(this.convertRowIndexToModel(row));
            for (int column : columnList) {
                int col = this.convertColumnIndexToModel(column);
                if (col == 0) {
                    return false;
                }
                Object value = this.m_model.getChannelAt(o, col);
                if (value != null) continue;
                return false;
            }
        }
        return true;
    }

    private void triggerPopup(MouseEvent e) {
        JPopupMenu popup = new JPopupMenu();
        ActionListener menuListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                String command = event.getActionCommand();
                if (command.equals(QCMappingTreeTable.ERRASE)) {
                    QCMappingTreeTable.this.removeAssociateChannel();
                } else if (command.equals(QCMappingTreeTable.INSERT_UP)) {
                    QCMappingTreeTable.this.moveUpDown(-1, true);
                } else if (command.equals(QCMappingTreeTable.INSERT_DOWN)) {
                    QCMappingTreeTable.this.moveUpDown(1, true);
                } else if (command.equals(QCMappingTreeTable.MOVE_UP)) {
                    QCMappingTreeTable.this.moveUpDown(-1, false);
                } else if (command.equals(QCMappingTreeTable.MOVE_DOWN)) {
                    QCMappingTreeTable.this.moveUpDown(1, false);
                }
            }
        };
        JMenuItem item = new JMenuItem(ERRASE, IconManager.getIcon((IconManager.IconType)IconManager.IconType.ERASER));
        popup.add(item);
        item.setHorizontalTextPosition(4);
        item.addActionListener(menuListener);
        popup.addSeparator();
        item = new JMenuItem(INSERT_UP, IconManager.getIcon((IconManager.IconType)IconManager.IconType.ARROW_INSERT_UP));
        popup.add(item);
        item.setHorizontalTextPosition(4);
        item.addActionListener(menuListener);
        item = new JMenuItem(INSERT_DOWN, IconManager.getIcon((IconManager.IconType)IconManager.IconType.ARROW_INSERT_DOWN));
        popup.add(item);
        item.setHorizontalTextPosition(4);
        item.addActionListener(menuListener);
        popup.addSeparator();
        item = new JMenuItem(MOVE_UP, IconManager.getIcon((IconManager.IconType)IconManager.IconType.ARROW_MOVE_UP));
        popup.add(item);
        item.setHorizontalTextPosition(4);
        item.addActionListener(menuListener);
        item = new JMenuItem(MOVE_DOWN, IconManager.getIcon((IconManager.IconType)IconManager.IconType.ARROW_MOVE_DOWN));
        popup.add(item);
        item.setHorizontalTextPosition(4);
        item.addActionListener(menuListener);
        popup.show((JComponent)e.getSource(), e.getX(), e.getY());
    }

    class PopupAdapter
    extends MouseAdapter {
        PopupAdapter() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e)) {
                QCMappingTreeTable.this.manageSelectionOnRightClick(e);
            }
        }
    }
}

