/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.xic;

import fr.proline.core.orm.msi.ResultSummary;
import fr.proline.core.orm.msi.dto.DMasterQuantProteinSet;
import fr.proline.core.orm.msi.dto.DProteinMatch;
import fr.proline.core.orm.msi.dto.DProteinSet;
import fr.proline.core.orm.msi.dto.DQuantProteinSet;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.core.orm.uds.dto.DQuantitationChannel;
import fr.proline.studio.export.ExportFontData;
import fr.proline.studio.extendedtablemodel.CompoundTableModel;
import fr.proline.studio.extendedtablemodel.ExtraDataType;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.filter.DoubleFilter;
import fr.proline.studio.filter.Filter;
import fr.proline.studio.filter.IntegerFilter;
import fr.proline.studio.filter.StringDiffFilter;
import fr.proline.studio.graphics.PlotInformation;
import fr.proline.studio.graphics.PlotType;
import fr.proline.studio.rsmexplorer.gui.renderer.CompareValueRenderer;
import fr.proline.studio.rsmexplorer.gui.renderer.FloatRenderer;
import fr.proline.studio.rsmexplorer.gui.xic.QuantChannelInfo;
import fr.proline.studio.table.ExportTableSelectionInterface;
import fr.proline.studio.table.LazyData;
import fr.proline.studio.table.LazyTable;
import fr.proline.studio.table.LazyTableModel;
import fr.proline.studio.table.TableDefaultRendererManager;
import fr.proline.studio.table.renderer.BigFloatOrDoubleRenderer;
import fr.proline.studio.table.renderer.DefaultRightAlignRenderer;
import fr.proline.studio.table.renderer.GrayedRenderer;
import fr.proline.studio.types.QuantitationType;
import fr.proline.studio.types.XicGroup;
import fr.proline.studio.types.XicMode;
import fr.proline.studio.utils.CyclicColorPalette;
import fr.proline.studio.utils.StringUtils;
import fr.proline.studio.utils.URLCellRenderer;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.TableCellRenderer;

public class QuantProteinSetTableModel
extends LazyTableModel
implements ExportTableSelectionInterface,
GlobalTableModelInterface {
    public static final int COLTYPE_PROTEIN_SET_ID = 0;
    public static final int COLTYPE_PROTEIN_SET_NAME = 1;
    public static final int COLTYPE_OVERVIEW = 2;
    public static final int COLTYPE_DESCRIPTION = 3;
    public static final int COLTYPE_NB_PEPTIDE = 4;
    public static final int COLTYPE_NB_QUANT_PEPTIDE = 5;
    public static final int COLTYPE_PROTEIN_SET_GENE_NAME = 6;
    public static final int LAST_STATIC_COLUMN = 6;
    private static final String[] m_columnNames = new String[]{"Id", "Protein Set", "Overview", "Description", "#Peptide", "<html>#Quant.<br/>Peptide</html>", "Gene Name"};
    private static final String[] m_columnNamesForFilter = new String[]{"Id", "Protein Set", "Overview", "Description", "#Peptide", "#Quant.Peptide", "Gene Name"};
    private static final String[] m_toolTipColumns = new String[]{"MasterQuantProteinSet Id", "Identified Protein label", "Overview", "Description", "Number of Identified Peptides", "Number of Quantified Peptides", "Correcponding Gene Name. This information is fill in during 'Retrieve Sequence' task."};
    public static final int COLTYPE_PEP_NUMBER = 0;
    public static final int COLTYPE_SELECTION_LEVEL = 1;
    public static final int COLTYPE_PSM = 2;
    public static final int COLTYPE_RAW_ABUNDANCE = 3;
    public static final int COLTYPE_ABUNDANCE = 4;
    public static final int COLTYPE_STATUS = 5;
    private static final String[] m_columnNamesQC = new String[]{"#Quant. Peptides", "Sel. level", "#Quant. PSMs", "Raw abundance", "Abundance"};
    private static final String[] m_toolTipQC = new String[]{"Not Applicable [Number of different peptides for this condition...]", "Selection level (manual or automatique [in]validation)", "Quantified Peptides matches count", "Raw abundance", "Abundance"};
    private static final String[] m_columnNamesQC_SC = new String[]{"Peptides Count", "Sel. level", "Basic SC", "Specific SC", "Weighted SC", "Status"};
    private static final String[] m_toolTipQC_SC = new String[]{"Number of different peptides for this condition", "Selection level", "Basic Spectral Count", "Specific Spectral Count", "Weighted Spectral Count", "Status (typical, subset or sameset) of the protein in this condition"};
    private List<DMasterQuantProteinSet> m_proteinSets = null;
    private DQuantitationChannel[] m_quantChannels = null;
    private int m_quantChannelNumber;
    private int m_overviewType = 4;
    private String m_modelName;
    private boolean m_isXICMode;
    private final HashMap<Integer, TableCellRenderer> m_rendererMap = new HashMap();
    private final HashMap<Integer, TableCellRenderer> m_rendererMapGrayed = new HashMap();

    public QuantProteinSetTableModel(LazyTable table) {
        super(table);
    }

    public int getColumnCount() {
        if (this.m_quantChannels == null) {
            return m_columnNames.length;
        }
        if (this.m_isXICMode) {
            return m_columnNames.length + this.m_quantChannelNumber * m_columnNamesQC.length;
        }
        return m_columnNames.length + this.m_quantChannelNumber * m_columnNamesQC_SC.length;
    }

    private int getColumnPerQCCount() {
        if (this.m_quantChannels == null) {
            return 0;
        }
        if (this.m_isXICMode) {
            return m_columnNamesQC.length;
        }
        return m_columnNamesQC_SC.length;
    }

    public String getColumnName(int col) {
        if (col <= 6) {
            return m_columnNames[col];
        }
        int nbQc = (col - m_columnNames.length) / this.getColumnPerQCCount();
        int id = col - m_columnNames.length - nbQc * this.getColumnPerQCCount();
        StringBuilder sb = new StringBuilder();
        String rsmHtmlColor = CyclicColorPalette.getHTMLColor((int)nbQc);
        sb.append("<html><font color='").append(rsmHtmlColor).append("'>&#x25A0;&nbsp;</font>");
        if (this.m_isXICMode) {
            sb.append(m_columnNamesQC[id]);
        } else {
            sb.append(m_columnNamesQC_SC[id]);
        }
        sb.append("<br/>");
        sb.append(this.m_quantChannels[nbQc].getName());
        sb.append("</html>");
        return sb.toString();
    }

    public String getColumnNameForFilter(int col) {
        if (col <= 6) {
            return m_columnNamesForFilter[col];
        }
        if (this.m_quantChannels != null) {
            int nbQc = (col - m_columnNames.length) / this.getColumnPerQCCount();
            int id = col - m_columnNames.length - nbQc * this.getColumnPerQCCount();
            return this.m_isXICMode ? m_columnNamesQC[id] : m_columnNamesQC_SC[id];
        }
        return "";
    }

    public String getExportColumnName(int col) {
        if (col <= 6) {
            return m_columnNamesForFilter[col];
        }
        if (this.m_quantChannels != null) {
            int nbQc = (col - m_columnNames.length) / this.getColumnPerQCCount();
            int id = col - m_columnNames.length - nbQc * this.getColumnPerQCCount();
            StringBuilder sb = new StringBuilder();
            if (this.m_isXICMode) {
                sb.append(m_columnNamesQC[id]);
            } else {
                sb.append(m_columnNamesQC_SC[id]);
            }
            sb.append(" ");
            sb.append(this.m_quantChannels[nbQc].getName());
            return sb.toString();
        }
        return "";
    }

    public String getToolTipForHeader(int col) {
        if (col == 2) {
            return m_toolTipColumns[col] + " on " + (this.m_isXICMode ? m_toolTipQC[this.m_overviewType] : m_toolTipQC_SC[this.m_overviewType]);
        }
        if (col <= 6) {
            return m_toolTipColumns[col];
        }
        int nbQc = (col - m_columnNames.length) / this.getColumnPerQCCount();
        int id = col - m_columnNames.length - nbQc * this.getColumnPerQCCount();
        String rawFilePath = StringUtils.truncate((String)this.m_quantChannels[nbQc].getRawFilePath(), (int)50);
        StringBuilder sb = new StringBuilder();
        String rsmHtmlColor = CyclicColorPalette.getHTMLColor((int)nbQc);
        sb.append("<html><font color='").append(rsmHtmlColor).append("'>&#x25A0;&nbsp;</font>");
        if (this.m_isXICMode) {
            sb.append(m_toolTipQC[id]);
        } else {
            sb.append(m_toolTipQC_SC[id]);
        }
        sb.append("<br/>");
        sb.append(this.m_quantChannels[nbQc].getFullName());
        sb.append("<br/>");
        sb.append(rawFilePath);
        sb.append("</html>");
        return sb.toString();
    }

    public String getTootlTipValue(int row, int col) {
        return null;
    }

    public Class getColumnClass(int col) {
        if (col == 0) {
            return Long.class;
        }
        if (col == 2) {
            return CompareValueRenderer.CompareValue.class;
        }
        return LazyData.class;
    }

    @Override
    public int getSubTaskId(int col) {
        return 0;
    }

    public int getRowCount() {
        if (this.m_proteinSets == null) {
            return 0;
        }
        return this.m_proteinSets.size();
    }

    public Object getValueAt(final int row, int col) {
        DMasterQuantProteinSet proteinSet = this.m_proteinSets.get(row);
        switch (col) {
            case 0: {
                return proteinSet.getId();
            }
            case 1: {
                LazyData lazyData = this.getLazyData(row, col);
                DProteinMatch proteinMatch = null;
                if (proteinSet.getProteinSet() != null) {
                    proteinMatch = proteinSet.getProteinSet().getTypicalProteinMatch();
                    if (proteinMatch == null) {
                        lazyData.setData((Comparable)((Object)""));
                    } else {
                        lazyData.setData((Comparable)((Object)proteinMatch.getAccession()));
                    }
                } else {
                    lazyData.setData(null);
                    this.givePriorityTo(this.m_taskId, row, col);
                }
                return lazyData;
            }
            case 2: {
                return new CompareValueRenderer.CompareValue(){

                    @Override
                    public int getNumberColumns() {
                        return QuantProteinSetTableModel.this.m_quantChannels.length;
                    }

                    @Override
                    public Color getColor(int col) {
                        return CyclicColorPalette.getColor((int)col);
                    }

                    @Override
                    public double getValue(int col) {
                        if (QuantProteinSetTableModel.this.m_overviewType == -1) {
                            return 0.0;
                        }
                        int realCol = 7 + QuantProteinSetTableModel.this.m_overviewType + col * QuantProteinSetTableModel.this.getColumnPerQCCount();
                        LazyData lazyData = (LazyData)QuantProteinSetTableModel.this.getValueAt(row, realCol);
                        if (lazyData != null && lazyData.getData() != null && Number.class.isAssignableFrom(lazyData.getData().getClass())) {
                            return ((Number)lazyData.getData()).floatValue();
                        }
                        return 0.0;
                    }

                    public double getValueNoNaN(int col) {
                        double val = this.getValue(col);
                        if (val != val) {
                            return 0.0;
                        }
                        return val;
                    }

                    @Override
                    public double getMaximumValue() {
                        int nbCols = this.getNumberColumns();
                        double maxValue = 0.0;
                        for (int i = 0; i < nbCols; ++i) {
                            double v = this.getValue(i);
                            if (!(v > maxValue)) continue;
                            maxValue = v;
                        }
                        return maxValue;
                    }

                    @Override
                    public double calculateComparableValue() {
                        int nbColumns = this.getNumberColumns();
                        double mean = 0.0;
                        for (int i = 0; i < nbColumns; ++i) {
                            mean += this.getValueNoNaN(i);
                        }
                        mean /= (double)nbColumns;
                        double maxDiff = 0.0;
                        for (int i = 0; i < nbColumns; ++i) {
                            double diff = this.getValueNoNaN(i) - mean;
                            if (diff < 0.0) {
                                diff = -diff;
                            }
                            if (!(diff > maxDiff)) continue;
                            maxDiff = diff;
                        }
                        return maxDiff / mean;
                    }

                    @Override
                    public int compareTo(CompareValueRenderer.CompareValue o) {
                        return Double.compare(this.calculateComparableValue(), o.calculateComparableValue());
                    }
                };
            }
            case 6: {
                LazyData lazyData = this.getLazyData(row, col);
                DProteinMatch proteinMatch = null;
                if (proteinSet.getProteinSet() != null) {
                    proteinMatch = proteinSet.getProteinSet().getTypicalProteinMatch();
                    if (proteinMatch == null) {
                        lazyData.setData((Comparable)((Object)""));
                    } else {
                        String geneName = proteinMatch.getGeneName();
                        if (geneName == null) {
                            geneName = "";
                        }
                        lazyData.setData((Comparable)((Object)geneName));
                    }
                } else {
                    lazyData.setData(null);
                    this.givePriorityTo(this.m_taskId, row, col);
                }
                return lazyData;
            }
            case 3: {
                LazyData lazyData = this.getLazyData(row, col);
                DProteinMatch proteinMatch = null;
                if (proteinSet.getProteinSet() != null) {
                    proteinMatch = proteinSet.getProteinSet().getTypicalProteinMatch();
                    if (proteinMatch == null) {
                        lazyData.setData((Comparable)((Object)""));
                    } else {
                        lazyData.setData((Comparable)((Object)proteinMatch.getDescription()));
                    }
                } else {
                    lazyData.setData(null);
                    this.givePriorityTo(this.m_taskId, row, col);
                }
                return lazyData;
            }
            case 4: {
                LazyData lazyData = this.getLazyData(row, col);
                if (proteinSet.getProteinSet() != null) {
                    lazyData.setData((Comparable)Integer.valueOf(proteinSet.getNbPeptides()));
                } else {
                    lazyData.setData(null);
                    this.givePriorityTo(this.m_taskId, row, col);
                }
                return lazyData;
            }
            case 5: {
                LazyData lazyData = this.getLazyData(row, col);
                if (proteinSet.getProteinSet() != null) {
                    lazyData.setData((Comparable)Integer.valueOf(proteinSet.getNbQuantifiedPeptides()));
                } else {
                    lazyData.setData(null);
                    this.givePriorityTo(this.m_taskId, row, col);
                }
                return lazyData;
            }
        }
        LazyData lazyData = this.getLazyData(row, col);
        if (proteinSet.getProteinSet() == null) {
            lazyData.setData(null);
            this.givePriorityTo(this.m_taskId, row, col);
        } else {
            int nbQc = (col - m_columnNames.length) / this.getColumnPerQCCount();
            int id = col - m_columnNames.length - nbQc * this.getColumnPerQCCount();
            Map quantProteinSetByQchIds = proteinSet.getQuantProteinSetByQchIds();
            if (quantProteinSetByQchIds == null) {
                switch (id) {
                    case 0: {
                        lazyData.setData((Comparable)Integer.valueOf(0));
                        break;
                    }
                    case 1: {
                        lazyData.setData((Comparable)Integer.valueOf(0));
                        break;
                    }
                    case 4: {
                        lazyData.setData((Comparable)Float.valueOf(0.0f));
                        break;
                    }
                    case 3: {
                        lazyData.setData((Comparable)Float.valueOf(0.0f));
                        break;
                    }
                    case 2: {
                        lazyData.setData((Comparable)Integer.valueOf(0));
                        break;
                    }
                    case 5: {
                        lazyData.setData((Comparable)((Object)""));
                    }
                }
            } else {
                DQuantProteinSet quantProteinSet = (DQuantProteinSet)quantProteinSetByQchIds.get(this.m_quantChannels[nbQc].getId());
                if (quantProteinSet == null) {
                    switch (id) {
                        case 0: {
                            lazyData.setData((Comparable)Integer.valueOf(0));
                            break;
                        }
                        case 1: {
                            lazyData.setData((Comparable)Integer.valueOf(0));
                            break;
                        }
                        case 4: {
                            lazyData.setData((Comparable)Float.valueOf(0.0f));
                            break;
                        }
                        case 3: {
                            lazyData.setData((Comparable)Float.valueOf(0.0f));
                            break;
                        }
                        case 2: {
                            lazyData.setData((Comparable)Integer.valueOf(0));
                            break;
                        }
                        case 5: {
                            lazyData.setData((Comparable)((Object)""));
                        }
                    }
                } else {
                    Map quantStatusByQCIds = proteinSet.getQuantStatusByQchIds();
                    String status = proteinSet.getQuantStatusByQchIds().getOrDefault(this.m_quantChannels[nbQc].getId(), "");
                    Integer pepNumber = (Integer)proteinSet.getQuantPeptideNumberByQchIds().get(this.m_quantChannels[nbQc].getId());
                    if (pepNumber == null || pepNumber < 0) {
                        pepNumber = 0;
                    }
                    switch (id) {
                        case 0: {
                            lazyData.setData((Comparable)(quantProteinSet.getPeptidesCount() == null || quantProteinSet.getPeptidesCount() == 0 ? pepNumber : quantProteinSet.getPeptidesCount()));
                            break;
                        }
                        case 1: {
                            lazyData.setData((Comparable)quantProteinSet.getSelectionLevel());
                            break;
                        }
                        case 4: {
                            lazyData.setData((Comparable)(quantProteinSet.getAbundance() == null || quantProteinSet.getAbundance().isNaN() ? Float.valueOf(0.0f) : quantProteinSet.getAbundance()));
                            break;
                        }
                        case 3: {
                            lazyData.setData((Comparable)(quantProteinSet.getRawAbundance() == null || quantProteinSet.getRawAbundance().isNaN() ? Float.valueOf(0.0f) : quantProteinSet.getRawAbundance()));
                            break;
                        }
                        case 2: {
                            lazyData.setData((Comparable)(quantProteinSet.getPeptideMatchesCount() == null ? Integer.valueOf(0) : quantProteinSet.getPeptideMatchesCount()));
                            break;
                        }
                        case 5: {
                            lazyData.setData((Comparable)((Object)status));
                        }
                    }
                }
            }
        }
        return lazyData;
    }

    public DMasterQuantProteinSet getMasterQuantProteinSet(int row) {
        DMasterQuantProteinSet quantProteinSet = this.m_proteinSets.get(row);
        return quantProteinSet;
    }

    public DProteinSet getProteinSet(int row) {
        DMasterQuantProteinSet quantProteinSet = this.m_proteinSets.get(row);
        return quantProteinSet.getProteinSet();
    }

    public void setData(Long taskId, DQuantitationChannel[] quantChannels, List<DMasterQuantProteinSet> proteinSets, boolean isXICMode) {
        this.m_quantChannels = quantChannels;
        this.m_quantChannelNumber = quantChannels.length;
        this.m_proteinSets = proteinSets;
        this.m_isXICMode = isXICMode;
        this.m_taskId = taskId;
        this.fireTableStructureChanged();
    }

    public void dataUpdated() {
        this.fireTableDataChanged();
    }

    public boolean dataModified(ArrayList modificationsList) {
        HashMap<Long, DMasterQuantProteinSet> modifiedMap = new HashMap<Long, DMasterQuantProteinSet>(modificationsList.size());
        for (int i = 0; i < modificationsList.size(); ++i) {
            DMasterQuantProteinSet masterQuantProteinSet = (DMasterQuantProteinSet)modificationsList.get(i);
            modifiedMap.put(masterQuantProteinSet.getId(), masterQuantProteinSet);
        }
        boolean modificationDone = false;
        for (int i = 0; i < this.m_proteinSets.size(); ++i) {
            DMasterQuantProteinSet masterQuantProteinSet = this.m_proteinSets.get(i);
            Long id = masterQuantProteinSet.getId();
            DMasterQuantProteinSet proteinSetModified = (DMasterQuantProteinSet)modifiedMap.get(id);
            if (proteinSetModified == null) continue;
            proteinSetModified.setProteinSet(masterQuantProteinSet.getProteinSet());
            this.m_proteinSets.set(i, proteinSetModified);
            modificationDone = true;
        }
        if (modificationDone) {
            this.fireTableDataChanged();
        }
        return modificationDone;
    }

    public DMasterQuantProteinSet getQuantProteinSet(int i) {
        return this.m_proteinSets.get(i);
    }

    public int findRow(long proteinSetId) {
        int nb = this.m_proteinSets.size();
        for (int i = 0; i < nb; ++i) {
            if (proteinSetId != this.m_proteinSets.get(i).getProteinSetId()) continue;
            return i;
        }
        return -1;
    }

    public void sortAccordingToModel(ArrayList<Long> proteinSetIds, CompoundTableModel compoundTableModel) {
        if (this.m_proteinSets == null) {
            return;
        }
        HashSet<Long> proteinSetIdMap = new HashSet<Long>(proteinSetIds.size());
        proteinSetIdMap.addAll(proteinSetIds);
        int nb = this.m_table.getRowCount();
        int iCur = 0;
        for (int iView = 0; iView < nb; ++iView) {
            DMasterQuantProteinSet ps;
            int iModel = this.m_table.convertRowIndexToModel(iView);
            if (compoundTableModel != null) {
                iModel = compoundTableModel.convertCompoundRowToBaseModelRow(iModel);
            }
            if (!proteinSetIdMap.contains((ps = this.getQuantProteinSet(iModel)).getProteinSetId())) continue;
            proteinSetIds.set(iCur++, ps.getProteinSetId());
        }
    }

    public void addFilters(LinkedHashMap<Integer, Filter> filtersMap) {
        filtersMap.put(1, (Filter)new StringDiffFilter(this.getColumnNameForFilter(1), null, 1));
        filtersMap.put(3, (Filter)new StringDiffFilter(this.getColumnNameForFilter(3), null, 3));
        filtersMap.put(6, (Filter)new StringDiffFilter(this.getColumnNameForFilter(6), null, 6));
        filtersMap.put(4, (Filter)new IntegerFilter(this.getColumnNameForFilter(4), null, 4));
        filtersMap.put(5, (Filter)new IntegerFilter(this.getColumnNameForFilter(5), null, 5));
        int nbCol = this.getColumnCount();
        block8: for (int i = 7; i < nbCol; ++i) {
            int nbQc = (i - m_columnNames.length) / this.getColumnPerQCCount();
            int id = i - m_columnNames.length - nbQc * this.getColumnPerQCCount();
            switch (id) {
                case 0: {
                    filtersMap.put(i, (Filter)new IntegerFilter(this.getColumnName(i), null, i));
                    continue block8;
                }
                case 1: {
                    filtersMap.put(i, (Filter)new IntegerFilter(this.getColumnName(i), null, i));
                    continue block8;
                }
                case 4: {
                    filtersMap.put(i, (Filter)new DoubleFilter(this.getColumnName(i), null, i));
                    continue block8;
                }
                case 3: {
                    filtersMap.put(i, (Filter)new DoubleFilter(this.getColumnName(i), null, i));
                    continue block8;
                }
                case 2: {
                    filtersMap.put(i, (Filter)new IntegerFilter(this.getColumnName(i), null, i));
                    continue block8;
                }
                case 5: {
                    filtersMap.put(i, (Filter)new StringDiffFilter(this.getColumnName(i), null, i));
                    continue block8;
                }
                default: {
                    filtersMap.put(i, (Filter)new DoubleFilter(this.getColumnName(i), null, i));
                }
            }
        }
    }

    public int getLoadingPercentage() {
        return this.m_table.getLoadingPercentage();
    }

    public boolean isLoaded() {
        return this.m_table.isLoaded();
    }

    public int getQCCount() {
        return this.m_quantChannels.length;
    }

    public int getQCColumStart(int index) {
        return m_columnNames.length + index * this.getColumnPerQCCount();
    }

    public int getQCColumStop(int index) {
        return m_columnNames.length + (1 + index) * this.getColumnPerQCCount() - 1;
    }

    public String getQCName(int index) {
        StringBuilder sb = new StringBuilder();
        String rsmHtmlColor = CyclicColorPalette.getHTMLColor((int)index);
        sb.append("<html><font color='").append(rsmHtmlColor).append("'>&#x25A0;&nbsp;</font>");
        sb.append(this.m_quantChannels[index].getFullName());
        sb.append("</html>");
        return sb.toString();
    }

    public String getByQCMColumnName(int index) {
        return this.m_isXICMode ? m_columnNamesQC[index] : m_columnNamesQC_SC[index];
    }

    public int getQCNumber(int col) {
        return (col - m_columnNames.length) / this.getColumnPerQCCount();
    }

    public int getQCColIndex(int col) {
        return (col - m_columnNames.length) % this.getColumnPerQCCount();
    }

    public Long getResultSummaryId() {
        if (this.m_proteinSets == null || this.m_proteinSets.isEmpty()) {
            return null;
        }
        return this.m_proteinSets.get(0).getQuantResultSummaryId();
    }

    public void setOverviewType(int overviewType) {
        this.m_overviewType = overviewType;
        this.fireTableDataChanged();
    }

    public int getOverviewType() {
        return this.m_overviewType;
    }

    public List<Integer> getDefaultColumnsToHide() {
        ArrayList<Integer> listIds = new ArrayList<Integer>();
        listIds.add(0);
        listIds.add(6);
        if (this.m_quantChannels != null) {
            for (int i = this.m_quantChannels.length - 1; i >= 0; --i) {
                listIds.add(m_columnNames.length + 1 + i * this.getColumnPerQCCount());
                if (!this.m_isXICMode) continue;
                listIds.add(m_columnNames.length + 3 + i * this.getColumnPerQCCount());
                listIds.add(m_columnNames.length + 0 + i * this.getColumnPerQCCount());
            }
        }
        return listIds;
    }

    public HashSet exportSelection(int[] rows) {
        int nbRows = rows.length;
        HashSet<Long> selectedObjects = new HashSet<Long>();
        for (int i = 0; i < nbRows; ++i) {
            int row = rows[i];
            DMasterQuantProteinSet proteinSet = this.m_proteinSets.get(row);
            selectedObjects.add(proteinSet.getProteinSet().getId());
        }
        return selectedObjects;
    }

    public String getDataColumnIdentifier(int col) {
        if (col <= 6) {
            return m_columnNamesForFilter[col];
        }
        int nbQc = (col - m_columnNames.length) / this.getColumnPerQCCount();
        int id = col - m_columnNames.length - nbQc * this.getColumnPerQCCount();
        StringBuilder sb = new StringBuilder();
        if (this.m_isXICMode) {
            sb.append(m_columnNamesQC[id]);
        } else {
            sb.append(m_columnNamesQC_SC[id]);
        }
        sb.append(' ');
        sb.append(this.m_quantChannels[nbQc].getName());
        return sb.toString();
    }

    public Class getDataColumnClass(int col) {
        switch (col) {
            case 0: {
                return Long.class;
            }
            case 1: 
            case 6: {
                return String.class;
            }
            case 2: {
                return CompareValueRenderer.CompareValue.class;
            }
            case 3: {
                return String.class;
            }
            case 4: {
                return Integer.class;
            }
            case 5: {
                return Integer.class;
            }
        }
        int nbQc = (col - m_columnNames.length) / this.getColumnPerQCCount();
        int id = col - m_columnNames.length - nbQc * this.getColumnPerQCCount();
        switch (id) {
            case 0: {
                return Integer.class;
            }
            case 1: {
                return Integer.class;
            }
            case 4: {
                return Float.class;
            }
            case 3: {
                return Float.class;
            }
            case 2: {
                return Integer.class;
            }
            case 5: {
                return String.class;
            }
        }
        return null;
    }

    public Object getDataValueAt(int rowIndex, int columnIndex) {
        Object data = this.getValueAt(rowIndex, columnIndex);
        if (data instanceof LazyData) {
            data = ((LazyData)data).getData();
        }
        return data;
    }

    public int[] getKeysColumn() {
        int[] keys = new int[]{1};
        return keys;
    }

    public void setName(String name) {
        this.m_modelName = name;
    }

    public String getName() {
        return this.m_modelName;
    }

    public int getInfoColumn() {
        return 1;
    }

    public Map<String, Object> getExternalData() {
        return null;
    }

    public PlotInformation getPlotInformation() {
        return null;
    }

    public String getExportRowCell(int row, int col) {
        DMasterQuantProteinSet proteinSet = this.m_proteinSets.get(row);
        switch (col) {
            case 0: {
                return "" + proteinSet.getId();
            }
            case 1: {
                DProteinMatch proteinMatch = null;
                if (proteinSet.getProteinSet() != null) {
                    proteinMatch = proteinSet.getProteinSet().getTypicalProteinMatch();
                    if (proteinMatch == null) {
                        return "";
                    }
                    return proteinMatch.getAccession();
                }
                return "";
            }
            case 2: {
                return "";
            }
            case 3: {
                if (proteinSet.getProteinSet() != null) {
                    DProteinMatch proteinMatch = proteinSet.getProteinSet().getTypicalProteinMatch();
                    if (proteinMatch == null) {
                        return "";
                    }
                    return proteinMatch.getDescription();
                }
                return "";
            }
            case 6: {
                if (proteinSet.getProteinSet() != null) {
                    DProteinMatch proteinMatch = proteinSet.getProteinSet().getTypicalProteinMatch();
                    if (proteinMatch == null) {
                        return "";
                    }
                    return proteinMatch.getGeneName();
                }
                return "";
            }
            case 4: {
                if (proteinSet.getProteinSet() != null) {
                    return "" + proteinSet.getNbPeptides();
                }
                return "";
            }
            case 5: {
                if (proteinSet.getProteinSet() != null) {
                    return "" + proteinSet.getNbQuantifiedPeptides();
                }
                return "";
            }
        }
        int nbQc = (col - m_columnNames.length) / this.getColumnPerQCCount();
        int id = col - m_columnNames.length - nbQc * this.getColumnPerQCCount();
        if (proteinSet.getProteinSet() == null) {
            switch (id) {
                case 0: {
                    return Integer.toString(0);
                }
                case 1: {
                    return Integer.toString(0);
                }
                case 4: {
                    return Float.toString(0.0f);
                }
                case 3: {
                    return Float.toString(0.0f);
                }
                case 2: {
                    return Integer.toString(0);
                }
                case 5: {
                    return "";
                }
            }
        } else {
            Map quantProteinSetByQchIds = proteinSet.getQuantProteinSetByQchIds();
            if (quantProteinSetByQchIds == null) {
                switch (id) {
                    case 0: {
                        return Integer.toString(0);
                    }
                    case 1: {
                        return Integer.toString(0);
                    }
                    case 4: {
                        return Float.toString(0.0f);
                    }
                    case 3: {
                        return Float.toString(0.0f);
                    }
                    case 2: {
                        return Integer.toString(0);
                    }
                    case 5: {
                        return "";
                    }
                }
            } else {
                DQuantProteinSet quantProteinSet = (DQuantProteinSet)quantProteinSetByQchIds.get(this.m_quantChannels[nbQc].getId());
                if (quantProteinSet == null) {
                    switch (id) {
                        case 0: {
                            return Integer.toString(0);
                        }
                        case 1: {
                            return Integer.toString(0);
                        }
                        case 4: {
                            return Float.toString(0.0f);
                        }
                        case 3: {
                            return Float.toString(0.0f);
                        }
                        case 2: {
                            return Integer.toString(0);
                        }
                        case 5: {
                            return "";
                        }
                    }
                } else {
                    Integer pepNumber = (Integer)proteinSet.getQuantPeptideNumberByQchIds().get(this.m_quantChannels[nbQc].getId());
                    if (pepNumber == null || pepNumber < 0) {
                        pepNumber = 0;
                    }
                    switch (id) {
                        case 0: {
                            return quantProteinSet.getPeptidesCount() == null || quantProteinSet.getPeptidesCount() == 0 ? Integer.toString(pepNumber) : Integer.toString(quantProteinSet.getPeptidesCount());
                        }
                        case 1: {
                            return quantProteinSet.getSelectionLevel() == null ? Integer.toString(0) : Integer.toString(quantProteinSet.getSelectionLevel());
                        }
                        case 4: {
                            return quantProteinSet.getAbundance() == null || quantProteinSet.getAbundance().isNaN() ? Float.toString(0.0f) : Float.toString(quantProteinSet.getAbundance().floatValue());
                        }
                        case 3: {
                            return quantProteinSet.getRawAbundance() == null || quantProteinSet.getRawAbundance().isNaN() ? Float.toString(0.0f) : Float.toString(quantProteinSet.getRawAbundance().floatValue());
                        }
                        case 2: {
                            return quantProteinSet.getPeptideMatchesCount() == null ? Integer.toString(0) : Integer.toString(quantProteinSet.getPeptideMatchesCount());
                        }
                        case 5: {
                            String status = (String)proteinSet.getQuantStatusByQchIds().get(this.m_quantChannels[nbQc].getId());
                            return status;
                        }
                    }
                }
            }
        }
        return "";
    }

    public ArrayList<ExportFontData> getExportFonts(int row, int col) {
        return null;
    }

    public PlotType getBestPlotType() {
        return null;
    }

    public int[] getBestColIndex(PlotType plotType) {
        return null;
    }

    public Boolean containsModifiedQuantProteinSet() {
        Boolean containsModifed = false;
        try {
            int nbRow = this.getRowCount();
            for (int i = 0; i < nbRow; ++i) {
                DMasterQuantProteinSet proteinSet = this.m_proteinSets.get(i);
                Map pmqSerializedMap = proteinSet.getSerializedPropertiesAsMap();
                if (pmqSerializedMap == null || !pmqSerializedMap.containsKey("selection_changed") || !pmqSerializedMap.get("selection_changed").equals(Boolean.TRUE)) continue;
                containsModifed = true;
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return containsModifed;
    }

    public ArrayList<DMasterQuantProteinSet> getModifiedQuantProteinSet() {
        ArrayList<DMasterQuantProteinSet> masterQuantProteinSetModified = new ArrayList<DMasterQuantProteinSet>();
        try {
            int nbRow = this.getRowCount();
            for (int i = 0; i < nbRow; ++i) {
                DMasterQuantProteinSet proteinSet = this.m_proteinSets.get(i);
                Map pmqSerializedMap = proteinSet.getSerializedPropertiesAsMap();
                if (pmqSerializedMap == null || !pmqSerializedMap.containsKey("selection_changed") || !pmqSerializedMap.get("selection_changed").equals(Boolean.TRUE)) continue;
                masterQuantProteinSetModified.add(proteinSet);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return masterQuantProteinSetModified;
    }

    public TableCellRenderer getRenderer(int row, int col) {
        if (this.m_proteinSets == null) {
            return null;
        }
        DMasterQuantProteinSet proteinSet = this.m_proteinSets.get(row);
        boolean grayed = false;
        try {
            Map pmqSerializedMap = proteinSet.getSerializedPropertiesAsMap();
            grayed = pmqSerializedMap != null && pmqSerializedMap.containsKey("selection_changed") && pmqSerializedMap.get("selection_changed").equals(Boolean.TRUE);
        }
        catch (Exception pmqSerializedMap) {
            // empty catch block
        }
        if (grayed) {
            if (this.m_rendererMapGrayed.containsKey(col)) {
                return this.m_rendererMapGrayed.get(col);
            }
        } else if (this.m_rendererMap.containsKey(col)) {
            return this.m_rendererMap.get(col);
        }
        Object renderer = null;
        block1 : switch (col) {
            case 0: {
                break;
            }
            case 1: {
                renderer = new URLCellRenderer("URL_Template_Protein_Accession", "http://www.uniprot.org/uniprot/", 1);
                break;
            }
            case 2: {
                renderer = new CompareValueRenderer();
                break;
            }
            case 4: 
            case 5: {
                renderer = new DefaultRightAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(Integer.class));
                break;
            }
            default: {
                int nbQc = (col - m_columnNames.length) / this.getColumnPerQCCount();
                int id = col - m_columnNames.length - nbQc * this.getColumnPerQCCount();
                switch (id) {
                    case 0: {
                        renderer = new DefaultRightAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(Integer.class));
                        break block1;
                    }
                    case 1: 
                    case 2: {
                        renderer = new DefaultRightAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(Integer.class));
                        break block1;
                    }
                    case 4: {
                        if (this.m_isXICMode) {
                            renderer = new BigFloatOrDoubleRenderer((TableCellRenderer)new DefaultRightAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class)), 0);
                            break block1;
                        }
                        renderer = new FloatRenderer((TableCellRenderer)new DefaultRightAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class)), 2);
                        break block1;
                    }
                    case 3: {
                        renderer = this.m_isXICMode ? new BigFloatOrDoubleRenderer((TableCellRenderer)new DefaultRightAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class)), 0) : new FloatRenderer((TableCellRenderer)new DefaultRightAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class)), 0);
                    }
                }
            }
        }
        if (grayed) {
            if (renderer == null) {
                return null;
            }
            renderer = new GrayedRenderer((TableCellRenderer)renderer);
            this.m_rendererMapGrayed.put(col, (TableCellRenderer)renderer);
        } else {
            this.m_rendererMap.put(col, (TableCellRenderer)renderer);
        }
        return renderer;
    }

    public GlobalTableModelInterface getFrozzenModel() {
        return this;
    }

    public ArrayList<ExtraDataType> getExtraDataTypes() {
        ArrayList<ExtraDataType> list = new ArrayList<ExtraDataType>();
        list.add(new ExtraDataType(DProteinSet.class, true));
        list.add(new ExtraDataType(DMasterQuantProteinSet.class, true));
        list.add(new ExtraDataType(DDataset.class, false));
        list.add(new ExtraDataType(QuantChannelInfo.class, false));
        list.add(new ExtraDataType(ResultSummary.class, false));
        list.add(new ExtraDataType(XicMode.class, false));
        this.registerSingleValuesAsExtraTypes(list);
        return list;
    }

    public Object getValue(Class c) {
        return this.getSingleValue(c);
    }

    public Object getRowValue(Class c, int row) {
        if (c.equals(DMasterQuantProteinSet.class)) {
            return this.m_proteinSets.get(row);
        }
        if (c.equals(DProteinSet.class)) {
            DMasterQuantProteinSet masterQuantProteinSet = this.m_proteinSets.get(row);
            return masterQuantProteinSet != null ? masterQuantProteinSet.getProteinSet() : null;
        }
        return null;
    }

    public Object getColValue(Class c, int col) {
        if (c.equals(XicGroup.class)) {
            if (col <= 6) {
                return null;
            }
            int nbQc = (col - m_columnNames.length) / this.getColumnPerQCCount();
            return new XicGroup(this.m_quantChannels[nbQc].getBiologicalGroupId(), null);
        }
        if (c.equals(QuantitationType.class)) {
            if (col <= 6) {
                return null;
            }
            int nbQc = (col - m_columnNames.length) / this.getColumnPerQCCount();
            int id = col - m_columnNames.length - nbQc * this.getColumnPerQCCount();
            if (this.m_isXICMode) {
                switch (id) {
                    case 4: {
                        return QuantitationType.getQuantitationType((int)0);
                    }
                    case 3: {
                        return QuantitationType.getQuantitationType((int)1);
                    }
                }
            } else {
                switch (id) {
                    case 2: {
                        return QuantitationType.getQuantitationType((int)2);
                    }
                    case 3: {
                        return QuantitationType.getQuantitationType((int)3);
                    }
                    case 4: {
                        return QuantitationType.getQuantitationType((int)4);
                    }
                }
            }
            return null;
        }
        return null;
    }
}

