/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.xic;

import fr.proline.core.orm.lcms.Feature;
import fr.proline.core.orm.lcms.Peak;
import fr.proline.core.orm.lcms.Peakel;
import fr.proline.studio.WindowManager;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.dock.AbstractTopPanel;
import fr.proline.studio.export.ExportButton;
import fr.proline.studio.export.ExportFontData;
import fr.proline.studio.export.ExportModelInterface;
import fr.proline.studio.extendedtablemodel.CompoundTableModel;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.GlobalTabelModelProviderInterface;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.filter.FilterButton;
import fr.proline.studio.filter.FilterTableModelInterface;
import fr.proline.studio.graphics.CrossSelectionInterface;
import fr.proline.studio.gui.HourglassPanel;
import fr.proline.studio.gui.SplittedPanelContainer;
import fr.proline.studio.markerbar.MarkerComponentInterface;
import fr.proline.studio.markerbar.MarkerContainerPanel;
import fr.proline.studio.parameter.SettingsButton;
import fr.proline.studio.parameter.SettingsInterface;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.DataBoxPanelInterface;
import fr.proline.studio.pattern.WindowBox;
import fr.proline.studio.pattern.WindowBoxFactory;
import fr.proline.studio.progress.ProgressBarDialog;
import fr.proline.studio.progress.ProgressInterface;
import fr.proline.studio.rsmexplorer.DataBoxViewerTopPanel;
import fr.proline.studio.rsmexplorer.gui.xic.PeakTableModel;
import fr.proline.studio.table.LazyTable;
import fr.proline.studio.table.TablePopupMenu;
import fr.proline.studio.utils.IconManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;

public class XicPeakPanel
extends HourglassPanel
implements DataBoxPanelInterface,
GlobalTabelModelProviderInterface {
    private AbstractDataBox m_dataBox;
    private JScrollPane m_peakScrollPane;
    private PeakTable m_peakTable;
    private MarkerContainerPanel m_markerContainerPanel;
    private SettingsButton m_settingsButton;
    private FilterButton m_filterButton;
    private ExportButton m_exportButton;
    private JButton m_graphicsButton;

    public XicPeakPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        final JPanel peakPanel = this.createPeakPanel();
        final JLayeredPane layeredPane = new JLayeredPane();
        layeredPane.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                Component c = e.getComponent();
                peakPanel.setBounds(0, 0, c.getWidth(), c.getHeight());
                layeredPane.revalidate();
                layeredPane.repaint();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
        this.add(layeredPane, "Center");
        layeredPane.add((Component)peakPanel, JLayeredPane.DEFAULT_LAYER);
    }

    private JPanel createPeakPanel() {
        JPanel peakPanel = new JPanel();
        peakPanel.setBounds(0, 0, 500, 400);
        peakPanel.setLayout(new BorderLayout());
        JPanel internalPanel = this.createInternalPanel();
        JToolBar toolbar = this.initToolbar();
        peakPanel.add((Component)toolbar, "West");
        peakPanel.add((Component)internalPanel, "Center");
        return peakPanel;
    }

    private JToolBar initToolbar() {
        JToolBar toolbar = new JToolBar(1);
        toolbar.setFloatable(false);
        this.m_settingsButton = new SettingsButton((ProgressInterface)this.m_peakTable.getModel(), (SettingsInterface)this.m_peakTable);
        this.m_filterButton = new FilterButton((FilterTableModelInterface)((CompoundTableModel)this.m_peakTable.getModel())){

            protected void filteringDone() {
                XicPeakPanel.this.m_dataBox.addDataChanged(ExtendedTableModelInterface.class);
                XicPeakPanel.this.m_dataBox.propagateDataChanged();
            }
        };
        this.m_exportButton = new ExportButton((ProgressInterface)((CompoundTableModel)this.m_peakTable.getModel()), "Peaks", (JXTable)this.m_peakTable);
        toolbar.add((Component)this.m_filterButton);
        toolbar.add((Component)this.m_settingsButton);
        toolbar.add((Component)this.m_exportButton);
        this.m_graphicsButton = new JButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.CHART));
        this.m_graphicsButton.setToolTipText("Graphics : Histogram / Scatter Plot");
        this.m_graphicsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!((CompoundTableModel)XicPeakPanel.this.m_peakTable.getModel()).isLoaded()) {
                    ProgressBarDialog dialog = ProgressBarDialog.getDialog((Window)WindowManager.getDefault().getMainWindow(), (ProgressInterface)((CompoundTableModel)XicPeakPanel.this.m_peakTable.getModel()), (String)"Data loading", (String)"Histogram functionnality is not available while data is loading. Please Wait.");
                    dialog.setLocation(XicPeakPanel.this.getLocationOnScreen().x + XicPeakPanel.this.m_graphicsButton.getWidth() + 5, ((XicPeakPanel)XicPeakPanel.this).m_graphicsButton.getLocationOnScreen().y + XicPeakPanel.this.getHeight() + 5);
                    dialog.setVisible(true);
                    if (!dialog.isWaitingFinished()) {
                        return;
                    }
                }
                WindowBox wbox = WindowBoxFactory.getGraphicsWindowBox("Peak Graphic", XicPeakPanel.this.m_dataBox, true);
                wbox.setEntryData(XicPeakPanel.this.m_dataBox.getProjectId(), XicPeakPanel.this.m_dataBox.getData(ExtendedTableModelInterface.class));
                DataBoxViewerTopPanel win = new DataBoxViewerTopPanel(wbox);
                WindowManager.getDefault().getMainWindow().displayWindow((AbstractTopPanel)win);
            }
        });
        toolbar.add(this.m_graphicsButton);
        return toolbar;
    }

    private JPanel createInternalPanel() {
        JPanel internalPanel = new JPanel();
        internalPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        this.m_peakScrollPane = new JScrollPane();
        this.m_peakTable = new PeakTable();
        this.m_peakTable.setModel((TableModel)new CompoundTableModel((GlobalTableModelInterface)new PeakTableModel(this.m_peakTable), true));
        this.m_peakTable.setSortable(false);
        this.m_markerContainerPanel = new MarkerContainerPanel(this.m_peakScrollPane, (MarkerComponentInterface)this.m_peakTable);
        this.m_peakScrollPane.setViewportView((Component)((Object)this.m_peakTable));
        this.m_peakTable.setFillsViewportHeight(true);
        this.m_peakTable.setViewport(this.m_peakScrollPane.getViewport());
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 3;
        internalPanel.add((Component)this.m_markerContainerPanel, c);
        return internalPanel;
    }

    public void setData(Long taskId, Feature feature, Peakel peakel, Integer isotopeIndex, List<Peak> peaks, Color color, String title, boolean finished) {
        ((PeakTableModel)((CompoundTableModel)this.m_peakTable.getModel()).getBaseModel()).setData(taskId, feature, peakel, isotopeIndex, peaks, color, false, title);
        if (peaks != null && peaks.size() > 0) {
            this.m_peakTable.getSelectionModel().setSelectionInterval(0, 0);
            this.m_markerContainerPanel.setMaxLineNumber(peaks.size());
        }
        if (finished) {
            this.m_peakTable.setSortable(true);
        }
    }

    public void dataUpdated(SubTask subTask, boolean finished) {
        this.m_peakTable.dataUpdated(subTask, finished);
        if (finished) {
            this.m_peakTable.setSortable(true);
        }
    }

    @Override
    public void setDataBox(AbstractDataBox dataBox) {
        this.m_dataBox = dataBox;
    }

    @Override
    public AbstractDataBox getDataBox() {
        return this.m_dataBox;
    }

    @Override
    public void addSingleValue(Object v) {
        this.getGlobalTableModelInterface().addSingleValue(v);
    }

    public GlobalTableModelInterface getGlobalTableModelInterface() {
        return (GlobalTableModelInterface)this.m_peakTable.getModel();
    }

    public JXTable getGlobalAssociatedTable() {
        return this.m_peakTable;
    }

    public ActionListener getRemoveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getRemoveAction(splittedPanel);
    }

    public ActionListener getAddAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getAddAction(splittedPanel);
    }

    public ActionListener getSaveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getSaveAction(splittedPanel);
    }

    public Peak getSelectedPeak() {
        return this.m_peakTable.getSelectedPeak();
    }

    public CrossSelectionInterface getCrossSelectionInterface() {
        return this.m_peakTable;
    }

    private class PeakTable
    extends LazyTable
    implements ExportModelInterface {
        String searchTextBeingDone;
        private boolean selectionWillBeRestored;

        public PeakTable() {
            super(XicPeakPanel.this.m_peakScrollPane.getVerticalScrollBar());
            this.searchTextBeingDone = null;
            this.selectionWillBeRestored = false;
        }

        public void addTableModelListener(TableModelListener l) {
            this.getModel().addTableModelListener(l);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            super.valueChanged(e);
            if (this.selectionWillBeRestored) {
                return;
            }
            if (e.getValueIsAdjusting()) {
                return;
            }
            if (XicPeakPanel.this.m_dataBox != null) {
                XicPeakPanel.this.m_dataBox.addDataChanged(Peak.class);
                XicPeakPanel.this.m_dataBox.propagateDataChanged();
            }
        }

        public boolean selectPeak(Long peakId, String searchText) {
            PeakTableModel tableModel = (PeakTableModel)((CompoundTableModel)this.getModel()).getBaseModel();
            int row = tableModel.findRow(peakId.longValue());
            if (row == -1) {
                return false;
            }
            row = ((CompoundTableModel)this.getModel()).convertBaseModelRowToCompoundRow(row);
            if (row == -1) {
                return false;
            }
            this.searchTextBeingDone = searchText;
            row = this.convertRowIndexToView(row);
            this.getSelectionModel().setSelectionInterval(row, row);
            this.scrollRowToVisible(row);
            this.searchTextBeingDone = null;
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dataUpdated(SubTask subTask, boolean finished) {
            LazyTable.LastAction keepLastAction = this.m_lastAction;
            try {
                int rowSelected = this.getSelectionModel().getMinSelectionIndex();
                int rowSelectedInModel = rowSelected == -1 ? -1 : this.convertRowIndexToModel(rowSelected);
                this.selectionWillBeRestored(true);
                try {
                    ((PeakTableModel)((CompoundTableModel)this.getModel()).getBaseModel()).dataUpdated();
                }
                finally {
                    this.selectionWillBeRestored(false);
                }
                if (rowSelectedInModel != -1) {
                    int rowSelectedInView = this.convertRowIndexToView(rowSelectedInModel);
                    this.setSelection(rowSelectedInView);
                    if ((keepLastAction == LazyTable.LastAction.ACTION_SELECTING || keepLastAction == LazyTable.LastAction.ACTION_SORTING) && subTask.getSubTaskId() == ((CompoundTableModel)this.getModel()).getSubTaskId(this.getSortedColumnIndex())) {
                        this.scrollRowToVisible(rowSelectedInView);
                    }
                }
            }
            finally {
                this.m_lastAction = keepLastAction;
            }
            if (finished) {
                this.setSortable(true);
            }
        }

        @Override
        public void sortingChanged(int col) {
        }

        public void selectionWillBeRestored(boolean b) {
            this.selectionWillBeRestored = b;
        }

        public int getLoadingPercentage() {
            return XicPeakPanel.this.m_dataBox.getLoadingPercentage();
        }

        public boolean isLoaded() {
            return XicPeakPanel.this.m_dataBox.isLoaded();
        }

        public Peak getSelectedPeak() {
            int selectedRow = this.getSelectedRow();
            if (selectedRow == -1) {
                return null;
            }
            CompoundTableModel compoundTableModel = (CompoundTableModel)this.getModel();
            if (compoundTableModel.getRowCount() == 0) {
                return null;
            }
            selectedRow = this.convertRowIndexToModel(selectedRow);
            selectedRow = compoundTableModel.convertCompoundRowToBaseModelRow(selectedRow);
            PeakTableModel tableModel = (PeakTableModel)compoundTableModel.getBaseModel();
            return tableModel.getPeak(selectedRow);
        }

        public String getExportColumnName(int col) {
            return ((CompoundTableModel)XicPeakPanel.this.m_peakTable.getModel()).getExportColumnName(this.convertColumnIndexToModel(col));
        }

        public String getExportRowCell(int row, int col) {
            return ((CompoundTableModel)XicPeakPanel.this.m_peakTable.getModel()).getExportRowCell(this.convertRowIndexToModel(row), this.convertColumnIndexToModel(col));
        }

        public ArrayList<ExportFontData> getExportFonts(int row, int col) {
            return ((CompoundTableModel)XicPeakPanel.this.m_peakTable.getModel()).getExportFonts(this.convertRowIndexToModel(row), this.convertColumnIndexToModel(col));
        }

        public TablePopupMenu initPopupMenu() {
            return null;
        }

        public void prepostPopupMenu() {
        }
    }
}

