/*
 * Decompiled with CFR 0.152.
 */
package com.github.mzdb4s.io.reader;

import com.github.mzdb4s.io.MzDbContext;
import com.github.sqlite4s.ISQLiteStatement;

public final class MzDbReaderQueries$ {
    public static final MzDbReaderQueries$ MODULE$;

    static {
        new MzDbReaderQueries$();
    }

    public String getModelVersion(MzDbContext mzDbCtx) {
        return mzDbCtx.newSQLiteQuery("SELECT version FROM mzdb LIMIT 1", mzDbCtx.newSQLiteQuery$default$2()).extractSingleString();
    }

    public String getPwizMzDbVersion(MzDbContext mzDbCtx) {
        return mzDbCtx.newSQLiteQuery("SELECT version FROM software WHERE name LIKE '%mzDB'", mzDbCtx.newSQLiteQuery$default$2()).extractSingleString();
    }

    public float getLastTime(MzDbContext mzDbCtx) {
        return (float)mzDbCtx.newSQLiteQuery("SELECT time FROM spectrum ORDER BY id DESC LIMIT 1", mzDbCtx.newSQLiteQuery$default$2()).extractSingleDouble();
    }

    public int getMaxMsLevel(MzDbContext mzDbCtx) {
        return mzDbCtx.newSQLiteQuery("SELECT max(ms_level) FROM run_slice", mzDbCtx.newSQLiteQuery$default$2()).extractSingleInt();
    }

    public int[] getMzRange(int msLevel, MzDbContext mzDbCtx) {
        ISQLiteStatement stmt = mzDbCtx.mzDbConnection().prepare("SELECT min(begin_mz), max(end_mz) FROM run_slice WHERE ms_level=?");
        stmt.bind(1, msLevel);
        stmt.step();
        int minMz = stmt.columnInt(0);
        int maxMz = stmt.columnInt(1);
        stmt.dispose();
        int[] mzRange = new int[]{minMz, maxMz};
        return mzRange;
    }

    public int getBoundingBoxesCount(MzDbContext mzDbCtx) {
        return this.getTableRecordsCount("bounding_box", mzDbCtx);
    }

    public int getBoundingBoxesCount(int runSliceId, MzDbContext mzDbCtx) {
        String sqlString = "SELECT count(*) FROM bounding_box WHERE bounding_box.run_slice_id = ?";
        return mzDbCtx.newSQLiteQuery(sqlString, mzDbCtx.newSQLiteQuery$default$2()).bind(1, runSliceId).extractSingleInt();
    }

    public int getCyclesCount(MzDbContext mzDbCtx) {
        String sqlString = "SELECT max(cycle) FROM spectrum";
        return mzDbCtx.newSQLiteQuery(sqlString, mzDbCtx.newSQLiteQuery$default$2()).extractSingleInt();
    }

    public int getDataEncodingsCount(MzDbContext mzDbCtx) {
        return this.getTableRecordsCount("data_encoding", mzDbCtx);
    }

    public int getSpectraCount(MzDbContext mzDbCtx) {
        return this.getTableRecordsCount("spectrum", mzDbCtx);
    }

    public int getSpectraCount(int msLevel, MzDbContext mzDbCtx) {
        String sqlString = "SELECT count(*) FROM spectrum WHERE ms_level = ?";
        return mzDbCtx.newSQLiteQuery(sqlString, mzDbCtx.newSQLiteQuery$default$2()).bind(1, msLevel).extractSingleInt();
    }

    public int getRunSlicesCount(MzDbContext mzDbCtx) {
        return this.getTableRecordsCount("run_slice", mzDbCtx);
    }

    public int getTableRecordsCount(String tableName, MzDbContext mzDbCtx) {
        return mzDbCtx.newSQLiteQuery("SELECT seq FROM sqlite_sequence WHERE name = ?", mzDbCtx.newSQLiteQuery$default$2()).bind(1, tableName).extractSingleInt();
    }

    public byte[] getBoundingBoxData(int bbId, MzDbContext mzDbCtx) {
        String sqlString = "SELECT data FROM bounding_box WHERE bounding_box.id = ?";
        return mzDbCtx.newSQLiteQuery(sqlString, mzDbCtx.newSQLiteQuery$default$2()).bind(1, bbId).extractSingleBlob();
    }

    public long getBoundingBoxFirstSpectrumId(long spectrumId, MzDbContext mzDbCtx) {
        String sqlString = "SELECT bb_first_spectrum_id FROM spectrum WHERE id = ?";
        return mzDbCtx.newSQLiteQuery(sqlString, mzDbCtx.newSQLiteQuery$default$2()).bind(1, spectrumId).extractSingleLong();
    }

    public float getBoundingBoxMinMz(int bbId, MzDbContext mzDbCtx) {
        String sqlString = "SELECT min_mz FROM bounding_box_rtree WHERE bounding_box_rtree.id = ?";
        return (float)mzDbCtx.newSQLiteQuery(sqlString, mzDbCtx.newSQLiteQuery$default$2()).bind(1, bbId).extractSingleDouble();
    }

    public float getBoundingBoxMinTime(int bbId, MzDbContext mzDbCtx) {
        String sqlString = "SELECT min_time FROM bounding_box_rtree WHERE bounding_box_rtree.id = ?";
        return (float)mzDbCtx.newSQLiteQuery(sqlString, mzDbCtx.newSQLiteQuery$default$2()).bind(1, bbId).extractSingleDouble();
    }

    public int getBoundingBoxMsLevel(int bbId, MzDbContext mzDbCtx) {
        String sqlString1 = "SELECT run_slice_id FROM bounding_box WHERE id = ?";
        int runSliceId = mzDbCtx.newSQLiteQuery(sqlString1, mzDbCtx.newSQLiteQuery$default$2()).bind(1, bbId).extractSingleInt();
        String sqlString2 = "SELECT ms_level FROM run_slice WHERE run_slice.id = ?";
        return mzDbCtx.newSQLiteQuery(sqlString2, mzDbCtx.newSQLiteQuery$default$2()).bind(1, runSliceId).extractSingleInt();
    }

    private MzDbReaderQueries$() {
        MODULE$ = this;
    }
}

