/*
 * Decompiled with CFR 0.152.
 */
package com.github.mzdb4s.io.reader.bb;

import com.github.mzdb4s.io.reader.bb.AbstractBlobReader;
import com.github.mzdb4s.msdata.DataEncoding;
import com.github.mzdb4s.msdata.SpectrumData;
import com.github.mzdb4s.msdata.SpectrumHeader;
import com.github.mzdb4s.msdata.SpectrumSlice;
import java.nio.ByteBuffer;
import java.util.Arrays;
import scala.collection.mutable.LongMap;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005=c\u0001B\u0001\u0003\u0001=\u00111BQ=uKN\u0014V-\u00193fe*\u00111\u0001B\u0001\u0003E\nT!!\u0002\u0004\u0002\rI,\u0017\rZ3s\u0015\t9\u0001\"\u0001\u0002j_*\u0011\u0011BC\u0001\u0007[j$'\rN:\u000b\u0005-a\u0011AB4ji\",(MC\u0001\u000e\u0003\r\u0019w.\\\u0002\u0001'\t\u0001\u0001\u0003\u0005\u0002\u0012%5\t!!\u0003\u0002\u0014\u0005\t\u0011\u0012IY:ue\u0006\u001cGO\u00117pEJ+\u0017\rZ3s\u0011!)\u0002A!b\u0001\n\u00131\u0012!\u00022zi\u0016\u001cX#A\f\u0011\u0007aYR$D\u0001\u001a\u0015\u0005Q\u0012!B:dC2\f\u0017B\u0001\u000f\u001a\u0005\u0015\t%O]1z!\tAb$\u0003\u0002 3\t!!)\u001f;f\u0011!\t\u0003A!A!\u0002\u00139\u0012A\u00022zi\u0016\u001c\b\u0005\u0003\u0005$\u0001\t\u0015\r\u0011\"\u0001%\u0003=1\u0017N]:u'B,7\r\u001e:v[&#W#A\u0013\u0011\u0005a1\u0013BA\u0014\u001a\u0005\u0011auN\\4\t\u0011%\u0002!\u0011!Q\u0001\n\u0015\n\u0001CZ5sgR\u001c\u0006/Z2ueVl\u0017\n\u001a\u0011\t\u0011-\u0002!Q1A\u0005\u0002\u0011\na\u0002\\1tiN\u0003Xm\u0019;sk6LE\r\u0003\u0005.\u0001\t\u0005\t\u0015!\u0003&\u0003=a\u0017m\u001d;Ta\u0016\u001cGO];n\u0013\u0012\u0004\u0003\u0002C\u0018\u0001\u0005\u000b\u0007I\u0011\u0001\u0019\u0002%M\u0004Xm\u0019;sk6DU-\u00193fe\nK\u0018\nZ\u000b\u0002cA\u0019!gN\u001d\u000e\u0003MR!\u0001N\u001b\u0002\u000f5,H/\u00192mK*\u0011a'G\u0001\u000bG>dG.Z2uS>t\u0017B\u0001\u001d4\u0005\u001dauN\\4NCB\u0004\"AO\u001f\u000e\u0003mR!\u0001\u0010\u0005\u0002\r5\u001cH-\u0019;b\u0013\tq4H\u0001\bTa\u0016\u001cGO];n\u0011\u0016\fG-\u001a:\t\u0011\u0001\u0003!\u0011!Q\u0001\nE\n1c\u001d9fGR\u0014X/\u001c%fC\u0012,'OQ=JI\u0002B\u0001B\u0011\u0001\u0003\u0006\u0004%\taQ\u0001\u0019I\u0006$\u0018-\u00128d_\u0012Lgn\u001a\"z'B,7\r\u001e:v[&#W#\u0001#\u0011\u0007I:T\t\u0005\u0002;\r&\u0011qi\u000f\u0002\r\t\u0006$\u0018-\u00128d_\u0012Lgn\u001a\u0005\t\u0013\u0002\u0011\t\u0011)A\u0005\t\u0006IB-\u0019;b\u000b:\u001cw\u000eZ5oO\nK8\u000b]3diJ,X.\u00133!\u0011\u0015Y\u0005\u0001\"\u0001M\u0003\u0019a\u0014N\\5u}Q1QJT(Q#J\u0003\"!\u0005\u0001\t\u000bUQ\u0005\u0019A\f\t\u000b\rR\u0005\u0019A\u0013\t\u000b-R\u0005\u0019A\u0013\t\u000b=R\u0005\u0019A\u0019\t\u000b\tS\u0005\u0019\u0001#\t\u000fQ\u0003!\u0019!C\u0005+\u0006\u0019rLZ5sgR$\u0015\r^1F]\u000e|g\u000eZ5oOV\tQ\t\u0003\u0004X\u0001\u0001\u0006I!R\u0001\u0015?\u001aL'o\u001d;ECR\fWI\\2p]\u0012Lgn\u001a\u0011\t\u000fe\u0003!\u0019!C\u00055\u0006iqL\u00192CsR,')\u001e4gKJ,\u0012a\u0017\t\u00039\u0006l\u0011!\u0018\u0006\u0003=~\u000b1A\\5p\u0015\u0005\u0001\u0017\u0001\u00026bm\u0006L!AY/\u0003\u0015\tKH/\u001a\"vM\u001a,'\u000f\u0003\u0004e\u0001\u0001\u0006IaW\u0001\u000f?\n\u0014')\u001f;f\u0005V4g-\u001a:!\u0011\u001d1\u0007A1A\u0005\n\u001d\f\u0011b\u00182m_\n\u001c\u0016N_3\u0016\u0003!\u0004\"\u0001G5\n\u0005)L\"aA%oi\"1A\u000e\u0001Q\u0001\n!\f!b\u00182m_\n\u001c\u0016N_3!\u0011\u0015q\u0007\u0001\"\u0005p\u0003Qy\u0016N\u001c3fqN\u0003Xm\u0019;sk6\u001cF.[2fgR\u0011\u0001o\u001d\t\u00031EL!A]\r\u0003\tUs\u0017\u000e\u001e\u0005\u0006i6\u0004\r\u0001[\u0001\u0016KN$\u0018.\\1uK\u0012\u001c\u0006/Z2ue\u0006\u001cu.\u001e8u\u0011\u00151\b\u0001\"\u0011x\u0003-!\u0017n\u001d9pg\u0016\u0014En\u001c2\u0015\u0003ADQ!\u001f\u0001\u0005\u0002i\f1bZ3u\u00052|'mU5{KR\t\u0001\u000eC\u0003}\u0001\u0011\u0005#0A\bhKR\u001c\u0006/Z2ue\u0006\u001cu.\u001e8u\u0011\u0015q\b\u0001\"\u0011\u0000\u0003=9W\r^*qK\u000e$(/^7JI\u0006#HcA\u0013\u0002\u0002!1\u00111A?A\u0002!\f1!\u001b3y\u0011\u001d\t9\u0001\u0001C\u0005\u0003\u0013\t\u0001cX4fiN\u0003Xm\u0019;sk6LE-\u0011;\u0015\u0007\u0015\nY\u0001C\u0004\u0002\u0004\u0005\u0015\u0001\u0019\u00015\t\u000f\u0005=\u0001\u0001\"\u0011\u0002\u0012\u0005\u0019\"/Z1e'B,7\r\u001e:v[Nc\u0017nY3BiR!\u00111CA\r!\rQ\u0014QC\u0005\u0004\u0003/Y$!D*qK\u000e$(/^7TY&\u001cW\rC\u0004\u0002\u0004\u00055\u0001\u0019\u00015\t\u000f\u0005u\u0001\u0001\"\u0011\u0002 \u00059\"/Z1e'B,7\r\u001e:v[Nc\u0017nY3ECR\f\u0017\t\u001e\u000b\u0005\u0003C\t9\u0003E\u0002;\u0003GI1!!\n<\u00051\u0019\u0006/Z2ueVlG)\u0019;b\u0011\u001d\t\u0019!a\u0007A\u0002!Dq!a\u000b\u0001\t\u0003\ni#A\u0010sK\u0006$g)\u001b7uKJ,Gm\u00159fGR\u0014X/\\*mS\u000e,G)\u0019;b\u0003R$\u0002\"!\t\u00020\u0005E\u00121\b\u0005\b\u0003\u0007\tI\u00031\u0001i\u0011!\t\u0019$!\u000bA\u0002\u0005U\u0012!B7j]6S\bc\u0001\r\u00028%\u0019\u0011\u0011H\r\u0003\r\u0011{WO\u00197f\u0011!\ti$!\u000bA\u0002\u0005U\u0012!B7bq6S\bbBA!\u0001\u0011%\u00111I\u0001!?J,\u0017\r\u001a$jYR,'/\u001a3Ta\u0016\u001cGO];n'2L7-\u001a#bi\u0006\fE\u000f\u0006\u0006\u0002\"\u0005\u0015\u0013qIA&\u0003\u001bBq!a\u0001\u0002@\u0001\u0007\u0001\u000eC\u0004\u0002J\u0005}\u0002\u0019A\u0013\u0002\u0015M\u0004Xm\u0019;sk6LE\r\u0003\u0005\u00024\u0005}\u0002\u0019AA\u001b\u0011!\ti$a\u0010A\u0002\u0005U\u0002")
public class BytesReader
extends AbstractBlobReader {
    private final byte[] bytes;
    private final long firstSpectrumId;
    private final long lastSpectrumId;
    private final LongMap<SpectrumHeader> spectrumHeaderById;
    private final LongMap<DataEncoding> dataEncodingBySpectrumId;
    private final DataEncoding _firstDataEnconding;
    private final ByteBuffer _bbByteBuffer;
    private final int _blobSize;

    private byte[] bytes() {
        return this.bytes;
    }

    @Override
    public long firstSpectrumId() {
        return this.firstSpectrumId;
    }

    @Override
    public long lastSpectrumId() {
        return this.lastSpectrumId;
    }

    @Override
    public LongMap<SpectrumHeader> spectrumHeaderById() {
        return this.spectrumHeaderById;
    }

    @Override
    public LongMap<DataEncoding> dataEncodingBySpectrumId() {
        return this.dataEncodingBySpectrumId;
    }

    private DataEncoding _firstDataEnconding() {
        return this._firstDataEnconding;
    }

    private ByteBuffer _bbByteBuffer() {
        return this._bbByteBuffer;
    }

    private int _blobSize() {
        return this._blobSize;
    }

    public void _indexSpectrumSlices(int estimatedSpectraCount) {
        int[] spectrumSliceStartPositions = new int[estimatedSpectraCount];
        int[] peaksCounts = new int[estimatedSpectraCount];
        int spectrumSliceIdx = 0;
        int byteIdx = 0;
        while (byteIdx < this._blobSize()) {
            int peaksCount;
            this._bbByteBuffer().position(byteIdx);
            long spectrumId = this._bbByteBuffer().getInt();
            spectrumSliceStartPositions[spectrumSliceIdx] = byteIdx;
            peaksCounts[spectrumSliceIdx] = peaksCount = this._bbByteBuffer().getInt();
            DataEncoding de = (DataEncoding)this.dataEncodingBySpectrumId().apply(spectrumId);
            this.checkDataEncodingIsNotNull(de, spectrumId);
            byteIdx += 8 + peaksCount * de.getPeakStructSize();
            ++spectrumSliceIdx;
        }
        this._spectraCount_$eq(spectrumSliceIdx);
        this._spectrumSliceStartPositions_$eq(Arrays.copyOf(spectrumSliceStartPositions, this._spectraCount()));
        this._peaksCounts_$eq(Arrays.copyOf(peaksCounts, this._spectraCount()));
    }

    @Override
    public void disposeBlob() {
    }

    public int getBlobSize() {
        return this._blobSize();
    }

    @Override
    public int getSpectraCount() {
        return this._spectraCount();
    }

    @Override
    public long getSpectrumIdAt(int idx) {
        this.checkSpectrumIndexRange(idx);
        return this._getSpectrumIdAt(idx);
    }

    private long _getSpectrumIdAt(int idx) {
        return this._bbByteBuffer().getInt(this._spectrumSliceStartPositions()[idx]);
    }

    @Override
    public SpectrumSlice readSpectrumSliceAt(int idx) {
        long spectrumId = this._getSpectrumIdAt(idx);
        SpectrumData spectrumSliceData = this._readFilteredSpectrumSliceDataAt(idx, spectrumId, -1.0, -1.0);
        SpectrumHeader sh = (SpectrumHeader)this.spectrumHeaderById().apply(spectrumId);
        return new SpectrumSlice(sh, spectrumSliceData);
    }

    @Override
    public SpectrumData readSpectrumSliceDataAt(int idx) {
        return this._readFilteredSpectrumSliceDataAt(idx, this._getSpectrumIdAt(idx), -1.0, -1.0);
    }

    @Override
    public SpectrumData readFilteredSpectrumSliceDataAt(int idx, double minMz, double maxMz) {
        return this._readFilteredSpectrumSliceDataAt(idx, this._getSpectrumIdAt(idx), minMz, maxMz);
    }

    private SpectrumData _readFilteredSpectrumSliceDataAt(int idx, long spectrumId, double minMz, double maxMz) {
        DataEncoding de = (DataEncoding)this.dataEncodingBySpectrumId().apply(spectrumId);
        int peaksBytesSize = this._peaksCounts()[idx] * de.getPeakStructSize();
        int spectrumSliceStartPos = this._spectrumSliceStartPositions()[idx] + 8;
        return this.readSpectrumSliceData(this._bbByteBuffer(), spectrumSliceStartPos, peaksBytesSize, de, minMz, maxMz);
    }

    public BytesReader(byte[] bytes, long firstSpectrumId, long lastSpectrumId, LongMap<SpectrumHeader> spectrumHeaderById, LongMap<DataEncoding> dataEncodingBySpectrumId) {
        this.bytes = bytes;
        this.firstSpectrumId = firstSpectrumId;
        this.lastSpectrumId = lastSpectrumId;
        this.spectrumHeaderById = spectrumHeaderById;
        this.dataEncodingBySpectrumId = dataEncodingBySpectrumId;
        this._firstDataEnconding = (DataEncoding)dataEncodingBySpectrumId.valuesIterator().next();
        this._bbByteBuffer = ByteBuffer.wrap(bytes).order(this._firstDataEnconding().byteOrder());
        this._blobSize = bytes.length;
        this._indexSpectrumSlices((int)(1L + lastSpectrumId - firstSpectrumId));
    }
}

