/*
 * Decompiled with CFR 0.152.
 */
package com.github.mzdb4s.io.reader.bb2;

import com.github.mzdb4s.io.reader.bb2.BoundingBoxIndex;
import com.github.mzdb4s.io.reader.bb2.BoundingBoxIndexFactory;
import com.github.mzdb4s.io.reader.bb2.IBoundingBoxReader;
import com.github.mzdb4s.msdata.DataEncoding;
import com.github.mzdb4s.msdata.DataMode$;
import com.github.mzdb4s.msdata.PeakEncoding$;
import com.github.mzdb4s.msdata.SpectrumHeader;
import com.github.mzdb4s.msdata.SpectrumSlice;
import com.github.mzdb4s.msdata.builder.ISpectrumDataAdder;
import com.github.mzdb4s.msdata.builder.SpectrumDataBuilderFactory;
import com.github.mzdb4s.msdata.builder.SpectrumSliceBuilder;
import java.nio.ByteBuffer;
import scala.Enumeration;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.LongMap;
import scala.collection.mutable.WrappedArray;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005}e!B\u0001\u0003\u0003\u0003y!!G!cgR\u0014\u0018m\u0019;C_VtG-\u001b8h\u0005>D(+Z1eKJT!a\u0001\u0003\u0002\u0007\t\u0014'G\u0003\u0002\u0006\r\u00051!/Z1eKJT!a\u0002\u0005\u0002\u0005%|'BA\u0005\u000b\u0003\u0019i'\u0010\u001a25g*\u00111\u0002D\u0001\u0007O&$\b.\u001e2\u000b\u00035\t1aY8n\u0007\u0001\u00192\u0001\u0001\t\u0017!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005\u0019\te.\u001f*fMB\u0011q\u0003G\u0007\u0002\u0005%\u0011\u0011D\u0001\u0002\u0013\u0013\n{WO\u001c3j]\u001e\u0014u\u000e\u001f*fC\u0012,'\u000fC\u0003\u001c\u0001\u0011\u0005A$\u0001\u0004=S:LGO\u0010\u000b\u0002;A\u0011q\u0003\u0001\u0005\u0006?\u00011\u0019\u0002I\u0001\rE\nLE\r\u001f$bGR|'/_\u000b\u0002CA\u0011qCI\u0005\u0003G\t\u0011qCQ8v]\u0012Lgn\u001a\"pq&sG-\u001a=GC\u000e$xN]=\t\u000b\u0015\u0002a\u0011\u0001\u0014\u0002%M\u0004Xm\u0019;sk6DU-\u00193fe\nK\u0018\nZ\u000b\u0002OA\u0019\u0001&L\u0018\u000e\u0003%R!AK\u0016\u0002\u000f5,H/\u00192mK*\u0011AFE\u0001\u000bG>dG.Z2uS>t\u0017B\u0001\u0018*\u0005\u001dauN\\4NCB\u0004\"\u0001M\u001a\u000e\u0003ER!A\r\u0005\u0002\r5\u001cH-\u0019;b\u0013\t!\u0014G\u0001\bTa\u0016\u001cGO];n\u0011\u0016\fG-\u001a:\t\u000bY\u0002a\u0011A\u001c\u00021\u0011\fG/Y#oG>$\u0017N\\4CsN\u0003Xm\u0019;sk6LE-F\u00019!\rAS&\u000f\t\u0003aiJ!aO\u0019\u0003\u0019\u0011\u000bG/Y#oG>$\u0017N\\4\t\u000fu\u0002!\u0019!D\t}\u0005AqL\u00192J]\u0012,\u00070F\u0001@!\t9\u0002)\u0003\u0002B\u0005\t\u0001\"i\\;oI&twMQ8y\u0013:$W\r\u001f\u0005\u0006\u0007\u0002!\t\u0005R\u0001\bI&\u001c\bo\\:f)\u0005)\u0005CA\tG\u0013\t9%C\u0001\u0003V]&$\b\"B%\u0001\t\u0003R\u0015aD4fiB+\u0017m[:D_VtG/\u0011;\u0015\u0005-s\u0005CA\tM\u0013\ti%CA\u0002J]RDQa\u0014%A\u0002-\u000b1!\u001b3y\u0011\u0015\t\u0006\u0001\"\u0011S\u0003A9W\r^!mYN\u0003Xm\u0019;sC&#7\u000f\u0006\u0002F'\")A\u000b\u0015a\u0001+\u0006Q1\u000f]3diJ\f\u0017\nZ:\u0011\u0007!2\u0006,\u0003\u0002XS\taqK]1qa\u0016$\u0017I\u001d:bsB\u0011\u0011#W\u0005\u00035J\u0011A\u0001T8oO\")A\f\u0001C\t;\u0006)\"/Z1e'B,7\r\u001e:v[Nc\u0017nY3ECR\fG\u0003C#_MB\u0014HO^>\t\u000b}[\u0006\u0019\u00011\u0002#M\u0004Xm\u0019;sk6$\u0015\r^1BI\u0012,'\u000f\u0005\u0002bI6\t!M\u0003\u0002dc\u00059!-^5mI\u0016\u0014\u0018BA3c\u0005II5\u000b]3diJ,X\u000eR1uC\u0006#G-\u001a:\t\u000b\u001d\\\u0006\u0019\u00015\u0002\u0019\t\u0014')\u001f;f\u0005V4g-\u001a:\u0011\u0005%tW\"\u00016\u000b\u0005-d\u0017a\u00018j_*\tQ.\u0001\u0003kCZ\f\u0017BA8k\u0005)\u0011\u0015\u0010^3Ck\u001a4WM\u001d\u0005\u0006cn\u0003\raS\u0001\u0016gB,7\r\u001e:v[Nc\u0017nY3Ti\u0006\u0014H\u000fU8t\u0011\u0015\u00198\f1\u0001L\u0003A\u0001X-Y6t\u0005f$Xm\u001d'f]\u001e$\b\u000eC\u0003v7\u0002\u0007\u0011(\u0001\u0002eK\")qo\u0017a\u0001q\u0006)Q.\u001b8NuB\u0011\u0011#_\u0005\u0003uJ\u0011a\u0001R8vE2,\u0007\"\u0002?\\\u0001\u0004A\u0018!B7bq6S\b\"\u0002@\u0001\t\u0003z\u0018a\u0005:fC\u0012\u001c\u0006/Z2ueVl7\u000b\\5dK\u0006#H\u0003BA\u0001\u0003'!B!a\u0001\u0002\nA\u0019\u0001'!\u0002\n\u0007\u0005\u001d\u0011GA\u0007Ta\u0016\u001cGO];n'2L7-\u001a\u0005\b\u0003\u0017i\b9AA\u0007\u0003)\u0019HM\u0019$bGR|'/\u001f\t\u0004C\u0006=\u0011bAA\tE\nQ2\u000b]3diJ,X\u000eR1uC\n+\u0018\u000e\u001c3fe\u001a\u000b7\r^8ss\")q* a\u0001\u0017\"9\u0011q\u0003\u0001\u0005B\u0005e\u0011!\u0007:fC\u0012\fE\u000e\\*qK\u000e$(/^7TY&\u001cWm\u001d#bi\u0006$2!RA\u000e\u0011!\ti\"!\u0006A\u0002\u0005}\u0011\u0001\u00032vS2$WM]:\u0011\u000b\u0005\u0005\u0012\u0011\u00071\u000f\t\u0005\r\u0012Q\u0006\b\u0005\u0003K\tY#\u0004\u0002\u0002()\u0019\u0011\u0011\u0006\b\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0019\u0012bAA\u0018%\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u001a\u0003k\u00111aU3r\u0015\r\tyC\u0005\u0005\b\u0003s\u0001A\u0011IA\u001e\u0003U\u0011X-\u00193BY2\u001c\u0006/Z2ueVl7\u000b\\5dKN$B!!\u0010\u0002BQ\u0019Q)a\u0010\t\u0011\u0005-\u0011q\u0007a\u0002\u0003\u001bA\u0001\"a\u0011\u00028\u0001\u0007\u0011QI\u0001\u0007EV4g-\u001a:\u0011\u000b!\n9%a\u0001\n\u0007\u0005%\u0013F\u0001\u0004Ck\u001a4WM\u001d\u0005\b\u0003\u001b\u0002A\u0011CA(\u0003]\u0019\u0007.Z2l'B,7\r\u001e:v[&sG-\u001a=SC:<W\rF\u0002F\u0003#BaaTA&\u0001\u0004Y\u0005FBA&\u0003+\n\t\u0007E\u0003\u0012\u0003/\nY&C\u0002\u0002ZI\u0011a\u0001\u001e5s_^\u001c\b\u0003BA\u0011\u0003;JA!a\u0018\u00026\tI\u0012J\u001c3fq>+Ho\u00144C_VtGm]#yG\u0016\u0004H/[8oc\u001dq\u00121MA9\u0003;\u0003B!!\u001a\u0002l9\u0019\u0011#a\u001a\n\u0007\u0005%$#\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003[\nyG\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003S\u0012\u0012'C\u0012\u0002t\u0005m\u00141SA?+\u0011\t)(a\u001e\u0016\u0005\u0005\rDaBA=\u001d\t\u0007\u00111\u0011\u0002\u0002)&!\u0011QPA@\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%c)\u0019\u0011\u0011\u0011\n\u0002\rQD'o\\<t#\u0011\t))a#\u0011\u0007E\t9)C\u0002\u0002\nJ\u0011qAT8uQ&tw\r\u0005\u0003\u0002\u000e\u0006=ebA\t\u0002.%!\u0011\u0011SA\u001b\u0005%!\u0006N]8xC\ndW-M\u0005$\u0003+\u000b9*!'\u0002\u0002:\u0019\u0011#a&\n\u0007\u0005\u0005%#M\u0003##I\tYJA\u0003tG\u0006d\u0017-M\u0002'\u00037\u0002")
public abstract class AbstractBoundingBoxReader
implements IBoundingBoxReader {
    public abstract BoundingBoxIndexFactory bbIdxFactory();

    public abstract LongMap<SpectrumHeader> spectrumHeaderById();

    public abstract LongMap<DataEncoding> dataEncodingBySpectrumId();

    public abstract BoundingBoxIndex _bbIndex();

    @Override
    public void dispose() {
        this.bbIdxFactory().releaseIndex(this._bbIndex());
    }

    @Override
    public int getPeaksCountAt(int idx) {
        this.checkSpectrumIndexRange(idx);
        return BoxesRunTime.unboxToInt((Object)this._bbIndex().peaksCounts().apply(idx));
    }

    @Override
    public void getAllSpectraIds(WrappedArray<Object> spectraIds) {
        int spectraCount = this.getSpectraCount();
        Predef$.MODULE$.require(spectraIds.length() == spectraCount, (Function0)new Serializable(this, spectraIds, spectraCount){
            public static final long serialVersionUID = 0L;
            private final WrappedArray spectraIds$1;
            private final int spectraCount$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invalid spectraIds.length, expected ", " ids but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.spectraCount$1), BoxesRunTime.boxToInteger((int)this.spectraIds$1.length())}));
            }
            {
                this.spectraIds$1 = spectraIds$1;
                this.spectraCount$1 = spectraCount$1;
            }
        });
        for (int i = 0; i < spectraCount; ++i) {
            spectraIds.update(i, (Object)BoxesRunTime.boxToLong((long)this.getSpectrumIdAt(i)));
        }
    }

    public void readSpectrumSliceData(ISpectrumDataAdder spectrumDataAdder, ByteBuffer bbByteBuffer, int spectrumSliceStartPos, int peaksBytesLength, DataEncoding de, double minMz, double maxMz) {
        int peaksStartIdx;
        int peaksCount;
        Enumeration.Value pe;
        Enumeration.Value dataMode;
        block10: {
            int structSize;
            block9: {
                dataMode = de.getMode();
                pe = de.getPeakEncoding();
                structSize = de.getPeakStructSize();
                peaksCount = 0;
                peaksStartIdx = 0;
                if (!(minMz < 0.0) || !(maxMz < 0.0)) break block9;
                peaksCount = peaksBytesLength / structSize;
                peaksStartIdx = spectrumSliceStartPos;
                break block10;
            }
            double maxMzThreshold = maxMz;
            if (maxMz < 0.0) {
                maxMzThreshold = Double.MAX_VALUE;
            }
            for (int i = 0; i < peaksBytesLength; i += structSize) {
                Enumeration.Value value;
                block14: {
                    double d;
                    int peakStartPos;
                    block12: {
                        block13: {
                            block11: {
                                peakStartPos = spectrumSliceStartPos + i;
                                value = pe;
                                Enumeration.Value value2 = PeakEncoding$.MODULE$.HIGH_RES_PEAK();
                                Enumeration.Value value3 = value;
                                if (value2 != null ? !value2.equals(value3) : value3 != null) break block11;
                                d = bbByteBuffer.getDouble(peakStartPos);
                                break block12;
                            }
                            Enumeration.Value value4 = PeakEncoding$.MODULE$.LOW_RES_PEAK();
                            Enumeration.Value value5 = value;
                            if (value4 != null ? !value4.equals(value5) : value5 != null) break block13;
                            d = bbByteBuffer.getFloat(peakStartPos);
                            break block12;
                        }
                        Enumeration.Value value6 = PeakEncoding$.MODULE$.NO_LOSS_PEAK();
                        Enumeration.Value value7 = value;
                        if (value6 != null ? !value6.equals(value7) : value7 != null) break block14;
                        d = bbByteBuffer.getDouble(peakStartPos);
                    }
                    double mz = d;
                    if (!(mz >= minMz) || !(mz <= maxMzThreshold)) continue;
                    ++peaksCount;
                    if (!(mz >= minMz) || peaksStartIdx != 0) continue;
                    peaksStartIdx = peakStartPos;
                    continue;
                }
                throw new MatchError((Object)value);
            }
        }
        bbByteBuffer.position(peaksStartIdx);
        for (int peakIdx = 0; peakIdx < peaksCount; ++peakIdx) {
            Enumeration.Value value;
            block18: {
                float intensity;
                double mz;
                block16: {
                    BoxedUnit boxedUnit;
                    block17: {
                        block15: {
                            mz = 0.0;
                            intensity = 0.0f;
                            value = pe;
                            Enumeration.Value value8 = PeakEncoding$.MODULE$.HIGH_RES_PEAK();
                            Enumeration.Value value9 = value;
                            if (value8 != null ? !value8.equals(value9) : value9 != null) break block15;
                            mz = bbByteBuffer.getDouble();
                            intensity = bbByteBuffer.getFloat();
                            boxedUnit = BoxedUnit.UNIT;
                            break block16;
                        }
                        Enumeration.Value value10 = PeakEncoding$.MODULE$.LOW_RES_PEAK();
                        Enumeration.Value value11 = value;
                        if (value10 != null ? !value10.equals(value11) : value11 != null) break block17;
                        mz = bbByteBuffer.getFloat();
                        intensity = bbByteBuffer.getFloat();
                        boxedUnit = BoxedUnit.UNIT;
                        break block16;
                    }
                    Enumeration.Value value12 = PeakEncoding$.MODULE$.NO_LOSS_PEAK();
                    Enumeration.Value value13 = value;
                    if (value12 != null ? !value12.equals(value13) : value13 != null) break block18;
                    mz = bbByteBuffer.getDouble();
                    intensity = (float)bbByteBuffer.getDouble();
                    boxedUnit = BoxedUnit.UNIT;
                }
                Enumeration.Value value14 = dataMode;
                Enumeration.Value value15 = DataMode$.MODULE$.FITTED();
                ISpectrumDataAdder iSpectrumDataAdder = !(value14 != null ? !value14.equals(value15) : value15 != null) ? spectrumDataAdder.addDataPoint(mz, intensity, bbByteBuffer.getFloat(), bbByteBuffer.getFloat()) : spectrumDataAdder.addDataPoint(mz, intensity);
                continue;
            }
            throw new MatchError((Object)value);
        }
    }

    @Override
    public SpectrumSlice readSpectrumSliceAt(int idx, SpectrumDataBuilderFactory sdbFactory) {
        SpectrumHeader spectrumHeader = (SpectrumHeader)this.spectrumHeaderById().apply(this.getSpectrumIdAt(idx));
        int slicePeaksCount = this.getPeaksCountAt(idx);
        SpectrumSliceBuilder sSliceBuilder = new SpectrumSliceBuilder(spectrumHeader, this.runSliceId(), slicePeaksCount, sdbFactory);
        this.readFilteredSpectrumSliceDataAt(idx, -1.0, -1.0, sSliceBuilder);
        return sSliceBuilder.result();
    }

    @Override
    public void readAllSpectrumSlicesData(Seq<ISpectrumDataAdder> builders) {
        int spectraCount = this.getSpectraCount();
        Predef$.MODULE$.assert(builders.length() == spectraCount, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "the number of builders must match the number of spectra";
            }
        });
        for (int i = 0; i < spectraCount; ++i) {
            this.readSpectrumSliceDataAt(i, (ISpectrumDataAdder)builders.apply(i));
        }
    }

    @Override
    public void readAllSpectrumSlices(Buffer<SpectrumSlice> buffer, SpectrumDataBuilderFactory sdbFactory) {
        int spectraCount = this.getSpectraCount();
        for (int i = 0; i < spectraCount; ++i) {
            buffer.$plus$eq((Object)this.readSpectrumSliceAt(i, sdbFactory));
        }
    }

    public void checkSpectrumIndexRange(int idx) throws IndexOutOfBoundsException {
        if (idx < 0 || idx >= this.getSpectraCount()) {
            throw new IndexOutOfBoundsException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spectrum index out of bounds (idx=", "), index counting starts at 0"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)idx)})));
        }
    }

    public AbstractBoundingBoxReader() {
        Predef$.MODULE$.require(this.firstSpectrumId() <= this.lastSpectrumId(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "lastSpectrumId must be greater or the same than firstSpectrumId";
            }
        });
    }
}

