/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.module.seq.config;

import fr.proline.module.seq.config.SeqRepoConfig;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParsingRuleEntry {
    private String name;
    private List<String> fastaNameRegExs;
    private String fastaReleaseRegEx;
    private String proteinAccRegEx;
    private static final Logger LOG = LoggerFactory.getLogger(ParsingRuleEntry.class);

    public ParsingRuleEntry(String name, List<String> fastaNameRegExs, String fastaReleaseRegEx, String proteinAccRegEx) {
        this.name = name;
        this.fastaNameRegExs = fastaNameRegExs;
        this.fastaReleaseRegEx = fastaReleaseRegEx;
        this.proteinAccRegEx = proteinAccRegEx;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getFastaNameRegExs() {
        return this.fastaNameRegExs;
    }

    public void setFastaNameRegExs(List<String> fastaNameRegExs) {
        this.fastaNameRegExs = fastaNameRegExs;
    }

    public String getFastaReleaseRegEx() {
        return this.fastaReleaseRegEx;
    }

    public void setFastaReleaseRegEx(String fastaReleaseRegEx) {
        this.fastaReleaseRegEx = fastaReleaseRegEx;
    }

    public String getProteinAccRegEx() {
        return this.proteinAccRegEx;
    }

    public void setProteinAccRegEx(String proteinAccRegEx) {
        this.proteinAccRegEx = proteinAccRegEx;
    }

    public static synchronized ParsingRuleEntry getParsingRuleEntry(String fastaFileName) {
        assert (fastaFileName != null) : "getParsingRuleEntry() fastaFileName is null";
        ParsingRuleEntry result = null;
        for (ParsingRuleEntry nextPR : SeqRepoConfig.getInstance().getParsingRules()) {
            for (String fastaRegEx : nextPR.getFastaNameRegExs()) {
                Pattern pattern = Pattern.compile(fastaRegEx, 2);
                Matcher matcher = pattern.matcher(fastaFileName);
                if (!matcher.find()) continue;
                LOG.debug("[{}] matches Fasta Name Regex \"{}\"", (Object)fastaFileName, (Object)fastaRegEx);
                result = nextPR;
                break;
            }
            if (result == null) continue;
            break;
        }
        return result;
    }
}

