/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.toolsuite.ols.dialog.task;

import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingWorker;
import net.jcip.annotations.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.pride.toolsuite.ols.dialog.OLSDialog;
import uk.ac.ebi.pride.toolsuite.ols.dialog.task.TaskEvent;
import uk.ac.ebi.pride.toolsuite.ols.dialog.task.TaskListener;
import uk.ac.ebi.pride.utilities.ols.web.service.client.OLSClient;

public abstract class AbstractTask<T, R>
extends SwingWorker<T, R> {
    protected OLSDialog olsDialog;
    protected OLSClient olsClient;
    protected String nameTask;
    public static final String COMPLETED_PROP = "completed";
    public static Logger logger = LoggerFactory.getLogger(AbstractTask.class);
    @GuardedBy(value="ownersLock")
    private final Collection<Object> owners;
    private final Object taskListenersLock = new Object();
    @GuardedBy(value="taskListenersLock")
    private final Collection<TaskListener<T, R>> taskListeners;

    public AbstractTask(String nameTask, OLSDialog olsDialog, OLSClient olsClient) {
        this.olsDialog = olsDialog;
        this.olsClient = olsClient;
        this.nameTask = nameTask;
        this.taskListeners = Collections.synchronizedList(new ArrayList());
        this.addPropertyChangeListener(new TaskStateMonitor());
        this.owners = Collections.synchronizedList(new ArrayList());
    }

    public String getNameTask() {
        return this.nameTask;
    }

    public void setNameTask(String nameTask) {
        this.nameTask = nameTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTaskListener(TaskListener<T, R> listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Null Task Listener");
        }
        Object object = this.taskListenersLock;
        synchronized (object) {
            this.taskListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTaskListener(TaskListener<T, R> listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Null Task Listener");
        }
        Object object = this.taskListenersLock;
        synchronized (object) {
            this.taskListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasTaskListener(TaskListener<T, R> listener) {
        Object object = this.taskListenersLock;
        synchronized (object) {
            return this.taskListeners.contains(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<TaskListener<T, R>> getTaskListeners() {
        Object object = this.taskListenersLock;
        synchronized (object) {
            return new ArrayList<TaskListener<T, R>>(this.taskListeners);
        }
    }

    public synchronized boolean hasPropertyChangeListener(PropertyChangeListener listener) {
        for (PropertyChangeListener propertyChangeListener : this.getPropertyChangeSupport().getPropertyChangeListeners()) {
            if (!propertyChangeListener.equals(listener)) continue;
            return true;
        }
        return false;
    }

    public final boolean isPending() {
        return this.getState() == SwingWorker.StateValue.PENDING;
    }

    public final boolean isStarted() {
        return this.getState() == SwingWorker.StateValue.STARTED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireStartedListeners() {
        TaskEvent<Object> event = new TaskEvent<Object>(this, null);
        Object object = this.taskListenersLock;
        synchronized (object) {
            for (TaskListener<T, R> listener : this.taskListeners) {
                listener.started(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireProcessListeners(List<R> values) {
        TaskEvent event = new TaskEvent(this, values);
        Object object = this.taskListenersLock;
        synchronized (object) {
            for (TaskListener<T, R> listener : this.taskListeners) {
                listener.process(event);
            }
        }
    }

    protected abstract void cancelled();

    protected abstract void succeed(T var1);

    protected abstract void finished();

    protected abstract void interrupted(InterruptedException var1);

    private void fireCompletionListeners() {
        try {
            if (this.isCancelled()) {
                this.fireCancelledListeners();
            } else {
                this.fireSucceedListeners(this.get());
            }
        }
        catch (InterruptedException iex) {
            this.fireInterruptedListeners(iex);
        }
        catch (ExecutionException eex) {
            this.fireFailedListeners(eex.getCause());
        }
        finally {
            this.fireFinishedListeners();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireCancelledListeners() {
        TaskEvent<Object> event = new TaskEvent<Object>(this, null);
        Object object = this.taskListenersLock;
        synchronized (object) {
            for (TaskListener<T, R> listener : this.taskListeners) {
                listener.cancelled(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireInterruptedListeners(InterruptedException iex) {
        TaskEvent<InterruptedException> event = new TaskEvent<InterruptedException>(this, iex);
        Object object = this.taskListenersLock;
        synchronized (object) {
            for (TaskListener<T, R> listener : this.taskListeners) {
                listener.interrupted(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireSucceedListeners(T result) {
        TaskEvent<T> event = new TaskEvent<T>(this, result);
        Object object = this.taskListenersLock;
        synchronized (object) {
            for (TaskListener<T, R> listener : this.taskListeners) {
                listener.succeed(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireFailedListeners(Throwable error) {
        TaskEvent<Throwable> event = new TaskEvent<Throwable>(this, error);
        Object object = this.taskListenersLock;
        synchronized (object) {
            for (TaskListener<T, R> listener : this.taskListeners) {
                listener.failed(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireFinishedListeners() {
        TaskEvent<Object> event = new TaskEvent<Object>(this, null);
        Object object = this.taskListenersLock;
        synchronized (object) {
            for (TaskListener<T, R> listener : this.taskListeners) {
                listener.finished(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireProgressListeners(int progress) {
        TaskEvent<Integer> event = new TaskEvent<Integer>(this, progress);
        Object object = this.taskListenersLock;
        synchronized (object) {
            for (TaskListener<T, R> listener : this.taskListeners) {
                listener.progress(event);
            }
        }
    }

    protected void failed(Throwable error) {
        String msg = String.format("%s failed on : %s", this, error);
        logger.error(msg, error);
    }

    private class TaskStateMonitor
    implements PropertyChangeListener {
        private TaskStateMonitor() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            if ("state".equals(propName)) {
                SwingWorker.StateValue state = (SwingWorker.StateValue)((Object)evt.getNewValue());
                switch (state) {
                    case STARTED: {
                        this.taskStarted();
                        break;
                    }
                    case DONE: {
                        this.taskDone();
                    }
                }
            } else if ("progress".equals(propName)) {
                AbstractTask.this.fireProgressListeners(AbstractTask.this.getProgress());
            }
        }

        private void taskStarted() {
            AbstractTask.this.fireStartedListeners();
        }

        private void taskDone() {
            EventQueue.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        if (AbstractTask.this.isCancelled()) {
                            AbstractTask.this.cancelled();
                        } else {
                            AbstractTask.this.succeed(AbstractTask.this.get());
                        }
                    }
                    catch (InterruptedException iex) {
                        AbstractTask.this.interrupted(iex);
                    }
                    catch (ExecutionException eex) {
                        AbstractTask.this.failed(eex.getCause());
                    }
                    finally {
                        AbstractTask.this.finished();
                        try {
                            AbstractTask.this.fireCompletionListeners();
                        }
                        finally {
                            AbstractTask.this.firePropertyChange(AbstractTask.COMPLETED_PROP, false, true);
                        }
                    }
                }
            });
        }
    }
}

