/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.toolsuite.ols.dialog.task.impl;

import java.util.List;
import java.util.Map;
import javax.swing.table.DefaultTableModel;
import uk.ac.ebi.pride.toolsuite.ols.dialog.OLSDialog;
import uk.ac.ebi.pride.toolsuite.ols.dialog.task.AbstractTask;
import uk.ac.ebi.pride.utilities.ols.web.service.client.OLSClient;
import uk.ac.ebi.pride.utilities.ols.web.service.model.ITerm;

public class GetMetadataTask
extends AbstractTask {
    private Integer searchType;
    private String ontologyName;
    private ITerm term;
    private static String TASK_NAME = "Get Metadata for Term";

    public GetMetadataTask(OLSDialog olsDialog, OLSClient olsClient) {
        super(TASK_NAME, olsDialog, olsClient);
    }

    public GetMetadataTask(OLSDialog olsDialog, OLSClient olsClient, ITerm term, String ontologyName, Integer searchType) {
        super(TASK_NAME, olsDialog, olsClient);
        this.ontologyName = ontologyName;
        this.term = term;
        this.searchType = searchType;
    }

    @Override
    protected void done() {
        if (this.searchType == OLSDialog.OLS_DIALOG_TERM_NAME_SEARCH) {
            this.olsDialog.insertSelectedJButton.setEnabled(this.olsDialog.currentlySelectedTermNameSearchAccessionNumber != null);
        } else if (this.searchType == OLSDialog.OLS_DIALOG_PSI_MOD_MASS_SEARCH) {
            this.olsDialog.insertSelectedJButton.setEnabled(this.olsDialog.currentlySelectedMassSearchAccessionNumber != null);
        } else if (this.searchType == OLSDialog.OLS_DIALOG_BROWSE_ONTOLOGY) {
            this.olsDialog.insertSelectedJButton.setEnabled(this.olsDialog.currentlySelectedBrowseOntologyAccessionNumber != null);
        } else if (this.searchType == OLSDialog.OLS_DIALOG_TERM_ID_SEARCH) {
            this.olsDialog.insertSelectedJButton.setEnabled(this.olsDialog.currentlySelectedTermIdSearchAccessionNumber != null);
        }
    }

    @Override
    protected Object doInBackground() throws Exception {
        block11: {
            Map annotations;
            block12: {
                List metadata = this.olsClient.getTermDescription(this.term.getGlobalId(), this.ontologyName);
                String label = this.term.getName();
                Map xRefs = this.olsClient.getTermXrefs(this.term.getGlobalId(), this.ontologyName);
                Map oboSynonyms = this.olsClient.getOBOSynonyms(this.term.getGlobalId(), this.ontologyName);
                annotations = this.olsClient.getAnnotations(this.term.getOboId(), this.ontologyName);
                String descriptionText = "";
                for (String aMetadata : metadata) {
                    descriptionText = descriptionText + aMetadata + "\n";
                }
                this.olsDialog.currentDefinitionsJTextPane.setText("Definition: " + descriptionText);
                this.olsDialog.currentDefinitionsJTextPane.setCaretPosition(0);
                if (this.olsDialog.currentDefinitionsJTextPane.getText().equalsIgnoreCase("null")) {
                    this.olsDialog.currentDefinitionsJTextPane.setText("(no definition provided in CV term)");
                }
                if (xRefs != null) {
                    for (String key : xRefs.keySet()) {
                        ((DefaultTableModel)this.olsDialog.currentTermDetailsJTable.getModel()).addRow(new Object[]{key, xRefs.get(key)});
                    }
                }
                if (oboSynonyms != null) {
                    for (String key : oboSynonyms.keySet()) {
                        ((DefaultTableModel)this.olsDialog.currentTermDetailsJTable.getModel()).addRow(new Object[]{"synonym:", key});
                    }
                }
                if (annotations == null) break block11;
                if (this.searchType == OLSDialog.OLS_DIALOG_TERM_NAME_SEARCH) break block12;
                if (this.searchType != OLSDialog.OLS_DIALOG_TERM_ID_SEARCH) break block11;
            }
            for (String key : annotations.keySet()) {
                for (String value : (List)annotations.get(key)) {
                    if (value == null || value.isEmpty()) continue;
                    ((DefaultTableModel)this.olsDialog.currentTermDetailsJTable.getModel()).addRow(new Object[]{key, value});
                }
            }
        }
        return null;
    }

    @Override
    protected void cancelled() {
        this.operationCancelorInterupted();
    }

    protected void succeed(Object results) {
    }

    @Override
    protected void finished() {
    }

    @Override
    protected void interrupted(InterruptedException iex) {
        this.operationCancelorInterupted();
    }

    private void operationCancelorInterupted() {
        if (this.searchType == OLSDialog.OLS_DIALOG_TERM_NAME_SEARCH) {
            this.olsDialog.currentlySelectedTermNameSearchAccessionNumber = null;
        } else if (this.searchType == OLSDialog.OLS_DIALOG_PSI_MOD_MASS_SEARCH) {
            this.olsDialog.currentlySelectedMassSearchAccessionNumber = null;
        } else if (this.searchType == OLSDialog.OLS_DIALOG_BROWSE_ONTOLOGY) {
            this.olsDialog.currentlySelectedBrowseOntologyAccessionNumber = null;
        } else if (this.searchType == OLSDialog.OLS_DIALOG_TERM_ID_SEARCH) {
            this.olsDialog.currentlySelectedTermIdSearchAccessionNumber = this.term;
        }
    }
}

