/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.toolsuite.ols.dialog.taskmanager;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import uk.ac.ebi.pride.toolsuite.ols.dialog.OLSDialog;
import uk.ac.ebi.pride.toolsuite.ols.dialog.task.AbstractTask;
import uk.ac.ebi.pride.toolsuite.ols.dialog.taskmanager.CollapsiblePane;
import uk.ac.ebi.pride.toolsuite.ols.dialog.taskmanager.TaskManager;
import uk.ac.ebi.pride.toolsuite.ols.dialog.taskmanager.TaskProgressBar;
import uk.ac.ebi.pride.toolsuite.ols.dialog.util.GUIUtils;

public class TaskDialog
extends JDialog
implements PropertyChangeListener {
    private static final String TASK_DIALOG_TITLE = "Background Tasks";
    private JPanel mainPane;
    private Map<AbstractTask, JPanel> taskPanelMap;
    private OLSDialog olsDialog;

    public TaskDialog(OLSDialog olsDialog) {
        super((Dialog)olsDialog, TASK_DIALOG_TITLE);
        this.olsDialog = olsDialog;
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(570, 400));
        this.mainPane = new JPanel();
        this.mainPane.setLayout(new BoxLayout(this.mainPane, 1));
        this.mainPane.setBackground(Color.white);
        this.mainPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JScrollPane scrollPane = new JScrollPane(this.mainPane, 20, 30);
        this.add((Component)scrollPane, "Center");
        this.taskPanelMap = new HashMap<AbstractTask, JPanel>();
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((d.width - this.getWidth()) / 2, (d.height - this.getHeight()) / 2);
        TaskManager taskMgr = olsDialog.getTaskManager();
        taskMgr.addPropertyChangeListener(this);
    }

    private JPanel createTaskPanel(AbstractTask task) {
        JPanel displayPane = new JPanel();
        displayPane.setOpaque(false);
        displayPane.setLayout(new BorderLayout());
        displayPane.setMaximumSize(new Dimension(520, 80));
        String title = this.getTaskPanelTitle(task);
        CollapsiblePane panel = new CollapsiblePane(title);
        JPanel progBarPanel = new JPanel();
        progBarPanel.setLayout(new FlowLayout(3));
        progBarPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        TaskProgressBar progBar = new TaskProgressBar(task);
        progBar.setPreferredSize(new Dimension(440, 20));
        progBarPanel.add(progBar);
        Icon icon = GUIUtils.loadIcon("icons/cancel.png");
        JButton closeButton = new JButton(icon);
        closeButton.addActionListener(new CloseTaskListener(task, this.olsDialog));
        progBarPanel.add(closeButton);
        panel.setContentComponent(progBarPanel);
        displayPane.add((Component)panel, "Center");
        return displayPane;
    }

    private String getTaskPanelTitle(AbstractTask task) {
        String title = task.getNameTask();
        return title;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String eventName = evt.getPropertyName();
        if ("add_new_task".equals(eventName)) {
            List newTasks = (List)evt.getNewValue();
            AbstractTask newTask = (AbstractTask)newTasks.get(newTasks.size() - 1);
            JPanel taskPanel = this.createTaskPanel(newTask);
            this.mainPane.add(taskPanel);
            this.mainPane.revalidate();
            this.mainPane.repaint();
            this.repaint();
            this.taskPanelMap.put(newTask, taskPanel);
        } else if ("remove_new_task".equals(eventName)) {
            List oldTasks = (List)evt.getOldValue();
            List newTasks = (List)evt.getNewValue();
            oldTasks.removeAll(newTasks);
            for (AbstractTask task : oldTasks) {
                JPanel taskPanel = this.taskPanelMap.get(task);
                if (taskPanel == null) continue;
                this.mainPane.remove(taskPanel);
                this.mainPane.revalidate();
                this.mainPane.repaint();
                this.taskPanelMap.remove(task);
            }
            this.repaint();
        }
    }

    private static class CloseTaskListener
    implements ActionListener {
        private AbstractTask task;
        private OLSDialog olsDialog;

        private CloseTaskListener(AbstractTask task, OLSDialog olsDialog) {
            this.task = task;
            this.olsDialog = olsDialog;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.olsDialog.cancelTask(this.task, true);
        }
    }
}

