/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.toolsuite.ols.dialog.taskmanager;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import uk.ac.ebi.pride.toolsuite.ols.dialog.prop.PropertyChangeHelper;
import uk.ac.ebi.pride.toolsuite.ols.dialog.task.AbstractTask;
import uk.ac.ebi.pride.toolsuite.ols.dialog.task.TaskListener;

@ThreadSafe
public class TaskManager
extends PropertyChangeHelper {
    public static final String ADD_TASK_PROP = "add_new_task";
    public static final String REMOVE_TASK_PROP = "remove_new_task";
    private final ExecutorService executor;
    private final Object tasksLock = new Object();
    @GuardedBy(value="tasksLock")
    private final List<AbstractTask> tasks;
    private final PropertyChangeListener taskPropListener;
    private final int numberOfThreads = 20;

    public TaskManager() {
        this.executor = new ThreadPoolExecutor(5, 20, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        this.tasks = new CopyOnWriteArrayList<AbstractTask>();
        this.taskPropListener = new TaskPropertyListener();
    }

    public void addTask(AbstractTask task) {
        this.addTask(task, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(AbstractTask task, boolean notify) {
        ArrayList<AbstractTask> newTasks;
        ArrayList<AbstractTask> oldTasks;
        Object object = this.tasksLock;
        synchronized (object) {
            oldTasks = new ArrayList<AbstractTask>(this.tasks);
            this.tasks.add(task);
            newTasks = new ArrayList<AbstractTask>(this.tasks);
            task.addPropertyChangeListener(this.taskPropListener);
        }
        if (notify) {
            this.firePropertyChange(ADD_TASK_PROP, oldTasks, newTasks);
        }
        this.executor.execute(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AbstractTask> getTasks(TaskListener listener) {
        ArrayList<AbstractTask> ts = new ArrayList<AbstractTask>();
        Object object = this.tasksLock;
        synchronized (object) {
            for (AbstractTask task : this.tasks) {
                if (!task.hasTaskListener(listener)) continue;
                ts.add(task);
            }
        }
        return ts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AbstractTask> getTasks(PropertyChangeListener listener) {
        ArrayList<AbstractTask> ts = new ArrayList<AbstractTask>();
        Object object = this.tasksLock;
        synchronized (object) {
            for (AbstractTask task : this.tasks) {
                if (!task.hasPropertyChangeListener(listener)) continue;
                ts.add(task);
            }
        }
        return ts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AbstractTask> getTasks(Class<? extends AbstractTask> taskClass) {
        ArrayList<AbstractTask> ts = new ArrayList<AbstractTask>();
        Object object = this.tasksLock;
        synchronized (object) {
            for (AbstractTask task : this.tasks) {
                if (!task.getClass().equals(taskClass)) continue;
                ts.add(task);
            }
        }
        return ts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasTask(AbstractTask task) {
        Object object = this.tasksLock;
        synchronized (object) {
            return this.tasks.contains(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTaskListener(TaskListener listener) {
        Object object = this.tasksLock;
        synchronized (object) {
            for (AbstractTask task : this.tasks) {
                task.removeTaskListener(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelTask(AbstractTask task, boolean interrupt) {
        boolean canceled = false;
        Object object = this.tasksLock;
        synchronized (object) {
            boolean hasTask = this.hasTask(task);
            if (hasTask) {
                ArrayList<AbstractTask> oldTasks = new ArrayList<AbstractTask>(this.tasks);
                this.tasks.remove(task);
                canceled = task.cancel(interrupt);
                ArrayList<AbstractTask> newTasks = new ArrayList<AbstractTask>(this.tasks);
                task.removePropertyChangeListener(this.taskPropListener);
                this.firePropertyChange(REMOVE_TASK_PROP, oldTasks, newTasks);
            }
        }
        return canceled;
    }

    public void shutdown() {
        this.executor.shutdown();
    }

    public void shutdownNow() {
        this.executor.shutdownNow();
    }

    private class TaskPropertyListener
    implements PropertyChangeListener {
        private TaskPropertyListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            if ("completed".equals(propName)) {
                ArrayList newTasks;
                ArrayList oldTasks;
                AbstractTask task = (AbstractTask)evt.getSource();
                Object object = TaskManager.this.tasksLock;
                synchronized (object) {
                    oldTasks = new ArrayList(TaskManager.this.tasks);
                    TaskManager.this.tasks.remove(task);
                    newTasks = new ArrayList(TaskManager.this.tasks);
                    task.removePropertyChangeListener(TaskManager.this.taskPropListener);
                }
                TaskManager.this.firePropertyChange(TaskManager.REMOVE_TASK_PROP, oldTasks, newTasks);
            }
        }
    }
}

