/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.toolsuite.ols.dialog.util;

import java.awt.Component;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GUIUtils {
    private static final Logger logger = LoggerFactory.getLogger(GUIUtils.class);
    private static Map<String, Icon> icons = Collections.synchronizedMap(new HashMap());

    public static Icon loadIcon(String iconName) {
        if (iconName == null) {
            return null;
        }
        Icon icon = icons.get(iconName = iconName.trim());
        if (icon != null) {
            return icon;
        }
        icon = new ImageIcon(GUIUtils.class.getClassLoader().getResource(iconName));
        icons.put(iconName, icon);
        return icon;
    }

    public static ImageIcon loadImageIcon(String iconName) {
        Icon icon = GUIUtils.loadIcon(iconName);
        return icon == null ? null : (ImageIcon)icon;
    }

    public static JButton createLabelLikeButton(Icon icon, String title) {
        JButton button = new JButton(title, icon);
        button.setBorderPainted(false);
        button.setContentAreaFilled(false);
        button.setFocusable(false);
        button.setOpaque(false);
        button.setHorizontalAlignment(2);
        return button;
    }

    public static JButton createLabelLikeButton(Action action) {
        JButton button = new JButton(action);
        button.setBorderPainted(false);
        button.setContentAreaFilled(false);
        button.setFocusable(false);
        button.setOpaque(false);
        button.setHorizontalAlignment(2);
        return button;
    }

    public static void message(Component comp, String message, String title) {
        JOptionPane.showMessageDialog(comp, message, title, 1);
    }

    public static void error(Component comp, String message, String title) {
        JOptionPane.showMessageDialog(comp, message, title, 0);
    }

    public static void warn(Component comp, String message, String title) {
        JOptionPane.showMessageDialog(comp, message, title, 2);
    }
}

