/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.module.seq.config;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigList;
import com.typesafe.config.ConfigValue;
import fr.proline.module.seq.config.ParsingRuleEntry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeqRepoConfig {
    private static final Logger LOG = LoggerFactory.getLogger(SeqRepoConfig.class);
    private static final String PARSING_RULES_KEY = "parsing-rules";
    private static final String PR_NAME_KEY = "name";
    private static final String PR_FASTA_RELEASE_KEY = "fasta-version";
    private static final String PR_FASTA_NAME_KEY = "fasta-name";
    private static final String PR_PROT_ACC_KEY = "protein-accession";
    private static final String FASTA_DIR_KEY = "local-fasta-directories";
    private static final String DEFAULT_PROT_ACC_RULE_KEY = "default-protein-accession";
    private Map<String, Object> m_allProperties;
    private static final Object CONFIGURATION_LOCK = new Object();
    private static SeqRepoConfig instance;
    private Config m_seqRepoConfig = ConfigFactory.load((String)"parsing-rules");

    private SeqRepoConfig() {
    }

    public static SeqRepoConfig getInstance() {
        if (instance == null) {
            instance = new SeqRepoConfig();
        }
        return instance;
    }

    private Config getSeqRepoConfig() {
        if (this.m_seqRepoConfig == null) {
            this.m_seqRepoConfig = ConfigFactory.load((String)PARSING_RULES_KEY);
        }
        return this.m_seqRepoConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProperties() {
        Object object = CONFIGURATION_LOCK;
        synchronized (object) {
            this.m_allProperties = new HashMap<String, Object>();
            ArrayList<String> fastaDirs = new ArrayList<String>();
            if (this.getSeqRepoConfig().hasPath(FASTA_DIR_KEY)) {
                List fastaDirsObj = this.getSeqRepoConfig().getList(FASTA_DIR_KEY).unwrapped();
                for (Object nextEntry : fastaDirsObj) {
                    fastaDirs.add(nextEntry.toString());
                }
            }
            this.m_allProperties.put(FASTA_DIR_KEY, fastaDirs);
            String defProtAcc = null;
            if (this.getSeqRepoConfig().hasPath(DEFAULT_PROT_ACC_RULE_KEY)) {
                defProtAcc = this.getSeqRepoConfig().getString(DEFAULT_PROT_ACC_RULE_KEY);
            }
            this.m_allProperties.put(DEFAULT_PROT_ACC_RULE_KEY, defProtAcc);
            ArrayList<ParsingRuleEntry> parsingRules = new ArrayList<ParsingRuleEntry>();
            if (!this.getSeqRepoConfig().hasPath(PARSING_RULES_KEY)) {
                throw new RuntimeException("No Parsing rules specified");
            }
            ConfigList parsingRulesDef = this.getSeqRepoConfig().getList(PARSING_RULES_KEY);
            for (ConfigValue nextEntry : parsingRulesDef) {
                Map cv = (Map)nextEntry.unwrapped();
                ParsingRuleEntry pre = new ParsingRuleEntry((String)cv.get(PR_NAME_KEY), (List)cv.get(PR_FASTA_NAME_KEY), (String)cv.get(PR_FASTA_RELEASE_KEY), (String)cv.get(PR_PROT_ACC_KEY));
                parsingRules.add(pre);
            }
            this.m_allProperties.put(PARSING_RULES_KEY, parsingRules);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void forcePropertiesReload() {
        Object object = CONFIGURATION_LOCK;
        synchronized (object) {
            if (instance != null) {
                SeqRepoConfig.instance.m_seqRepoConfig = null;
                SeqRepoConfig.instance.m_allProperties = null;
            }
        }
    }

    private Map<String, Object> getProperties() {
        if (this.m_allProperties == null) {
            this.loadProperties();
        }
        return this.m_allProperties;
    }

    public List<String> getFastaDirectories() {
        return (List)this.getProperties().get(FASTA_DIR_KEY);
    }

    public String getDefaultProtAccRegEx() {
        return (String)this.getProperties().get(DEFAULT_PROT_ACC_RULE_KEY);
    }

    public List<ParsingRuleEntry> getParsingRules() {
        return (List)this.getProperties().get(PARSING_RULES_KEY);
    }
}

