/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.module.seq.dto;

import fr.profi.util.StringUtils;
import fr.proline.module.seq.dto.DDatabankInstance;
import fr.proline.module.seq.dto.DRepositoryProtein;
import fr.proline.module.seq.orm.Alphabet;
import fr.proline.module.seq.util.PeptideUtils;
import java.io.Serializable;

public class DBioSequence
implements Serializable {
    private static final long serialVersionUID = 3L;
    private final long m_sequenceId;
    private final String m_sequence;
    private final Object m_lazyLock = new Object();
    private Double m_mass;
    private Double m_pi;
    private final DDatabankInstance m_seDbInstance;
    private final String m_seDbRelease;
    private final DRepositoryProtein m_repositoryIdentifier;

    public DBioSequence(long sequenceId, String sequence, DDatabankInstance seDbInstance, String seDbRelease, DRepositoryProtein repositoryIdentifier) {
        this.m_sequenceId = sequenceId;
        if (StringUtils.isEmpty((String)sequence)) {
            throw new IllegalArgumentException("Invalid sequence");
        }
        this.m_sequence = sequence;
        if (seDbInstance == null) {
            throw new IllegalArgumentException("DatabankInstance wrapper is null");
        }
        this.m_seDbInstance = seDbInstance;
        if (StringUtils.isEmpty((String)seDbRelease)) {
            throw new IllegalArgumentException("Invalid seDbRelease");
        }
        this.m_seDbRelease = seDbRelease;
        this.m_repositoryIdentifier = repositoryIdentifier;
    }

    public long getSequenceId() {
        return this.m_sequenceId;
    }

    public String getSequence() {
        return this.m_sequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getMass() {
        double mass = 0.0;
        Object object = this.m_lazyLock;
        synchronized (object) {
            if (this.m_mass == null) {
                DDatabankInstance seDbInstance = this.getSEDbInstance();
                Alphabet alphabet = seDbInstance.getAlphabet();
                if (alphabet == Alphabet.AA) {
                    String sequence = this.getSequence();
                    mass = PeptideUtils.calculateMolecularWeight(sequence);
                }
                this.m_mass = mass;
            } else {
                mass = this.m_mass;
            }
        }
        return mass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getPI() {
        double pI = 0.0;
        Object object = this.m_lazyLock;
        synchronized (object) {
            if (this.m_pi == null) {
                DDatabankInstance seDbInstance = this.getSEDbInstance();
                Alphabet alphabet = seDbInstance.getAlphabet();
                if (alphabet == Alphabet.AA) {
                    String sequence = this.getSequence();
                    pI = PeptideUtils.calculateIsoelectricPoint(sequence);
                }
                this.m_pi = pI;
            } else {
                pI = this.m_pi;
            }
        }
        return pI;
    }

    public DDatabankInstance getSEDbInstance() {
        return this.m_seDbInstance;
    }

    public String getSEDbRelease() {
        return this.m_seDbRelease;
    }

    public DRepositoryProtein getRepositoryIdentifier() {
        return this.m_repositoryIdentifier;
    }
}

