/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.module.seq.orm.dao;

import fr.profi.util.StringUtils;
import fr.proline.core.orm.util.JPARepositoryUtils;
import fr.proline.module.seq.orm.DatabankInstance;
import fr.proline.module.seq.orm.DatabankProtein;
import fr.proline.repository.util.JPAUtils;
import java.util.Collection;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;

public final class DatabankProteinDao {
    public static List<DatabankProtein> findProteins(EntityManager seqEM, Collection<String> proteinIdentifiers) {
        JPAUtils.checkEntityManager((EntityManager)seqEM);
        return JPARepositoryUtils.executeInQueryAsBatch((TypedQuery)seqEM.createNamedQuery("findSEDbIdentByValues", DatabankProtein.class), (String)"values", proteinIdentifiers);
    }

    public static List<DatabankProtein> findProteinsInDatabank(EntityManager seqEM, DatabankInstance databank, Collection<String> proteinIdentifiers) {
        JPAUtils.checkEntityManager((EntityManager)seqEM);
        if (databank == null) {
            throw new IllegalArgumentException("SeDbInstance is null");
        }
        TypedQuery query = seqEM.createNamedQuery("findSEDbIdentBySEDbInstanceAndValues", DatabankProtein.class);
        query.setParameter("seDbInstance", (Object)databank);
        return JPARepositoryUtils.executeInQueryAsBatch((TypedQuery)query, (String)"values", proteinIdentifiers);
    }

    public static List<DatabankProtein> findProteinsInDatabankName(EntityManager seqEM, String seDbName, Collection<String> proteinIdentifiers) {
        JPAUtils.checkEntityManager((EntityManager)seqEM);
        if (StringUtils.isEmpty((String)seDbName)) {
            throw new IllegalArgumentException("Invalid seDbName");
        }
        TypedQuery query = seqEM.createNamedQuery("findSEDbIdentBySEDbNameAndValues", DatabankProtein.class);
        query.setParameter("seDbName", (Object)seDbName);
        return JPARepositoryUtils.executeInQueryAsBatch((TypedQuery)query, (String)"values", proteinIdentifiers);
    }

    public static List<DatabankProtein> findProteinsInDatabankNameAndRelease(EntityManager seqEM, String seDbName, String seDbVersion, Collection<String> proteinIdentifiers) {
        JPAUtils.checkEntityManager((EntityManager)seqEM);
        if (StringUtils.isEmpty((String)seDbName) || StringUtils.isEmpty((String)seDbVersion)) {
            throw new IllegalArgumentException("Invalid seDbName or seDbVersion");
        }
        TypedQuery query = seqEM.createNamedQuery("findSEDbIdentBySEDbNameReleaseAndValues", DatabankProtein.class);
        query.setParameter("seDbName", (Object)seDbName);
        query.setParameter("seDbVersion", (Object)seDbVersion);
        return JPARepositoryUtils.executeInQueryAsBatch((TypedQuery)query, (String)"values", proteinIdentifiers);
    }
}

