/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.module.seq.service;

import fr.profi.util.StringUtils;
import fr.proline.module.seq.config.SeqRepoConfig;
import fr.proline.module.seq.service.DataSource;
import fr.proline.module.seq.service.FastaPathsScanner;
import fr.proline.module.seq.service.FastaSource;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(DataSourceBuilder.class);
    private final Object m_foundFastaFilesLock = new Object();
    private Map<String, List<File>> m_foundFastaFiles;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceRescanFastaFiles() {
        Object object = this.m_foundFastaFilesLock;
        synchronized (object) {
            this.m_foundFastaFiles = null;
        }
    }

    public DataSource buildFastaSource(String sourceFileName, Pattern proteinIdentifierPattern, Pattern repositoryIdentifierPattern) throws Exception {
        assert (!StringUtils.isEmpty((String)sourceFileName)) : "Invalid sourceFileName";
        assert (proteinIdentifierPattern != null) : "SeDbIdentPattern is null";
        FastaSource fastaSource = null;
        Map<String, List<File>> fastaFiles = this.getFastaFiles();
        if (fastaFiles != null && !fastaFiles.isEmpty()) {
            List<File> files = fastaFiles.get(sourceFileName);
            if (files == null || files.isEmpty()) {
                LOG.warn("Cannot find [{}] in given fastaFilePaths", (Object)sourceFileName);
            } else {
                File foundFastaFile = DataSourceBuilder.retrieveLatest(files);
                fastaSource = new FastaSource(foundFastaFile, proteinIdentifierPattern, repositoryIdentifierPattern);
            }
        }
        return fastaSource;
    }

    public List<File> locateFastaFile(String namePart) throws Exception {
        assert (!StringUtils.isEmpty((String)namePart)) : "Invalid namePart";
        ArrayList<File> result = new ArrayList<File>();
        Map<String, List<File>> fastaFiles = this.getFastaFiles();
        if (fastaFiles != null && !fastaFiles.isEmpty()) {
            Set<Map.Entry<String, List<File>>> entries = fastaFiles.entrySet();
            for (Map.Entry<String, List<File>> entry : entries) {
                String fastaFileName = entry.getKey();
                if (!fastaFileName.contains(namePart)) continue;
                result.addAll((Collection<File>)entry.getValue());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, List<File>> getFastaFiles() throws Exception {
        Map<String, List<File>> fastaFiles = null;
        Object object = this.m_foundFastaFilesLock;
        synchronized (object) {
            if (this.m_foundFastaFiles == null) {
                List<String> localFASTAPaths = SeqRepoConfig.getInstance().getFastaDirectories();
                if (localFASTAPaths != null && !localFASTAPaths.isEmpty()) {
                    this.m_foundFastaFiles = fastaFiles = FastaPathsScanner.scanPaths(new FastaPathsScanner(), localFASTAPaths);
                } else {
                    LOG.error("No valid localFASTAPaths configured");
                }
            } else {
                fastaFiles = this.m_foundFastaFiles;
            }
        }
        return fastaFiles;
    }

    private static File retrieveLatest(List<File> files) {
        assert (files != null) : "retrieveLatest() files List is null";
        File latest = null;
        for (File f : files) {
            if (latest == null) {
                latest = f;
                continue;
            }
            if (f.lastModified() <= latest.lastModified()) continue;
            LOG.info("Use latest version of [{}]", (Object)f.getAbsolutePath());
            latest = f;
        }
        return latest;
    }
}

