/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.module.seq.util;

import org.biojava.nbio.aaproperties.Constraints;
import org.biojava.nbio.aaproperties.IPeptideProperties;
import org.biojava.nbio.aaproperties.PeptidePropertiesImpl;
import org.biojava.nbio.core.sequence.ProteinSequence;
import org.biojava.nbio.core.sequence.compound.AminoAcidCompound;
import org.biojava.nbio.core.sequence.compound.AminoAcidCompoundSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PeptideUtils {
    private static final Logger LOG = LoggerFactory.getLogger(PeptideUtils.class);
    private static final IPeptideProperties PEPTIDE_PROPERTIES = new PeptidePropertiesImpl();

    private PeptideUtils() {
    }

    public static boolean checkSequence(String normalizedSequence) {
        boolean valid = false;
        if (normalizedSequence != null) {
            valid = true;
            int sequenceLength = normalizedSequence.length();
            for (int i = 0; valid && i < sequenceLength; ++i) {
                char currentResidue = normalizedSequence.charAt(i);
                if (currentResidue >= 'A' && currentResidue <= 'Z') continue;
                valid = false;
            }
        }
        return valid;
    }

    public static double calculateMolecularWeight(String sequence) {
        if (!PeptideUtils.checkSequence(sequence)) {
            throw new IllegalArgumentException("Invalid sequence");
        }
        double molecularWeight = 0.0;
        try {
            ProteinSequence protSequence = new ProteinSequence(sequence);
            molecularWeight = PEPTIDE_PROPERTIES.getMolecularWeight(protSequence);
        }
        catch (Exception ex) {
            LOG.error("Error calculating molecularWeight", (Throwable)ex);
        }
        return molecularWeight;
    }

    public static double calculateIsoelectricPoint(String sequence) {
        if (!PeptideUtils.checkSequence(sequence)) {
            throw new IllegalArgumentException("Invalid sequence");
        }
        double isoelectricPoint = 0.0;
        try {
            ProteinSequence protSequence = new ProteinSequence(sequence);
            isoelectricPoint = PEPTIDE_PROPERTIES.getIsoelectricPoint(protSequence);
        }
        catch (Exception ex) {
            LOG.error("Error calculating isoelectricPoint", (Throwable)ex);
        }
        return isoelectricPoint;
    }

    static {
        AminoAcidCompoundSet aaSet = new AminoAcidCompoundSet();
        AminoAcidCompound U = aaSet.getCompoundForString("U");
        AminoAcidCompound J = aaSet.getCompoundForString("J");
        AminoAcidCompound B = aaSet.getCompoundForString("B");
        AminoAcidCompound X = aaSet.getCompoundForString("X");
        AminoAcidCompound Z = aaSet.getCompoundForString("Z");
        Constraints.aa2MolecularWeight.put(U, new Double(U.getMolecularWeight().floatValue()));
        Constraints.aa2MolecularWeight.put(J, (double)(aaSet.getCompoundForString("I").getMolecularWeight().floatValue() + aaSet.getCompoundForString("L").getMolecularWeight().floatValue()) / 2.0);
        Constraints.aa2MolecularWeight.put(B, (double)(aaSet.getCompoundForString("N").getMolecularWeight().floatValue() + aaSet.getCompoundForString("D").getMolecularWeight().floatValue()) / 2.0);
        Constraints.aa2MolecularWeight.put(Z, (double)(aaSet.getCompoundForString("E").getMolecularWeight().floatValue() + aaSet.getCompoundForString("Q").getMolecularWeight().floatValue()) / 2.0);
        Constraints.aa2MolecularWeight.put(X, 110.0);
    }
}

