/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.module.seq.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegExUtil {
    private static final Logger LOG = LoggerFactory.getLogger(RegExUtil.class);

    public static String parseReleaseVersion(String fastaFileName, String releaseRegEx) {
        assert (fastaFileName != null) : "parseReleaseVersion() fastaFileName is null";
        assert (releaseRegEx != null) : "parseReleaseVersion() releaseRegEx is null";
        Pattern releasePattern = Pattern.compile(releaseRegEx, 2);
        String result = null;
        if (releasePattern != null) {
            Matcher matcher = releasePattern.matcher(fastaFileName);
            if (matcher.find()) {
                if (matcher.groupCount() < 1) {
                    throw new IllegalArgumentException("Invalid Release version Regex");
                }
                result = matcher.group(1).trim();
            } else {
                LOG.warn("Cannot parse release version for fastaFileName [{}] with \"{}\" Regex", (Object)fastaFileName, (Object)releasePattern.pattern());
            }
        }
        return result;
    }

    public static String getMatchingString(String sourceText, String searchStrRegEx) {
        Matcher matcher;
        if (sourceText == null || searchStrRegEx == null) {
            return null;
        }
        Pattern textPattern = Pattern.compile(searchStrRegEx, 2);
        String result = null;
        if (textPattern != null && (matcher = textPattern.matcher(sourceText)).find() && matcher.groupCount() >= 1) {
            result = matcher.group(1).trim();
        }
        return result;
    }
}

