/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rtree.geometry;

import com.github.davidmoten.guavamini.Objects;
import com.github.davidmoten.guavamini.Optional;
import com.github.davidmoten.rtree.geometry.Geometries;
import com.github.davidmoten.rtree.geometry.Geometry;
import com.github.davidmoten.rtree.geometry.Line;
import com.github.davidmoten.rtree.geometry.Point;
import com.github.davidmoten.rtree.geometry.Rectangle;
import com.github.davidmoten.rtree.geometry.RectangleImpl;
import com.github.davidmoten.rtree.internal.util.ObjectsHelper;

public final class Circle
implements Geometry {
    private final float x;
    private final float y;
    private final float radius;
    private final Rectangle mbr;

    protected Circle(float x, float y, float radius) {
        this.x = x;
        this.y = y;
        this.radius = radius;
        this.mbr = RectangleImpl.create(x - radius, y - radius, x + radius, y + radius);
    }

    static Circle create(double x, double y, double radius) {
        return new Circle((float)x, (float)y, (float)radius);
    }

    static Circle create(float x, float y, float radius) {
        return new Circle(x, y, radius);
    }

    public float x() {
        return this.x;
    }

    public float y() {
        return this.y;
    }

    public float radius() {
        return this.radius;
    }

    @Override
    public Rectangle mbr() {
        return this.mbr;
    }

    @Override
    public double distance(Rectangle r) {
        return Math.max(0.0, Geometries.point(this.x, this.y).distance(r) - (double)this.radius);
    }

    @Override
    public boolean intersects(Rectangle r) {
        return this.distance(r) == 0.0;
    }

    public boolean intersects(Circle c) {
        double total = this.radius + c.radius;
        return Geometries.point(this.x, this.y).distanceSquared(Geometries.point(c.x, c.y)) <= total * total;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.radius)});
    }

    public boolean equals(Object obj) {
        Optional<Circle> other = ObjectsHelper.asClass(obj, Circle.class);
        if (other.isPresent()) {
            return Objects.equal((Object)Float.valueOf(this.x), (Object)Float.valueOf(((Circle)other.get()).x)) && Objects.equal((Object)Float.valueOf(this.y), (Object)Float.valueOf(((Circle)other.get()).y)) && Objects.equal((Object)Float.valueOf(this.radius), (Object)Float.valueOf(((Circle)other.get()).radius));
        }
        return false;
    }

    public boolean intersects(Point point) {
        return Math.sqrt(this.sqr(this.x - point.x()) + this.sqr(this.y - point.y())) <= (double)this.radius;
    }

    private float sqr(float x) {
        return x * x;
    }

    public boolean intersects(Line line) {
        return line.intersects(this);
    }
}

