/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rtree.internal.util;

import com.github.davidmoten.guavamini.Optional;
import java.util.Iterator;

public final class ImmutableStack<T>
implements Iterable<T> {
    private final Optional<T> head;
    private final Optional<ImmutableStack<T>> tail;
    private static ImmutableStack<?> EMPTY = new ImmutableStack();

    public ImmutableStack(T head, ImmutableStack<T> tail) {
        this(Optional.of(head), Optional.of(tail));
    }

    private ImmutableStack(Optional<T> head, Optional<ImmutableStack<T>> tail) {
        this.head = head;
        this.tail = tail;
    }

    public static <T> ImmutableStack<T> create(T t) {
        return new ImmutableStack<T>(Optional.of(t), Optional.of(ImmutableStack.empty()));
    }

    public ImmutableStack() {
        this(Optional.absent(), Optional.absent());
    }

    public static <S> ImmutableStack<S> empty() {
        return EMPTY;
    }

    public boolean isEmpty() {
        return !this.head.isPresent();
    }

    public T peek() {
        return (T)this.head.get();
    }

    public ImmutableStack<T> pop() {
        return (ImmutableStack)this.tail.get();
    }

    public ImmutableStack<T> push(T value) {
        return new ImmutableStack<T>(value, this);
    }

    @Override
    public Iterator<T> iterator() {
        return new StackIterator(this);
    }

    private static class StackIterator<U>
    implements Iterator<U> {
        private ImmutableStack<U> stack;

        public StackIterator(ImmutableStack<U> stack) {
            this.stack = stack;
        }

        @Override
        public boolean hasNext() {
            return !this.stack.isEmpty();
        }

        @Override
        public U next() {
            U result = this.stack.peek();
            this.stack = this.stack.pop();
            return result;
        }

        @Override
        public void remove() {
            throw new RuntimeException("not supported");
        }
    }
}

