/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.inf.sape.hac;

import ch.usi.inf.sape.hac.ClusteringBuilder;

public final class ClusteringMatrixBuilder
implements ClusteringBuilder {
    private static final int INVALID = -1;
    private final int[][] clustering;
    private int currentStep;

    public ClusteringMatrixBuilder(int nObservations) {
        int nSteps = nObservations;
        this.clustering = new int[nSteps][nObservations];
        int observation = 0;
        while (observation < nObservations) {
            this.clustering[0][observation] = observation;
            int step = 1;
            while (step < nSteps) {
                this.clustering[step][observation] = -1;
                ++step;
            }
            ++observation;
        }
        this.currentStep = 0;
    }

    public void merge(int i, int j, double dissimilarity) {
        int previousStep = this.currentStep++;
        int observation = 0;
        while (observation < this.clustering.length) {
            int previousCluster = this.clustering[previousStep][observation];
            this.clustering[this.currentStep][observation] = previousCluster == j ? i : previousCluster;
            ++observation;
        }
    }

    public int[][] getClustering() {
        return this.clustering;
    }
}

