/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.inf.sape.hac.dendrogram;

import ch.usi.inf.sape.hac.ClusteringBuilder;
import ch.usi.inf.sape.hac.dendrogram.Dendrogram;
import ch.usi.inf.sape.hac.dendrogram.DendrogramNode;
import ch.usi.inf.sape.hac.dendrogram.MergeNode;
import ch.usi.inf.sape.hac.dendrogram.ObservationNode;

public final class DendrogramBuilder
implements ClusteringBuilder {
    private final DendrogramNode[] nodes;
    private MergeNode lastMergeNode;

    public DendrogramBuilder(int nObservations) {
        this.nodes = new DendrogramNode[nObservations];
        int i = 0;
        while (i < nObservations) {
            this.nodes[i] = new ObservationNode(i);
            ++i;
        }
    }

    public final void merge(int i, int j, double dissimilarity) {
        MergeNode node = new MergeNode(this.nodes[i], this.nodes[j], dissimilarity);
        this.nodes[i] = node;
        this.lastMergeNode = node;
    }

    public final Dendrogram getDendrogram() {
        if (this.nodes.length == 1) {
            return new Dendrogram(this.nodes[0]);
        }
        return new Dendrogram(this.lastMergeNode);
    }
}

