/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.jcache;

import javax.cache.Cache;
import org.springframework.cache.Cache;
import org.springframework.cache.support.AbstractValueAdaptingCache;
import org.springframework.util.Assert;

public class JCacheCache
extends AbstractValueAdaptingCache {
    private final Cache<Object, Object> cache;

    public JCacheCache(Cache<Object, Object> jcache) {
        this(jcache, true);
    }

    public JCacheCache(Cache<Object, Object> jcache, boolean allowNullValues) {
        super(allowNullValues);
        Assert.notNull(jcache, (String)"Cache must not be null");
        this.cache = jcache;
    }

    public final String getName() {
        return this.cache.getName();
    }

    public final Cache<Object, Object> getNativeCache() {
        return this.cache;
    }

    protected Object lookup(Object key) {
        return this.cache.get(key);
    }

    public void put(Object key, Object value) {
        this.cache.put(key, this.toStoreValue(value));
    }

    public Cache.ValueWrapper putIfAbsent(Object key, Object value) {
        boolean set = this.cache.putIfAbsent(key, this.toStoreValue(value));
        return set ? null : this.get(key);
    }

    public void evict(Object key) {
        this.cache.remove(key);
    }

    public void clear() {
        this.cache.removeAll();
    }
}

