/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.ChainImpl;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.ResidueNumber;
import org.biojava.nbio.structure.ResidueRange;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.StructureIdentifier;
import org.biojava.nbio.structure.StructureImpl;
import org.biojava.nbio.structure.align.util.AtomCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubstructureIdentifier
implements Serializable,
StructureIdentifier {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(SubstructureIdentifier.class);
    private final String pdbId;
    private final List<ResidueRange> ranges;

    public SubstructureIdentifier(String id) {
        String[] idRange = id.split("\\.");
        if (1 > idRange.length || idRange.length > 2) {
            throw new IllegalArgumentException(String.format("Malformed %s: %s", this.getClass().getSimpleName(), id));
        }
        if (idRange[0].length() != 4) {
            this.pdbId = idRange[0];
            logger.warn(String.format("Unrecognized PDB code %s", this.pdbId));
        } else {
            this.pdbId = idRange[0].toUpperCase();
        }
        if (idRange.length == 2) {
            String rangeStr = idRange[1].trim();
            this.ranges = ResidueRange.parseMultiple(rangeStr);
        } else {
            this.ranges = new LinkedList<ResidueRange>();
        }
    }

    public SubstructureIdentifier(String pdbId, List<ResidueRange> ranges) {
        if (ranges == null) {
            throw new NullPointerException("Null ranges list");
        }
        this.pdbId = pdbId;
        this.ranges = ranges;
    }

    public String toString() {
        return this.getIdentifier();
    }

    @Override
    public String getIdentifier() {
        if (this.ranges.isEmpty()) {
            return this.pdbId;
        }
        return this.pdbId + "." + ResidueRange.toString(this.ranges);
    }

    public String getPdbId() {
        return this.pdbId;
    }

    public List<ResidueRange> getResidueRanges() {
        return this.ranges;
    }

    @Override
    public SubstructureIdentifier toCanonical() {
        return this;
    }

    @Override
    public Structure reduce(Structure s) throws StructureException {
        StructureImpl newS = new StructureImpl();
        newS.setPDBCode(s.getPDBCode());
        newS.setPDBHeader(s.getPDBHeader());
        newS.setName(this.toString());
        newS.setDBRefs(s.getDBRefs());
        newS.setBiologicalAssembly(s.isBiologicalAssembly());
        newS.getPDBHeader().setDescription("sub-range " + this.ranges + " of " + newS.getPDBCode() + " " + s.getPDBHeader().getDescription());
        newS.setCompounds(s.getCompounds());
        newS.setSSBonds(s.getSSBonds());
        newS.setSites(s.getSites());
        newS.setStructureIdentifier(this);
        for (int modelNr = 0; modelNr < s.nrModels(); ++modelNr) {
            String prevChainId = null;
            newS.addModel(new ArrayList<Chain>());
            if (this.getResidueRanges().isEmpty()) {
                newS.setCompounds(s.getCompounds());
                newS.setSSBonds(s.getSSBonds());
                newS.setSites(s.getSites());
                newS.setModel(modelNr, s.getModel(modelNr));
                continue;
            }
            for (ResidueRange range : this.getResidueRanges()) {
                Chain chain;
                String chainId = range.getChainId();
                ResidueNumber pdbresnum1 = range.getStart();
                ResidueNumber pdbresnum2 = range.getEnd();
                if (chainId.equals("_")) {
                    chain = s.getChain(modelNr, 0);
                    if (pdbresnum1 != null) {
                        pdbresnum1.setChainId(chain.getChainID());
                    }
                    if (pdbresnum2 != null) {
                        pdbresnum2.setChainId(chain.getChainID());
                    }
                    if (s.size() != 1) {
                        logger.warn("Multiple possible chains match '_'. Using chain {}", (Object)chain.getChainID());
                    }
                } else {
                    try {
                        chain = s.getChainByPDB(chainId, modelNr);
                    }
                    catch (StructureException e) {
                        try {
                            int chainNum = Integer.parseInt(chainId);
                            try {
                                chain = s.getChain(modelNr, chainNum);
                                logger.warn("No chain found for {}. Interpretting it as an index, using chain {} instead", (Object)chainId, (Object)chain.getChainID());
                            }
                            catch (Exception e2) {
                                throw e;
                            }
                        }
                        catch (NumberFormatException e3) {
                            throw e;
                        }
                    }
                }
                List<Group> groups = pdbresnum1 == null && pdbresnum2 == null ? chain.getAtomGroups() : Arrays.asList(chain.getGroupsByPDB(pdbresnum1, pdbresnum2));
                Chain c = null;
                if (prevChainId != null && prevChainId.equals(chain.getChainID())) {
                    c = newS.getChainByPDB(prevChainId, modelNr);
                } else {
                    try {
                        c = newS.getChainByPDB(chain.getChainID(), modelNr);
                    }
                    catch (StructureException structureException) {
                        // empty catch block
                    }
                }
                if (c == null) {
                    c = new ChainImpl();
                    c.setChainID(chain.getChainID());
                    newS.addChain(c, modelNr);
                    c.setSeqResGroups(chain.getSeqResGroups());
                    c.setSeqMisMatches(chain.getSeqMisMatches());
                }
                for (Group g : groups) {
                    c.addGroup(g);
                }
                prevChainId = c.getChainID();
            }
        }
        return newS;
    }

    @Override
    public Structure loadStructure(AtomCache cache) throws IOException, StructureException {
        String pdb = this.getPdbId();
        if (pdb == null) {
            return null;
        }
        return cache.getStructureForPdbId(pdb);
    }
}

