/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.multiple.mc;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.biojava.nbio.structure.align.ce.ConfigStrucAligParams;

public class MultipleMcParameters
implements ConfigStrucAligParams {
    private int randomSeed;
    private int minBlockLen;
    private int minAlignedStructures;
    private double gapOpen;
    private double gapExtension;
    private double distanceCutoff;
    private int convergenceSteps;
    private int nrThreads;

    public MultipleMcParameters() {
        this.reset();
    }

    @Override
    public List<String> getUserConfigParameters() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("RandomSeed");
        params.add("MinBlockLen");
        params.add("MinAlignedStructures");
        params.add("GapOpen");
        params.add("GapExtension");
        params.add("DistanceCutoff");
        params.add("ConvergenceSteps");
        params.add("NrThreads");
        return params;
    }

    @Override
    public List<String> getUserConfigParameterNames() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("Random Seed");
        params.add("Minimum Block Length");
        params.add("Minimum Structures per Column");
        params.add("Gap Opening Penalty");
        params.add("Gap Extension Penalty");
        params.add("Distance Cutoff");
        params.add("Steps to Convergence");
        params.add("Number of Threads");
        return params;
    }

    @Override
    public List<Class> getUserConfigTypes() {
        ArrayList<Class> params = new ArrayList<Class>();
        params.add(Integer.class);
        params.add(Integer.class);
        params.add(Integer.class);
        params.add(Double.class);
        params.add(Double.class);
        params.add(Double.class);
        params.add(Integer.class);
        params.add(Integer.class);
        return params;
    }

    @Override
    public List<String> getUserConfigHelp() {
        ArrayList<String> params = new ArrayList<String>();
        String randomSeed = "Random seed for the optimizer random number generator.";
        String minBlockLen = "Minimum number of aligned positions in a Block of the Multiple Alignment.";
        String minAlignedStructures = "Minimum number of structures aligned in a column (without gaps). If it is 0 the minimum is calculated as a third of the total number of structures.";
        String gapOpen = "Penalty for opening a gap in any of the structures.";
        String gapExtension = "Penalty for extending a gapped region in any of the structures.";
        String dCutoff = "Distance Cutoff: the maximum allowed distance (in A) between two aligned residues.";
        String convergenceSteps = "Number of steps without a change in the alignment before stopping. Proportional to the calculation time. If it is 0 the convergence steps are calculated proportional to the number of structures and their length.";
        String nrThreads = "Number of threads to be used for the seed calculation (all-to-all pairwise alignments) and the MC optimization.";
        params.add(randomSeed);
        params.add(minBlockLen);
        params.add(minAlignedStructures);
        params.add(gapOpen);
        params.add(gapExtension);
        params.add(dCutoff);
        params.add(convergenceSteps);
        params.add(nrThreads);
        return params;
    }

    public String toString() {
        return "MultipleMcParameters [randomSeed=" + this.randomSeed + ", minBlockLen=" + this.minBlockLen + ", minAlignedStructures=" + this.minAlignedStructures + ", gapOpen=" + this.gapOpen + ", gapExtension=" + this.gapExtension + ", distanceCutoff=" + this.distanceCutoff + ", convergenceSteps=" + this.convergenceSteps + ", nrThreads=" + this.nrThreads + "]";
    }

    @Override
    public void reset() {
        this.randomSeed = new Random().nextInt(10000);
        this.minBlockLen = 10;
        this.minAlignedStructures = 0;
        this.gapOpen = 20.0;
        this.gapExtension = 15.0;
        this.distanceCutoff = 7.0;
        this.convergenceSteps = 0;
        this.nrThreads = Runtime.getRuntime().availableProcessors();
    }

    public int getRandomSeed() {
        return this.randomSeed;
    }

    public void setRandomSeed(Integer randomSeed) {
        this.randomSeed = randomSeed;
    }

    public int getMinBlockLen() {
        return this.minBlockLen;
    }

    public void setMinBlockLen(Integer minBlockLen) {
        this.minBlockLen = minBlockLen;
    }

    public int getMinAlignedStructures() {
        return this.minAlignedStructures;
    }

    public void setMinAlignedStructures(Integer minAlignedStructures) {
        this.minAlignedStructures = minAlignedStructures;
    }

    public double getGapOpen() {
        return this.gapOpen;
    }

    public void setGapOpen(Double gapOpen) {
        this.gapOpen = gapOpen;
    }

    public double getGapExtension() {
        return this.gapExtension;
    }

    public void setGapExtension(Double gapExtension) {
        this.gapExtension = gapExtension;
    }

    public int getConvergenceSteps() {
        return this.convergenceSteps;
    }

    public void setConvergenceSteps(Integer convergenceSteps) {
        this.convergenceSteps = convergenceSteps;
    }

    public int getNrThreads() {
        return this.nrThreads;
    }

    public void setNrThreads(Integer nrThreads) {
        this.nrThreads = nrThreads;
    }

    public double getDistanceCutoff() {
        return this.distanceCutoff;
    }

    public void setDistanceCutoff(Double distanceCutoff) {
        this.distanceCutoff = distanceCutoff;
    }
}

