/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.util;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import org.biojava.nbio.core.util.PrettyXMLWriter;
import org.biojava.nbio.core.util.XMLWriter;
import org.biojava.nbio.structure.align.ce.StartupParameters;
import org.biojava.nbio.structure.io.LocalPDBDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(UserConfiguration.class);
    public static final String PDB_FORMAT = "PDB";
    public static final String MMCIF_FORMAT = "mmCif";
    public static final String TMP_DIR = "java.io.tmpdir";
    public static final String PDB_DIR = "PDB_DIR";
    public static final String PDB_CACHE_DIR = "PDB_CACHE_DIR";
    public static final String lineSplit = System.getProperty("file.separator");
    private String pdbFilePath;
    private String cacheFilePath;
    private LocalPDBDirectory.FetchBehavior fetchBehavior = LocalPDBDirectory.FetchBehavior.DEFAULT;
    private LocalPDBDirectory.ObsoleteBehavior obsoleteBehavior = LocalPDBDirectory.ObsoleteBehavior.DEFAULT;
    private String fileFormat = "mmCif";

    public UserConfiguration() {
        this.pdbFilePath = this.initPdbFilePath();
        this.cacheFilePath = this.initCacheFilePath();
    }

    private String initPdbFilePath() {
        String path = null;
        String propertyName = PDB_DIR;
        String userProvidedDir = System.getProperty(propertyName);
        if (userProvidedDir != null && !userProvidedDir.trim().isEmpty()) {
            path = userProvidedDir;
            logger.debug("Read PDB dir from system property {}: {}", (Object)propertyName, (Object)path);
            File f = new File(path);
            if (!f.isDirectory()) {
                logger.warn("Provided path {} (with system property {}) is not a directory. Using system's temp directory instead {}", new Object[]{path, propertyName, System.getProperty(TMP_DIR)});
                path = System.getProperty(TMP_DIR);
            } else if (!f.canWrite()) {
                logger.warn("Provided path {} (with system property {}) is not writable. Will not be able to write cached files.", (Object)path, (Object)propertyName);
            }
        } else {
            Map<String, String> env = System.getenv();
            if (env.containsKey(propertyName) && !env.get(propertyName).trim().isEmpty()) {
                path = env.get(propertyName);
                logger.debug("Read dir from environment variable {}: {}", (Object)propertyName, (Object)path);
                File f = new File(path);
                if (!f.isDirectory()) {
                    logger.warn("Provided path {} (with environment variable {}) is not a directory. Using system's temp directory instead {}", new Object[]{path, propertyName, System.getProperty(TMP_DIR)});
                    path = System.getProperty(TMP_DIR);
                } else if (!f.canWrite()) {
                    logger.warn("Provided path {} (with environment variable {}) is not writable. Will not be able to write cached files", (Object)path, (Object)propertyName);
                }
            } else {
                path = System.getProperty(TMP_DIR);
                logger.warn("Could not read dir from system property {} or environment variable {}, using system's temp directory {}", new Object[]{propertyName, propertyName, path});
                System.setProperty(propertyName, path);
            }
        }
        if (!path.endsWith(lineSplit)) {
            path = path + lineSplit;
        }
        return path;
    }

    private String initCacheFilePath() {
        String path = null;
        String propertyName = PDB_CACHE_DIR;
        String userProvidedDir = System.getProperty(propertyName);
        if (userProvidedDir != null) {
            path = userProvidedDir;
            logger.debug("Read cache dir from system property {}: {}", (Object)propertyName, (Object)path);
            File f = new File(path);
            if (!f.isDirectory()) {
                logger.warn("Provided path {} (with system property {}) is not a directory. Using system's temp directory instead {}", new Object[]{path, propertyName, System.getProperty(TMP_DIR)});
                path = System.getProperty(TMP_DIR);
            } else if (!f.canWrite()) {
                logger.warn("Provided path {} (with system property {}) is not writable. Using system's temp directory instead {}", new Object[]{path, propertyName, System.getProperty(TMP_DIR)});
                path = System.getProperty(TMP_DIR);
                System.setProperty(propertyName, path);
            }
        } else {
            Map<String, String> env = System.getenv();
            if (env.containsKey(propertyName)) {
                path = env.get(propertyName);
                logger.debug("Read dir from environment variable {}: {}", (Object)propertyName, (Object)path);
                File f = new File(path);
                if (!f.isDirectory()) {
                    logger.warn("Provided path {} (with environment variable {}) is not a directory. Using system's temp directory instead {}", new Object[]{path, propertyName, System.getProperty(TMP_DIR)});
                    path = System.getProperty(TMP_DIR);
                } else if (!f.canWrite()) {
                    logger.warn("Provided path {} (with environment variable {}) is not writable. Using system's temp directory instead {}", new Object[]{path, propertyName, System.getProperty(TMP_DIR)});
                    path = System.getProperty(TMP_DIR);
                }
            } else if (new File(this.pdbFilePath).canWrite()) {
                path = this.pdbFilePath;
                logger.info("Could not read cache dir from system property {} or environment variable {}, using PDB directory instead {}", new Object[]{propertyName, propertyName, path});
                System.setProperty(propertyName, path);
            } else {
                path = System.getProperty(TMP_DIR);
                logger.warn("Could not read cache dir from system property {} or environment variable {}, and PDB directory {} is not writable. Using system's temp directory instead {}", new Object[]{propertyName, propertyName, this.pdbFilePath, path});
                System.setProperty(propertyName, path);
            }
        }
        if (!path.endsWith(lineSplit)) {
            path = path + lineSplit;
        }
        return path;
    }

    public String getPdbFilePath() {
        return this.pdbFilePath;
    }

    public void setPdbFilePath(String pdbFilePath) {
        this.pdbFilePath = pdbFilePath;
    }

    public String getCacheFilePath() {
        return this.cacheFilePath;
    }

    public void setCacheFilePath(String cacheFilePath) {
        this.cacheFilePath = cacheFilePath;
    }

    @Deprecated
    public boolean getAutoFetch() {
        return this.fetchBehavior != LocalPDBDirectory.FetchBehavior.LOCAL_ONLY;
    }

    @Deprecated
    public void setAutoFetch(boolean autoFetch) {
        if (autoFetch) {
            this.setFetchBehavior(LocalPDBDirectory.FetchBehavior.DEFAULT);
        } else {
            this.setFetchBehavior(LocalPDBDirectory.FetchBehavior.LOCAL_ONLY);
        }
    }

    public LocalPDBDirectory.FetchBehavior getFetchBehavior() {
        return this.fetchBehavior;
    }

    public void setFetchBehavior(LocalPDBDirectory.FetchBehavior fetchBehavior) {
        this.fetchBehavior = fetchBehavior;
    }

    public LocalPDBDirectory.ObsoleteBehavior getObsoleteBehavior() {
        return this.obsoleteBehavior;
    }

    public void setObsoleteBehavior(LocalPDBDirectory.ObsoleteBehavior obsoleteBehavior) {
        this.obsoleteBehavior = obsoleteBehavior;
    }

    public XMLWriter toXML(PrintWriter pw) throws IOException {
        PrettyXMLWriter xw = new PrettyXMLWriter(pw);
        this.toXML((XMLWriter)xw);
        return xw;
    }

    public XMLWriter toXML(XMLWriter xw) throws IOException {
        xw.printRaw("<?xml version='1.0' standalone='no' ?>");
        xw.openTag("JFatCatConfig");
        xw.openTag("PDBFILEPATH");
        String tempdir = System.getProperty(TMP_DIR);
        if (!this.pdbFilePath.equals(tempdir)) {
            xw.attribute("path", this.pdbFilePath);
        }
        xw.attribute("fetchBehavior", (Object)((Object)this.fetchBehavior) + "");
        xw.attribute("obsoleteBehavior", (Object)((Object)this.obsoleteBehavior) + "");
        xw.attribute("fileFormat", this.fileFormat);
        xw.closeTag("PDBFILEPATH");
        xw.closeTag("JFatCatConfig");
        return xw;
    }

    public static UserConfiguration fromStartupParams(StartupParameters params) {
        UserConfiguration config = new UserConfiguration();
        config.setPdbFilePath(params.getPdbFilePath());
        config.setAutoFetch(params.isAutoFetch());
        config.setFileFormat(PDB_FORMAT);
        return config;
    }

    public void setFileFormat(String fileFormat) {
        this.fileFormat = fileFormat;
    }

    public String getFileFormat() {
        return this.fileFormat;
    }
}

