/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.io;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Bond;
import org.biojava.nbio.structure.Group;

public class GroupToSDF {
    public String getText(Group thisGroup) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getHeader(thisGroup));
        sb.append(this.getCtab(thisGroup));
        return sb.toString();
    }

    private String getCtab(Group thisGroup) {
        DecimalFormat df = new DecimalFormat("0.0000");
        StringBuilder header = new StringBuilder();
        StringBuilder atomList = new StringBuilder();
        StringBuilder bondOrders = new StringBuilder();
        int numBonds = 0;
        List<Atom> atoms = thisGroup.getAtoms();
        for (Atom a : thisGroup.getAtoms()) {
            String spaceX = this.getSpace(10, df.format(a.getX()));
            String spaceY = this.getSpace(10, df.format(a.getY()));
            String spaceZ = this.getSpace(10, df.format(a.getZ()));
            String spaceEle = this.getSpace(4, a.getElement().toString());
            atomList.append(spaceX + df.format(a.getX()) + spaceY + df.format(a.getY()) + spaceZ + df.format(a.getZ()) + " " + a.getElement().toString() + spaceEle + "0  0  0  0  0  0  0  0  0  0  0  0\n");
            for (Bond b : a.getBonds()) {
                Atom otherAtom = b.getOther(a);
                if (atoms.indexOf(otherAtom) >= atoms.indexOf(a) || atoms.indexOf(otherAtom) < 0 || atoms.indexOf(a) < 0) continue;
                ++numBonds;
                String indexOther = Integer.toString(atoms.indexOf(otherAtom) + 1);
                String index = Integer.toString(atoms.indexOf(a) + 1);
                String order = Integer.toString(b.getBondOrder());
                String spaceIndOne = this.getSpace(3, index);
                String spaceIndTwo = this.getSpace(3, indexOther);
                String spaceOrder = this.getSpace(3, order);
                bondOrders.append(spaceIndOne + index + spaceIndTwo + indexOther + spaceOrder + order + "  0\n");
            }
        }
        StringBuilder outString = new StringBuilder();
        String spaceNumAtoms = this.getSpace(3, Integer.toString(thisGroup.getAtoms().size()));
        String spaceNumBonds = this.getSpace(3, Integer.toString(numBonds));
        header.append("\n");
        header.append(spaceNumAtoms + thisGroup.getAtoms().size() + spaceNumBonds + numBonds + "  0  0  0  0  0  0  0  0999 V2000\n");
        outString.append(header.toString());
        outString.append(atomList.toString());
        outString.append(bondOrders.toString());
        outString.append(this.getCharges(thisGroup));
        outString.append("M  END\n$$$$");
        return outString.toString();
    }

    private Object getCharges(Group thisGroup) {
        List<Number> chargeList = GroupToSDF.getAtomCharges(thisGroup);
        StringBuilder outS = new StringBuilder();
        int chargeCount = 0;
        for (int i = 0; i < chargeList.size(); ++i) {
            short charge = (Short)chargeList.get(i);
            if (charge != 0) {
                if (chargeCount == 0) {
                    outS.append("M  CHG   N");
                }
                outS.append(this.getSpace(4, Integer.toString(i)) + (i + 1));
                outS.append(this.getSpace(4, Short.toString(charge)) + charge);
                ++chargeCount;
            }
            if (chargeCount != 8) continue;
            outS.append("\n");
            outS.replace(0, 10, "M  CHG   " + chargeCount);
            chargeCount = 0;
        }
        if (chargeCount == 0) {
            return "";
        }
        outS.replace(0, 10, "M  CHG  " + chargeCount);
        outS.append("\n");
        return outS.toString();
    }

    private static List<Number> getAtomCharges(Group group) {
        ArrayList<Number> outArr = new ArrayList<Number>();
        for (Atom a : group.getAtoms()) {
            outArr.add(a.getCharge());
        }
        return outArr;
    }

    private String getSpace(int inputNum, String format) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < inputNum - format.length(); ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }

    private String getHeader(Group thisGroup) {
        StringBuilder sb = new StringBuilder();
        sb.append(thisGroup.getPDBName() + "\n");
        sb.append("Made by BioJava");
        sb.append("\n");
        return sb.toString();
    }
}

