/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.quaternary.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.StructureIO;
import org.biojava.nbio.structure.align.util.AtomCache;
import org.biojava.nbio.structure.io.mmcif.model.PdbxStructAssembly;
import org.biojava.nbio.structure.io.mmcif.model.PdbxStructAssemblyGen;
import org.biojava.nbio.structure.io.mmcif.model.PdbxStructOperList;
import org.biojava.nbio.structure.quaternary.BiologicalAssemblyBuilder;
import org.biojava.nbio.structure.quaternary.BiologicalAssemblyTransformation;
import org.biojava.nbio.structure.quaternary.io.BioUnitDataProvider;
import org.biojava.nbio.structure.quaternary.io.MmCifPDBBiolAssemblyProvider;

public class MmCifBiolAssemblyProvider
implements BioUnitDataProvider {
    private MmCifPDBBiolAssemblyProvider provider = new MmCifPDBBiolAssemblyProvider();
    private AtomCache cache;

    @Override
    public Structure getAsymUnit(String pdbId) {
        this.provider.setPdbId(pdbId);
        Structure s1 = this.provider.getAsymUnit();
        return s1;
    }

    @Override
    public void setAsymUnit(Structure s) {
        this.provider.setAsymUnit(s);
    }

    @Override
    public List<BiologicalAssemblyTransformation> getBioUnitTransformationList(String pdbId, int biolAssemblyNr) {
        this.provider.setPdbId(pdbId);
        List<PdbxStructAssembly> psas = this.provider.getPdbxStructAssemblies();
        PdbxStructAssembly psa = null;
        if (psas.size() < biolAssemblyNr) {
            throw new IllegalArgumentException("Requested not existing biolAssemblyNr");
        }
        psa = psas.get(biolAssemblyNr - 1);
        List<PdbxStructAssemblyGen> psags = this.provider.getPdbxStructAssemblyGen(biolAssemblyNr - 1);
        if (psa == null || psags == null) {
            return null;
        }
        List<PdbxStructOperList> operators = this.provider.getPdbxStructOperList();
        BiologicalAssemblyBuilder builder = new BiologicalAssemblyBuilder();
        ArrayList<BiologicalAssemblyTransformation> transformations = builder.getBioUnitTransformationList(psa, psags, operators);
        return transformations;
    }

    @Override
    public int getNrBiolAssemblies(String pdbId) {
        this.provider.setPdbId(pdbId);
        return this.provider.getNrBiolAssemblies();
    }

    @Override
    public boolean hasBiolAssembly(String pdbId) {
        this.provider.setPdbId(pdbId);
        return this.provider.hasBiolAssembly();
    }

    public Structure getBiolAssembly(String pdbId, int biolAssemblyNr) throws IOException, StructureException {
        this.provider.setPdbId(pdbId);
        if (!this.provider.hasBiolAssembly()) {
            return null;
        }
        if (this.provider.getNrBiolAssemblies() <= biolAssemblyNr) {
            return null;
        }
        PdbxStructAssembly psa = this.provider.getPdbxStructAssembly(biolAssemblyNr);
        List<PdbxStructAssemblyGen> psags = this.provider.getPdbxStructAssemblyGen(biolAssemblyNr);
        List<PdbxStructOperList> operators = this.provider.getPdbxStructOperList();
        BiologicalAssemblyBuilder builder = new BiologicalAssemblyBuilder();
        ArrayList<BiologicalAssemblyTransformation> transformations = builder.getBioUnitTransformationList(psa, psags, operators);
        Structure asymUnit = null;
        if (this.provider instanceof MmCifPDBBiolAssemblyProvider) {
            MmCifPDBBiolAssemblyProvider mmcifprov = this.provider;
            asymUnit = mmcifprov.getAsymUnit();
        } else {
            asymUnit = StructureIO.getStructure(pdbId);
        }
        return builder.rebuildQuaternaryStructure(asymUnit, transformations);
    }

    @Override
    public void setAtomCache(AtomCache cache) {
        this.cache = cache;
        this.provider.setAtomCache(cache);
    }

    @Override
    public AtomCache getAtomCache() {
        return this.cache;
    }
}

