/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.rcsb;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.biojava.nbio.structure.align.client.JFatCatClient;
import org.biojava.nbio.structure.align.client.StructureName;
import org.biojava.nbio.structure.align.util.HTTPConnectionTools;
import org.biojava.nbio.structure.align.xml.RepresentativeXMLConverter;

public class GetRepresentatives {
    private static String clusterUrl = "http://www.rcsb.org/pdb/rest/representatives?cluster=";
    private static String allUrl = "http://www.rcsb.org/pdb/rest/getCurrent/";
    private static List<Integer> seqIdentities = Arrays.asList(30, 40, 50, 70, 90, 95, 100);

    public static SortedSet<StructureName> getRepresentatives(int sequenceIdentity) {
        TreeSet<StructureName> representatives = new TreeSet<StructureName>();
        if (!seqIdentities.contains(sequenceIdentity)) {
            System.err.println("Error: representative chains are not available for %sequence identity: " + sequenceIdentity);
            return representatives;
        }
        try {
            URL u = new URL(clusterUrl + sequenceIdentity);
            InputStream stream = HTTPConnectionTools.getInputStream(u, 60000);
            String xml = null;
            if (stream != null) {
                xml = JFatCatClient.convertStreamToString(stream);
                SortedSet<String> reps = RepresentativeXMLConverter.fromXML(xml);
                for (String s : reps) {
                    StructureName k = new StructureName(s);
                    representatives.add(k);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return representatives;
    }

    public static SortedSet<String> getAll() {
        TreeSet<String> representatives = new TreeSet<String>();
        try {
            URL u = new URL(allUrl);
            InputStream stream = HTTPConnectionTools.getInputStream(u, 60000);
            if (stream != null) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    int index = line.lastIndexOf("structureId=");
                    if (index <= 0) continue;
                    representatives.add(line.substring(index + 13, index + 17));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return representatives;
    }
}

