/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.core;

import java.util.List;
import javax.vecmath.Point3d;
import org.jgrapht.UndirectedGraph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.SimpleGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubunitGraph {
    private static final Logger logger = LoggerFactory.getLogger(SubunitGraph.class);
    private static final double DISTANCE_CUTOFF = 8.0;
    private static final int MIN_CONTACTS = 10;
    private List<Point3d[]> caCoords = null;

    public SubunitGraph(List<Point3d[]> caCoords) {
        this.caCoords = caCoords;
    }

    public UndirectedGraph<Integer, DefaultEdge> getProteinGraph() {
        int i;
        int n = this.caCoords.size();
        SimpleGraph graph = new SimpleGraph(DefaultEdge.class);
        for (i = 0; i < n; ++i) {
            graph.addVertex((Object)i);
        }
        for (i = 0; i < n - 1; ++i) {
            for (int j = i + 1; j < n; ++j) {
                int numContacts = this.calcContactNumber(this.caCoords.get(i), this.caCoords.get(j));
                logger.debug("Calpha contacts between subunits {},{}: {}", new Object[]{i, j, numContacts});
                if (numContacts < 10) continue;
                graph.addEdge((Object)i, (Object)j);
            }
        }
        return graph;
    }

    private int calcContactNumber(Point3d[] a, Point3d[] b) {
        double distCutoffSq = 64.0;
        int contacts = 0;
        for (Point3d pa : a) {
            for (Point3d pb : b) {
                if (!(pa.distanceSquared(pb) < distCutoffSq)) continue;
                ++contacts;
            }
        }
        return contacts;
    }
}

