/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.geometry;

import java.util.Arrays;
import java.util.List;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import org.biojava.nbio.structure.symmetry.geometry.Polyhedron;
import org.biojava.nbio.structure.symmetry.geometry.SuperPosition;

public class Tetrahedron
implements Polyhedron {
    private static double TETRAHEDRAL_ANGLE = Math.acos(-0.3333333333333333);
    private static int[] lineLoop1 = new int[]{0, 1, 2, 3, 0, 2};
    private static int[] lineLoop2 = new int[]{1, 3};
    private double circumscribedRadius = 1.0;

    @Override
    public double getCirumscribedRadius() {
        return this.circumscribedRadius;
    }

    public void setCirumscribedRadius(double cirumscribedRadius) {
        this.circumscribedRadius = cirumscribedRadius;
    }

    public double getInscribedRadius() {
        double side = Tetrahedron.getSideLengthFromCircumscribedRadius(this.circumscribedRadius);
        return Tetrahedron.getInscribedRadiusFromSideLength(side);
    }

    public void setInscribedRadius(double radius) {
        double side = Tetrahedron.getSideLengthFromInscribedRadius(radius);
        this.circumscribedRadius = Tetrahedron.getCircumscribedRadiusFromSideLength(side);
    }

    public double getMidRadius() {
        double side = Tetrahedron.getSideLengthFromCircumscribedRadius(this.circumscribedRadius);
        return Tetrahedron.getMiddleRadiusFromSideLength(side);
    }

    public void setMidRadius(double radius) {
        double side = Tetrahedron.getSideLengthFromMiddleRadius(radius);
        this.circumscribedRadius = Tetrahedron.getCircumscribedRadiusFromSideLength(side);
    }

    @Override
    public Point3d[] getVertices() {
        double x = Tetrahedron.getSideLengthFromCircumscribedRadius(this.circumscribedRadius) / 2.0;
        double z = x / Math.sqrt(2.0);
        Point3d[] tetrahedron = new Point3d[]{new Point3d(-x, 0.0, -z), new Point3d(x, 0.0, -z), new Point3d(0.0, -x, z), new Point3d(0.0, x, z)};
        Point3d centroid = SuperPosition.centroid(tetrahedron);
        Matrix3d m = new Matrix3d();
        m.rotX(0.5 * TETRAHEDRAL_ANGLE);
        for (Point3d p : tetrahedron) {
            p.sub((Tuple3d)centroid);
            m.transform((Tuple3d)p);
        }
        return tetrahedron;
    }

    @Override
    public List<int[]> getLineLoops() {
        return Arrays.asList(lineLoop1, lineLoop2);
    }

    @Override
    public int getViewCount() {
        return 3;
    }

    @Override
    public String getViewName(int index) {
        String name;
        switch (index) {
            case 0: {
                name = "Front 3-fold axis vertex-centered";
                break;
            }
            case 1: {
                name = "Back 3-fold axis face-centered";
                break;
            }
            case 2: {
                name = "Side 2-fold axis edge-centered";
                break;
            }
            default: {
                throw new IllegalArgumentException("getViewMatrix: index out of range:" + index);
            }
        }
        return name;
    }

    @Override
    public Matrix3d getViewMatrix(int index) {
        Matrix3d m = new Matrix3d();
        switch (index) {
            case 0: {
                m.setIdentity();
                break;
            }
            case 1: {
                m.rotX(Math.PI);
                break;
            }
            case 2: {
                double angle = Math.PI - 0.5 * TETRAHEDRAL_ANGLE;
                m.rotX(angle);
                break;
            }
            default: {
                throw new IllegalArgumentException("getViewMatrix: index out of range:" + index);
            }
        }
        return m;
    }

    private static double getSideLengthFromInscribedRadius(double radius) {
        return radius * Math.sqrt(24.0);
    }

    private static double getInscribedRadiusFromSideLength(double sideLength) {
        return sideLength / Math.sqrt(24.0);
    }

    private static double getSideLengthFromMiddleRadius(double radius) {
        return radius * Math.sqrt(8.0);
    }

    private static double getMiddleRadiusFromSideLength(double sideLength) {
        return sideLength / Math.sqrt(8.0);
    }

    private static double getSideLengthFromCircumscribedRadius(double radius) {
        return radius / Math.sqrt(0.375);
    }

    private static double getCircumscribedRadiusFromSideLength(double sideLength) {
        return sideLength * Math.sqrt(0.375);
    }
}

